/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MBeanWrapper {
    public static final Logger logger = LoggerFactory.getLogger(MBeanWrapper.class);
    public static final MBeanWrapper instance = Boolean.getBoolean("org.apache.cassandra.disable_mbean_registration") ? new NoOpMBeanWrapper() : new PlatformMBeanWrapper();

    public void registerMBean(Object var1, ObjectName var2, OnException var3);

    public void registerMBean(Object var1, ObjectName var2);

    public void registerMBean(Object var1, String var2, OnException var3);

    public void registerMBean(Object var1, String var2);

    public boolean isRegistered(ObjectName var1, OnException var2);

    public boolean isRegistered(ObjectName var1);

    public boolean isRegistered(String var1, OnException var2);

    public boolean isRegistered(String var1);

    public void unregisterMBean(ObjectName var1, OnException var2);

    public void unregisterMBean(ObjectName var1);

    public void unregisterMBean(String var1, OnException var2);

    public void unregisterMBean(String var1);

    public static interface Consumer<T> {
        public void accept(T var1);
    }

    public static enum OnException {
        THROW(new Consumer<Exception>(){

            @Override
            public void accept(Exception e) {
                throw new RuntimeException(e);
            }
        }),
        LOG(new Consumer<Exception>(){

            @Override
            public void accept(Exception e) {
                logger.error("Error in MBean wrapper: ", (Throwable)e);
            }
        }),
        IGNORE(new Consumer<Exception>(){

            @Override
            public void accept(Exception e) {
            }
        });

        private Consumer<Exception> handler;

        private OnException(Consumer<Exception> handler) {
            this.handler = handler;
        }
    }

    public static class PlatformMBeanWrapper
    implements MBeanWrapper {
        private final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.registerMBean(obj, mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName) {
            this.registerMBean(obj, mbeanName, OnException.THROW);
        }

        @Override
        public void registerMBean(Object obj, String mbeanName, OnException onException) {
            try {
                this.mbs.registerMBean(obj, new ObjectName(mbeanName));
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public void registerMBean(Object obj, String mbeanName) {
            this.registerMBean(obj, mbeanName, OnException.THROW);
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            try {
                return this.mbs.isRegistered(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName) {
            return this.isRegistered(mbeanName, OnException.THROW);
        }

        @Override
        public boolean isRegistered(String mbeanName, OnException onException) {
            try {
                return this.mbs.isRegistered(new ObjectName(mbeanName));
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public boolean isRegistered(String mbeanName) {
            return this.isRegistered(mbeanName, OnException.THROW);
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.unregisterMBean(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName) {
            this.unregisterMBean(mbeanName, OnException.THROW);
        }

        @Override
        public void unregisterMBean(String mbeanName, OnException onException) {
            try {
                this.mbs.unregisterMBean(new ObjectName(mbeanName));
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public void unregisterMBean(String mbeanName) {
            this.unregisterMBean(mbeanName, OnException.THROW);
        }
    }

    public static class NoOpMBeanWrapper
    implements MBeanWrapper {
        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName) {
        }

        @Override
        public void registerMBean(Object obj, String mbeanName, OnException onException) {
        }

        @Override
        public void registerMBean(Object obj, String mbeanName) {
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            return false;
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName) {
            return false;
        }

        @Override
        public boolean isRegistered(String mbeanName, OnException onException) {
            return false;
        }

        @Override
        public boolean isRegistered(String mbeanName) {
            return false;
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName) {
        }

        @Override
        public void unregisterMBean(String mbeanName, OnException onException) {
        }

        @Override
        public void unregisterMBean(String mbeanName) {
        }
    }
}

