/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Optional;
import java.io.IOException;

public class Throwables {
    public static Throwable merge(Throwable existingFail, Throwable newFail) {
        if (existingFail == null) {
            return newFail;
        }
        existingFail.addSuppressed(newFail);
        return existingFail;
    }

    public static void maybeFail(Throwable fail) {
        if (Throwables.failIfCanCast(fail, null)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> void maybeFail(Throwable fail, Class<T> checked) throws T {
        if (Throwables.failIfCanCast(fail, checked)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> boolean failIfCanCast(Throwable fail, Class<T> checked) throws T {
        if (fail == null) {
            return false;
        }
        if (fail instanceof Error) {
            throw (Error)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        if (checked != null && checked.isInstance(fail)) {
            throw (Throwable)checked.cast(fail);
        }
        return true;
    }

    public static Throwable close(Throwable accumulate, Iterable<? extends AutoCloseable> closeables) {
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public static Optional<IOException> extractIOExceptionCause(Throwable t) {
        if (t instanceof IOException) {
            return Optional.of((Object)((IOException)t));
        }
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof IOException)) continue;
            return Optional.of((Object)((IOException)cause));
        }
        return Optional.absent();
    }
}

