/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.WrappedDataOutputStreamPlus;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SequentialWriter
extends OutputStream
implements WritableByteChannel,
Transactional {
    protected boolean isDirty = false;
    protected boolean syncNeeded = false;
    private final String filePath;
    protected ByteBuffer buffer;
    private int directoryFD;
    private boolean directorySynced = false;
    protected long bufferOffset;
    protected final FileChannel channel;
    private boolean trickleFsync;
    private int trickleFsyncByteInterval;
    private int bytesSinceTrickleFsync = 0;
    public final DataOutputPlus stream;
    protected long lastFlushOffset;
    protected Runnable runPostFlush;
    private final TransactionalProxy txnProxy = this.txnProxy();
    private boolean finishOnClose;
    protected Descriptor descriptor;

    public SequentialWriter(File file, int bufferSize, BufferType bufferType) {
        try {
            this.channel = file.exists() ? FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE) : FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.filePath = file.getAbsolutePath();
        this.buffer = bufferType.allocate(bufferSize);
        this.trickleFsync = DatabaseDescriptor.getTrickleFsync();
        this.trickleFsyncByteInterval = DatabaseDescriptor.getTrickleFsyncIntervalInKb() * 1024;
        this.directoryFD = CLibrary.tryOpenDirectory(file.getParent());
        this.stream = new WrappedDataOutputStreamPlus(this, this);
    }

    public static SequentialWriter open(File file) {
        return new SequentialWriter(file, 65536, BufferType.ON_HEAP);
    }

    public static ChecksummedSequentialWriter open(File file, File crcPath) {
        return new ChecksummedSequentialWriter(file, 65536, crcPath);
    }

    public static CompressedSequentialWriter open(String dataFilePath, String offsetsPath, CompressionParameters parameters, MetadataCollector sstableMetadataCollector) {
        return new CompressedSequentialWriter(new File(dataFilePath), offsetsPath, parameters, sstableMetadataCollector);
    }

    public SequentialWriter finishOnClose() {
        this.finishOnClose = true;
        return this;
    }

    @Override
    public void write(int value) throws ClosedChannelException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
        }
        this.buffer.put((byte)value);
        this.isDirty = true;
        this.syncNeeded = true;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        int position = offset;
        int remaining = length;
        while (remaining > 0) {
            if (!this.buffer.hasRemaining()) {
                this.reBuffer();
            }
            int toCopy = Math.min(remaining, this.buffer.remaining());
            this.buffer.put(data, position, toCopy);
            remaining -= toCopy;
            position += toCopy;
            this.isDirty = true;
            this.syncNeeded = true;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        int length = src.remaining();
        int finalLimit = src.limit();
        while (src.hasRemaining()) {
            if (!this.buffer.hasRemaining()) {
                this.reBuffer();
            }
            if (this.buffer.remaining() < src.remaining()) {
                src.limit(src.position() + this.buffer.remaining());
            }
            this.buffer.put(src);
            src.limit(finalLimit);
            this.isDirty = true;
            this.syncNeeded = true;
        }
        return length;
    }

    public void sync() {
        this.syncInternal();
    }

    protected void syncDataOnlyInternal() {
        try {
            SyncUtil.force(this.channel, false);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    protected void syncInternal() {
        if (this.syncNeeded) {
            this.flushInternal();
            this.syncDataOnlyInternal();
            if (!this.directorySynced) {
                SyncUtil.trySync(this.directoryFD);
                this.directorySynced = true;
            }
            this.syncNeeded = false;
        }
    }

    @Override
    public void flush() {
        this.flushInternal();
    }

    protected void flushInternal() {
        if (this.isDirty) {
            this.flushData();
            if (this.trickleFsync) {
                this.bytesSinceTrickleFsync += this.buffer.position();
                if (this.bytesSinceTrickleFsync >= this.trickleFsyncByteInterval) {
                    this.syncDataOnlyInternal();
                    this.bytesSinceTrickleFsync = 0;
                }
            }
            this.resetBuffer();
            this.isDirty = false;
        }
    }

    public void setPostFlushListener(Runnable runPostFlush) {
        assert (this.runPostFlush == null);
        this.runPostFlush = runPostFlush;
    }

    protected void flushData() {
        try {
            this.buffer.flip();
            this.channel.write(this.buffer);
            this.lastFlushOffset += (long)this.buffer.position();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        if (this.runPostFlush != null) {
            this.runPostFlush.run();
        }
    }

    public long getFilePointer() {
        return this.current();
    }

    public long getOnDiskFilePointer() {
        return this.getFilePointer();
    }

    public long length() {
        try {
            return Math.max(this.current(), this.channel.size());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    public String getPath() {
        return this.filePath;
    }

    protected void reBuffer() {
        this.flushInternal();
        this.resetBuffer();
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current();
        this.buffer.clear();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    public FileMark mark() {
        return new BufferedFileWriterMark(this.current());
    }

    public void resetAndTruncate(FileMark mark) {
        long truncateTarget;
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current();
        if (previous - (truncateTarget = ((BufferedFileWriterMark)mark).pointer) <= (long)this.buffer.position()) {
            this.buffer.position(this.buffer.position() - (int)(previous - truncateTarget));
            return;
        }
        this.syncInternal();
        this.truncate(truncateTarget);
        try {
            this.channel.position(truncateTarget);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.bufferOffset = truncateTarget;
        this.resetBuffer();
    }

    public long getLastFlushOffset() {
        return this.lastFlushOffset;
    }

    public void truncate(long toSize) {
        try {
            this.channel.truncate(toSize);
            this.lastFlushOffset = toSize;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SequentialWriter setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Override
    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    @Override
    public final Throwable commit(Throwable accumulate) {
        return this.txnProxy.commit(accumulate);
    }

    @Override
    public final Throwable abort(Throwable accumulate) {
        return this.txnProxy.abort(accumulate);
    }

    @Override
    public final void close() {
        if (this.finishOnClose) {
            this.txnProxy.finish();
        } else {
            this.txnProxy.close();
        }
    }

    public final void finish() {
        this.txnProxy.finish();
    }

    protected TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    public void releaseFileHandle() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.filePath);
        }
    }

    protected static class BufferedFileWriterMark
    implements FileMark {
        final long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }

    protected class TransactionalProxy
    extends Transactional.AbstractTransactional {
        protected TransactionalProxy() {
        }

        @Override
        protected Throwable doPreCleanup(Throwable accumulate) {
            if (SequentialWriter.this.directoryFD >= 0) {
                try {
                    CLibrary.tryCloseFD(SequentialWriter.this.directoryFD);
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
                SequentialWriter.this.directoryFD = -1;
            }
            try {
                SequentialWriter.this.channel.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
            if (SequentialWriter.this.buffer != null) {
                try {
                    FileUtils.clean(SequentialWriter.this.buffer);
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
                SequentialWriter.this.buffer = null;
            }
            return accumulate;
        }

        @Override
        protected void doPrepare() {
            SequentialWriter.this.syncInternal();
            SequentialWriter.this.releaseFileHandle();
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return FileUtils.deleteWithConfirm(SequentialWriter.this.filePath, false, accumulate);
        }
    }
}

