/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;

public class IndexTarget {
    public final ColumnIdentifier column;
    public final TargetType type;

    private IndexTarget(ColumnIdentifier column, TargetType type) {
        this.column = column;
        this.type = type;
    }

    public static enum TargetType {
        VALUES,
        KEYS,
        KEYS_AND_VALUES,
        FULL;


        public String toString() {
            switch (this) {
                case KEYS: {
                    return "keys";
                }
                case KEYS_AND_VALUES: {
                    return "entries";
                }
                case FULL: {
                    return "full";
                }
            }
            return "values";
        }

        public String indexOption() {
            switch (this) {
                case KEYS: {
                    return "index_keys";
                }
                case KEYS_AND_VALUES: {
                    return "index_keys_and_values";
                }
                case VALUES: {
                    return "index_values";
                }
            }
            throw new AssertionError();
        }

        public static TargetType fromColumnDefinition(ColumnDefinition cd) {
            Map<String, String> options = cd.getIndexOptions();
            if (options.containsKey("index_keys")) {
                return KEYS;
            }
            if (options.containsKey("index_keys_and_values")) {
                return KEYS_AND_VALUES;
            }
            if (cd.type.isCollection() && !cd.type.isMultiCell()) {
                return FULL;
            }
            return VALUES;
        }
    }

    public static class Raw {
        private final ColumnIdentifier.Raw column;
        private final TargetType type;

        private Raw(ColumnIdentifier.Raw column, TargetType type) {
            this.column = column;
            this.type = type;
        }

        public static Raw valuesOf(ColumnIdentifier.Raw c) {
            return new Raw(c, TargetType.VALUES);
        }

        public static Raw keysOf(ColumnIdentifier.Raw c) {
            return new Raw(c, TargetType.KEYS);
        }

        public static Raw keysAndValuesOf(ColumnIdentifier.Raw c) {
            return new Raw(c, TargetType.KEYS_AND_VALUES);
        }

        public static Raw fullCollection(ColumnIdentifier.Raw c) {
            return new Raw(c, TargetType.FULL);
        }

        public IndexTarget prepare(CFMetaData cfm) {
            return new IndexTarget(this.column.prepare(cfm), this.type);
        }
    }
}

