/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class ReversedType<T>
extends AbstractType<T> {
    private static final Map<AbstractType<?>, ReversedType> instances = new HashMap();
    public final AbstractType<T> baseType;

    public static <T> ReversedType<T> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> types = parser.getTypeParameters();
        if (types.size() != 1) {
            throw new ConfigurationException("ReversedType takes exactly one argument, " + types.size() + " given");
        }
        return ReversedType.getInstance(types.get(0));
    }

    public static synchronized <T> ReversedType<T> getInstance(AbstractType<T> baseType) {
        ReversedType<T> type = instances.get(baseType);
        if (type == null) {
            type = new ReversedType<T>(baseType);
            instances.put(baseType, type);
        }
        return type;
    }

    private ReversedType(AbstractType<T> baseType) {
        this.baseType = baseType;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return this.baseType.isEmptyValueMeaningless();
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return this.baseType.compare(o2, o1);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return this.baseType.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.baseType.fromString(source);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        return this.baseType.fromJSONObject(parsed);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return this.baseType.toJSONString(buffer, protocolVersion);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> otherType) {
        if (!(otherType instanceof ReversedType)) {
            return false;
        }
        return this.baseType.isCompatibleWith(((ReversedType)otherType).baseType);
    }

    @Override
    public boolean isValueCompatibleWith(AbstractType<?> otherType) {
        return this.baseType.isValueCompatibleWith(otherType);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return this.baseType.asCQL3Type();
    }

    @Override
    public TypeSerializer<T> getSerializer() {
        return this.baseType.getSerializer();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.baseType + ")";
    }
}

