/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;

public class ColumnCounter {
    protected int live;
    protected int tombstones;
    protected final long timestamp;

    public ColumnCounter(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean count(Cell cell, DeletionInfo.InOrderTester tester) {
        if (tester.isDeleted(cell)) {
            return false;
        }
        if (cell.isLive(this.timestamp)) {
            ++this.live;
        } else {
            ++this.tombstones;
        }
        return true;
    }

    public int live() {
        return this.live;
    }

    public int tombstones() {
        return this.tombstones;
    }

    public ColumnCounter countAll(ColumnFamily container) {
        if (container == null) {
            return this;
        }
        DeletionInfo.InOrderTester tester = container.inOrderDeletionTester();
        for (Cell c : container) {
            this.count(c, tester);
        }
        return this;
    }

    public static class GroupByPrefixReversed
    extends GroupByPrefix {
        public GroupByPrefixReversed(long timestamp, CellNameType type, int toGroup) {
            super(timestamp, type, toGroup);
        }

        @Override
        public boolean count(Cell cell, DeletionInfo.InOrderTester tester) {
            if (tester.isDeleted(cell)) {
                return false;
            }
            if (!cell.isLive(this.timestamp)) {
                ++this.tombstones;
                return true;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return true;
            }
            CellName current = cell.name();
            assert (current.size() >= this.toGroup);
            if (this.previous == null) {
                this.previous = current;
                ++this.live;
            } else if (!current.isStatic()) {
                for (int i = 0; i < this.toGroup; ++i) {
                    if (this.type.subtype(i).compare(this.previous.get(i), current.get(i)) == 0) continue;
                    ++this.live;
                    this.previous = current;
                    return true;
                }
            }
            return true;
        }
    }

    public static class GroupByPrefix
    extends ColumnCounter {
        protected final CellNameType type;
        protected final int toGroup;
        protected CellName previous;

        public GroupByPrefix(long timestamp, CellNameType type, int toGroup) {
            super(timestamp);
            this.type = type;
            this.toGroup = toGroup;
            assert (toGroup == 0 || type != null);
        }

        @Override
        public boolean count(Cell cell, DeletionInfo.InOrderTester tester) {
            if (tester.isDeleted(cell)) {
                return false;
            }
            if (!cell.isLive(this.timestamp)) {
                ++this.tombstones;
                return true;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return true;
            }
            CellName current = cell.name();
            assert (current.size() >= this.toGroup);
            if (this.previous != null) {
                boolean isSameGroup;
                boolean bl = isSameGroup = this.previous.isStatic() == current.isStatic();
                if (isSameGroup) {
                    for (int i = 0; i < this.toGroup; ++i) {
                        if (this.type.subtype(i).compare(this.previous.get(i), current.get(i)) == 0) continue;
                        isSameGroup = false;
                        break;
                    }
                }
                if (isSameGroup) {
                    return true;
                }
                if (this.previous.isStatic()) {
                    this.previous = current;
                    return true;
                }
            }
            ++this.live;
            this.previous = current;
            return true;
        }
    }
}

