/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompactionWriter
extends CompactionAwareWriter {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCompactionWriter.class);

    public DefaultCompactionWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline, OperationType compactionType) {
        super(cfs, txn, nonExpiredSSTables, offline);
        logger.debug("Expected bloom filter size : {}", (Object)this.estimatedTotalKeys);
        long expectedWriteSize = cfs.getExpectedCompactedFileSize(nonExpiredSSTables, compactionType);
        File sstableDirectory = cfs.directories.getLocationForDisk(this.getWriteDirectory(expectedWriteSize));
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(cfs.getTempSSTablePath(sstableDirectory)), this.estimatedTotalKeys, (Long)this.minRepairedAt, cfs.metadata, cfs.partitioner, new MetadataCollector(txn.originals(), cfs.metadata.comparator, 0));
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    public boolean append(AbstractCompactedRow row) {
        return this.sstableWriter.append(row) != null;
    }

    @Override
    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }
}

