/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public final class CreateAggregateStatement
extends SchemaAlteringStatement {
    private final boolean orReplace;
    private final boolean ifNotExists;
    private FunctionName functionName;
    private FunctionName stateFunc;
    private FunctionName finalFunc;
    private final CQL3Type.Raw stateTypeRaw;
    private final List<CQL3Type.Raw> argRawTypes;
    private final Term.Raw ival;
    private UDAggregate udAggregate;
    private boolean replaced;
    private List<AbstractType<?>> argTypes;
    private AbstractType<?> returnType;
    private ScalarFunction stateFunction;
    private ScalarFunction finalFunction;
    private ByteBuffer initcond;

    public CreateAggregateStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, FunctionName stateFunc, CQL3Type.Raw stateType, FunctionName finalFunc, Term.Raw ival, boolean orReplace, boolean ifNotExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.stateFunc = stateFunc;
        this.finalFunc = finalFunc;
        this.stateTypeRaw = stateType;
        this.ival = ival;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() {
        this.argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            this.argTypes.add(this.prepareType("arguments", rawType));
        }
        AbstractType<?> stateType = this.prepareType("state type", this.stateTypeRaw);
        List<AbstractType<?>> stateArgs = CreateAggregateStatement.stateArguments(stateType, this.argTypes);
        this.stateFunc = this.validateFunctionKeyspace(this.stateFunc);
        Function f = Functions.find(this.stateFunc, stateArgs);
        if (!(f instanceof ScalarFunction)) {
            throw new InvalidRequestException("State function " + CreateAggregateStatement.stateFuncSig(this.stateFunc, this.stateTypeRaw, this.argRawTypes) + " does not exist or is not a scalar function");
        }
        this.stateFunction = (ScalarFunction)f;
        AbstractType<?> stateReturnType = this.stateFunction.returnType();
        if (!stateReturnType.equals(stateType)) {
            throw new InvalidRequestException("State function " + CreateAggregateStatement.stateFuncSig(this.stateFunction.name(), this.stateTypeRaw, this.argRawTypes) + " return type must be the same as the first argument type - check STYPE, argument and return types");
        }
        if (this.finalFunc != null) {
            List<AbstractType<?>> finalArgs = Collections.singletonList(stateType);
            this.finalFunc = this.validateFunctionKeyspace(this.finalFunc);
            f = Functions.find(this.finalFunc, finalArgs);
            if (!(f instanceof ScalarFunction)) {
                throw new InvalidRequestException("Final function " + this.finalFunc + '(' + this.stateTypeRaw + ") does not exist or is not a scalar function");
            }
            this.finalFunction = (ScalarFunction)f;
            this.returnType = this.finalFunction.returnType();
        } else {
            this.returnType = stateReturnType;
        }
        if (this.ival != null) {
            ColumnSpecification receiver = new ColumnSpecification(this.functionName.keyspace, "--dummy--", new ColumnIdentifier("(aggregate_initcond)", true), stateType);
            this.initcond = this.ival.prepare(this.functionName.keyspace, receiver).bindAndGet(QueryOptions.DEFAULT);
            if (Constants.NULL_LITERAL != this.ival && UDHelper.isNullOrEmpty(stateType, this.initcond)) {
                throw new InvalidRequestException("INITCOND must not be empty for all types except TEXT, ASCII, BLOB");
            }
        }
        return super.prepare();
    }

    private AbstractType<?> prepareType(String typeName, CQL3Type.Raw rawType) {
        if (rawType.isFrozen()) {
            throw new InvalidRequestException(String.format("The function %s should not be frozen; remove the frozen<> modifier", typeName));
        }
        if (!rawType.canBeNonFrozen()) {
            rawType.freeze();
        }
        AbstractType<?> type = rawType.prepare(this.functionName.keyspace).getType();
        return type;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem(this.functionName.keyspace);
    }

    private FunctionName validateFunctionKeyspace(FunctionName func) {
        if (!func.hasKeyspace()) {
            return new FunctionName(this.functionName.keyspace, func.name);
        }
        if (!"system".equals(func.keyspace) && !this.functionName.keyspace.equals(func.keyspace)) {
            throw new InvalidRequestException(String.format("Statement on keyspace %s cannot refer to a user function in keyspace %s; user functions can only be used in the keyspace they are defined in", this.functionName.keyspace, func.keyspace));
        }
        return func;
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            FunctionResource resource = FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes);
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, RoleResource.role(state.getClientState().getUser().getName()));
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (Functions.find(this.functionName, this.argTypes) != null && this.orReplace) {
            state.ensureHasPermission(Permission.ALTER, FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes));
        } else {
            state.ensureHasPermission(Permission.CREATE, FunctionResource.keyspace(this.functionName.keyspace));
        }
        for (Function referencedFunction : this.stateFunction.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, referencedFunction);
        }
        if (this.finalFunction != null) {
            for (Function referencedFunction : this.finalFunction.getFunctions()) {
                state.ensureHasPermission(Permission.EXECUTE, referencedFunction);
            }
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.ifNotExists && this.orReplace) {
            throw new InvalidRequestException("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives");
        }
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) == null) {
            throw new InvalidRequestException(String.format("Cannot add aggregate '%s' to non existing keyspace '%s'.", this.functionName.name, this.functionName.keyspace));
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(this.replaced ? Event.SchemaChange.Change.UPDATED : Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.AGGREGATE, this.udAggregate.name().keyspace, this.udAggregate.name().name, AbstractType.asCQLTypeStringList(this.udAggregate.argTypes()));
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Function old = Functions.find(this.functionName, this.argTypes);
        if (old != null) {
            if (this.ifNotExists) {
                return false;
            }
            if (!this.orReplace) {
                throw new InvalidRequestException(String.format("Function %s already exists", old));
            }
            if (!(old instanceof AggregateFunction)) {
                throw new InvalidRequestException(String.format("Aggregate %s can only replace an aggregate", old));
            }
            if (old.isNative()) {
                throw new InvalidRequestException(String.format("Cannot replace native aggregate %s", old));
            }
            if (!old.returnType().isValueCompatibleWith(this.returnType)) {
                throw new InvalidRequestException(String.format("Cannot replace aggregate %s, the new return type %s is not compatible with the return type %s of existing function", this.functionName, this.returnType.asCQL3Type(), old.returnType().asCQL3Type()));
            }
        }
        if (!this.stateFunction.isCalledOnNullInput() && this.initcond == null) {
            throw new InvalidRequestException(String.format("Cannot create aggregate %s without INITCOND because state function %s does not accept 'null' arguments", this.functionName, this.stateFunc));
        }
        this.udAggregate = new UDAggregate(this.functionName, this.argTypes, this.returnType, this.stateFunction, this.finalFunction, this.initcond);
        this.replaced = old != null;
        MigrationManager.announceNewAggregate(this.udAggregate, isLocalOnly);
        return true;
    }

    private static String stateFuncSig(FunctionName stateFuncName, CQL3Type.Raw stateTypeRaw, List<CQL3Type.Raw> argRawTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(stateFuncName.toString()).append('(').append(stateTypeRaw);
        for (CQL3Type.Raw argRawType : argRawTypes) {
            sb.append(", ").append(argRawType);
        }
        sb.append(')');
        return sb.toString();
    }

    private static List<AbstractType<?>> stateArguments(AbstractType<?> stateType, List<AbstractType<?>> argTypes) {
        ArrayList r = new ArrayList(argTypes.size() + 1);
        r.add(stateType);
        r.addAll(argTypes);
        return r;
    }
}

