/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.SelectionColumns;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Selection {
    private static final Predicate<ColumnDefinition> STATIC_COLUMN_FILTER = new Predicate<ColumnDefinition>(){

        public boolean apply(ColumnDefinition def) {
            return def.isStatic();
        }
    };
    private final CFMetaData cfm;
    private final List<ColumnDefinition> columns;
    private final SelectionColumnMapping columnMapping;
    private final ResultSet.ResultMetadata metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping columnMapping, boolean collectTimestamps, boolean collectTTLs) {
        this.cfm = cfm;
        this.columns = columns;
        this.columnMapping = columnMapping;
        this.metadata = new ResultSet.ResultMetadata(columnMapping.getColumnSpecifications());
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean containsStaticColumns() {
        if (!this.cfm.hasStaticColumns()) {
            return false;
        }
        if (this.isWildcard()) {
            return true;
        }
        return !Iterables.isEmpty((Iterable)Iterables.filter(this.columns, STATIC_COLUMN_FILTER));
    }

    public boolean containsOnlyStaticColumns() {
        if (!this.containsStaticColumns()) {
            return false;
        }
        if (this.isWildcard()) {
            return false;
        }
        for (ColumnDefinition def : this.getColumns()) {
            if (def.isPartitionKey() || def.isStatic()) continue;
            return false;
        }
        return true;
    }

    public boolean containsACollection() {
        if (!this.cfm.comparator.hasCollections()) {
            return false;
        }
        for (ColumnDefinition def : this.getColumns()) {
            if (!def.type.isCollection() || !def.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    public int indexOf(final ColumnDefinition def) {
        return Iterators.indexOf(this.getColumns().iterator(), (Predicate)new Predicate<ColumnDefinition>(){

            public boolean apply(ColumnDefinition n) {
                return def.name.equals(n.name);
            }
        });
    }

    public ResultSet.ResultMetadata getResultMetadata(boolean isJson) {
        if (!isJson) {
            return this.metadata;
        }
        ColumnSpecification firstColumn = this.metadata.names.get(0);
        ColumnSpecification jsonSpec = new ColumnSpecification(firstColumn.ksName, firstColumn.cfName, Json.JSON_COLUMN_ID, UTF8Type.instance);
        return new ResultSet.ResultMetadata(Arrays.asList(jsonSpec));
    }

    public static Selection wildcard(CFMetaData cfm) {
        ArrayList<ColumnDefinition> all = new ArrayList<ColumnDefinition>(cfm.allColumns().size());
        Iterators.addAll(all, cfm.allColumnsInSelectOrder());
        return new SimpleSelection(cfm, all, true);
    }

    public static Selection forColumns(CFMetaData cfm, List<ColumnDefinition> columns) {
        return new SimpleSelection(cfm, columns, false);
    }

    public int addColumnForOrdering(ColumnDefinition c) {
        this.columns.add(c);
        this.metadata.addNonSerializedColumn(c);
        return this.columns.size() - 1;
    }

    public Iterable<Function> getFunctions() {
        return Collections.emptySet();
    }

    private static boolean processesSelection(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (!rawSelector.processesSelection()) continue;
            return true;
        }
        return false;
    }

    public static Selection fromSelectors(CFMetaData cfm, List<RawSelector> rawSelectors) throws InvalidRequestException {
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(RawSelector.toSelectables(rawSelectors, cfm), cfm, defs);
        SelectionColumnMapping mapping = Selection.collectColumnMappings(cfm, rawSelectors, factories);
        return Selection.processesSelection(rawSelectors) || rawSelectors.size() != defs.size() ? new SelectionWithProcessing(cfm, defs, mapping, factories) : new SimpleSelection(cfm, defs, mapping, false);
    }

    private static SelectionColumnMapping collectColumnMappings(CFMetaData cfm, List<RawSelector> rawSelectors, SelectorFactories factories) {
        SelectionColumnMapping selectionColumns = SelectionColumnMapping.newMapping();
        Iterator<RawSelector> iter = rawSelectors.iterator();
        for (Selector.Factory factory : factories) {
            ColumnSpecification colSpec = factory.getColumnSpecification(cfm);
            ColumnIdentifier alias = iter.next().alias;
            factory.addColumnMapping(selectionColumns, alias == null ? colSpec : colSpec.withAlias(alias));
        }
        return selectionColumns;
    }

    protected abstract Selectors newSelectors() throws InvalidRequestException;

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public SelectionColumns getColumnMapping() {
        return this.columnMapping;
    }

    public ResultSetBuilder resultSetBuilder(long now, boolean isJson) throws InvalidRequestException {
        return new ResultSetBuilder(now, isJson);
    }

    public abstract boolean isAggregate();

    public String toString() {
        return Objects.toStringHelper((Object)this).add("columns", this.columns).add("columnMapping", (Object)this.columnMapping).add("metadata", (Object)this.metadata).add("collectTimestamps", this.collectTimestamps).add("collectTTLs", this.collectTTLs).toString();
    }

    private static class SelectionWithProcessing
    extends Selection {
        private final SelectorFactories factories;

        public SelectionWithProcessing(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping metadata, SelectorFactories factories) throws InvalidRequestException {
            super(cfm, columns, metadata, factories.containsWritetimeSelectorFactory(), factories.containsTTLSelectorFactory());
            this.factories = factories;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.factories.getFunctions();
        }

        @Override
        public int addColumnForOrdering(ColumnDefinition c) {
            int index = super.addColumnForOrdering(c);
            this.factories.addSelectorForOrdering(c, index);
            return index;
        }

        @Override
        public boolean isAggregate() {
            return this.factories.doesAggregation();
        }

        @Override
        protected Selectors newSelectors() throws InvalidRequestException {
            return new Selectors(){
                private final List<Selector> selectors;
                {
                    this.selectors = SelectionWithProcessing.this.factories.newInstances();
                }

                @Override
                public void reset() {
                    for (Selector selector : this.selectors) {
                        selector.reset();
                    }
                }

                @Override
                public boolean isAggregate() {
                    return SelectionWithProcessing.this.factories.doesAggregation();
                }

                @Override
                public List<ByteBuffer> getOutputRow(int protocolVersion) throws InvalidRequestException {
                    ArrayList<ByteBuffer> outputRow = new ArrayList<ByteBuffer>(this.selectors.size());
                    for (Selector selector : this.selectors) {
                        outputRow.add(selector.getOutput(protocolVersion));
                    }
                    return outputRow;
                }

                @Override
                public void addInputRow(int protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
                    for (Selector selector : this.selectors) {
                        selector.addInput(protocolVersion, rs);
                    }
                }
            };
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(CFMetaData cfm, List<ColumnDefinition> columns, boolean isWildcard) {
            this(cfm, columns, SelectionColumnMapping.simpleMapping(columns), isWildcard);
        }

        public SimpleSelection(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping metadata, boolean isWildcard) {
            super(cfm, columns, metadata, false, false);
            this.isWildcard = isWildcard;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }

        @Override
        public boolean isAggregate() {
            return false;
        }

        @Override
        protected Selectors newSelectors() {
            return new Selectors(){
                private List<ByteBuffer> current;

                @Override
                public void reset() {
                    this.current = null;
                }

                @Override
                public List<ByteBuffer> getOutputRow(int protocolVersion) {
                    return this.current;
                }

                @Override
                public void addInputRow(int protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
                    this.current = rs.current;
                }

                @Override
                public boolean isAggregate() {
                    return false;
                }
            };
        }
    }

    private static interface Selectors {
        public boolean isAggregate();

        public void addInputRow(int var1, ResultSetBuilder var2) throws InvalidRequestException;

        public List<ByteBuffer> getOutputRow(int var1) throws InvalidRequestException;

        public void reset();
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        private final Selectors selectors;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;
        final long now;
        private final boolean isJson;

        private ResultSetBuilder(long now, boolean isJson) throws InvalidRequestException {
            this.resultSet = new ResultSet(Selection.this.getResultMetadata(isJson).copy(), new ArrayList<List<ByteBuffer>>());
            this.selectors = Selection.this.newSelectors();
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columns.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columns.size()] : null;
            this.now = now;
            this.isJson = isJson;
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(Cell c) {
            this.current.add(this.isDead(c) ? null : this.value(c));
            if (this.timestamps != null) {
                long l = this.timestamps[this.current.size() - 1] = this.isDead(c) ? Long.MIN_VALUE : c.timestamp();
            }
            if (this.ttls != null) {
                int ttl = -1;
                if (!this.isDead(c) && c instanceof ExpiringCell) {
                    ttl = c.getLocalDeletionTime() - (int)(this.now / 1000L);
                }
                this.ttls[this.current.size() - 1] = ttl;
            }
        }

        private boolean isDead(Cell c) {
            return c == null || !c.isLive(this.now);
        }

        public void newRow(int protocolVersion) throws InvalidRequestException {
            if (this.current != null) {
                this.selectors.addInputRow(protocolVersion, this);
                if (!this.selectors.isAggregate()) {
                    this.resultSet.addRow(this.getOutputRow(protocolVersion));
                    this.selectors.reset();
                }
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columns.size());
        }

        public ResultSet build(int protocolVersion) throws InvalidRequestException {
            if (this.current != null) {
                this.selectors.addInputRow(protocolVersion, this);
                this.resultSet.addRow(this.getOutputRow(protocolVersion));
                this.selectors.reset();
                this.current = null;
            }
            if (this.resultSet.isEmpty() && this.selectors.isAggregate()) {
                this.resultSet.addRow(this.getOutputRow(protocolVersion));
            }
            return this.resultSet;
        }

        private List<ByteBuffer> getOutputRow(int protocolVersion) {
            List<ByteBuffer> outputRow = this.selectors.getOutputRow(protocolVersion);
            return this.isJson ? this.rowToJson(outputRow, protocolVersion) : outputRow;
        }

        private List<ByteBuffer> rowToJson(List<ByteBuffer> row, int protocolVersion) {
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < ((Selection)Selection.this).metadata.names.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                ColumnSpecification spec = ((Selection)Selection.this).metadata.names.get(i);
                String columnName = spec.name.toString();
                if (!columnName.equals(columnName.toLowerCase(Locale.US))) {
                    columnName = "\"" + columnName + "\"";
                }
                ByteBuffer buffer = row.get(i);
                sb.append('\"');
                sb.append(Json.JSON_STRING_ENCODER.quoteAsString(columnName));
                sb.append("\": ");
                if (buffer == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(spec.type.toJSONString(buffer, protocolVersion));
            }
            sb.append("}");
            return Collections.singletonList(UTF8Type.instance.getSerializer().serialize(sb.toString()));
        }

        private ByteBuffer value(Cell c) {
            return c instanceof CounterCell ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
        }
    }
}

