/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairOption {
    public static final String PARALLELISM_KEY = "parallelism";
    public static final String PRIMARY_RANGE_KEY = "primaryRange";
    public static final String INCREMENTAL_KEY = "incremental";
    public static final String JOB_THREADS_KEY = "jobThreads";
    public static final String RANGES_KEY = "ranges";
    public static final String COLUMNFAMILIES_KEY = "columnFamilies";
    public static final String DATACENTERS_KEY = "dataCenters";
    public static final String HOSTS_KEY = "hosts";
    public static final String TRACE_KEY = "trace";
    public static final int MAX_JOB_THREADS = 4;
    private static final Logger logger = LoggerFactory.getLogger(RepairOption.class);
    private final RepairParallelism parallelism;
    private final boolean primaryRange;
    private final boolean incremental;
    private final boolean trace;
    private final int jobThreads;
    private final Collection<String> columnFamilies = new HashSet<String>();
    private final Collection<String> dataCenters = new HashSet<String>();
    private final Collection<String> hosts = new HashSet<String>();
    private final Collection<Range<Token>> ranges = new HashSet<Range<Token>>();

    public static RepairOption parse(Map<String, String> options, IPartitioner partitioner) {
        String cfStr;
        RepairParallelism parallelism = RepairParallelism.fromName(options.get(PARALLELISM_KEY));
        boolean primaryRange = Boolean.parseBoolean(options.get(PRIMARY_RANGE_KEY));
        boolean incremental = Boolean.parseBoolean(options.get(INCREMENTAL_KEY));
        boolean trace = Boolean.parseBoolean(options.get(TRACE_KEY));
        int jobThreads = 1;
        if (options.containsKey(JOB_THREADS_KEY)) {
            try {
                jobThreads = Integer.parseInt(options.get(JOB_THREADS_KEY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String rangesStr = options.get(RANGES_KEY);
        HashSet<Range<Token>> ranges = new HashSet<Range<Token>>();
        if (rangesStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(rangesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                String[] rangeStr = tokenizer.nextToken().split(":", 2);
                if (rangeStr.length < 2) continue;
                Token parsedBeginToken = partitioner.getTokenFactory().fromString(rangeStr[0].trim());
                Token parsedEndToken = partitioner.getTokenFactory().fromString(rangeStr[1].trim());
                ranges.add(new Range<Token>(parsedBeginToken, parsedEndToken));
            }
        }
        RepairOption option = new RepairOption(parallelism, primaryRange, incremental, trace, jobThreads, ranges);
        String dataCentersStr = options.get(DATACENTERS_KEY);
        HashSet<String> dataCenters = new HashSet<String>();
        if (dataCentersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(dataCentersStr, ",");
            while (tokenizer.hasMoreTokens()) {
                dataCenters.add(tokenizer.nextToken().trim());
            }
            option.getDataCenters().addAll(dataCenters);
        }
        String hostsStr = options.get(HOSTS_KEY);
        HashSet<String> hosts = new HashSet<String>();
        if (hostsStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(hostsStr, ",");
            while (tokenizer.hasMoreTokens()) {
                hosts.add(tokenizer.nextToken().trim());
            }
            option.getHosts().addAll(hosts);
        }
        if ((cfStr = options.get(COLUMNFAMILIES_KEY)) != null) {
            HashSet<String> columnFamilies = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(cfStr, ",");
            while (tokenizer.hasMoreTokens()) {
                columnFamilies.add(tokenizer.nextToken().trim());
            }
            option.getColumnFamilies().addAll(columnFamilies);
        }
        if (jobThreads > 4) {
            throw new IllegalArgumentException("Too many job threads. Max is 4");
        }
        if (!(!primaryRange || dataCenters.isEmpty() && hosts.isEmpty())) {
            throw new IllegalArgumentException("You need to run primary range repair on all nodes in the cluster.");
        }
        return option;
    }

    public RepairOption(RepairParallelism parallelism, boolean primaryRange, boolean incremental, boolean trace, int jobThreads, Collection<Range<Token>> ranges) {
        if (FBUtilities.isWindows() && (DatabaseDescriptor.getDiskAccessMode() != Config.DiskAccessMode.standard || DatabaseDescriptor.getIndexAccessMode() != Config.DiskAccessMode.standard) && parallelism == RepairParallelism.SEQUENTIAL) {
            logger.warn("Sequential repair disabled when memory-mapped I/O is configured on Windows. Reverting to parallel.");
            this.parallelism = RepairParallelism.PARALLEL;
        } else {
            this.parallelism = parallelism;
        }
        this.primaryRange = primaryRange;
        this.incremental = incremental;
        this.trace = trace;
        this.jobThreads = jobThreads;
        this.ranges.addAll(ranges);
    }

    public RepairParallelism getParallelism() {
        return this.parallelism;
    }

    public boolean isPrimaryRange() {
        return this.primaryRange;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isTraced() {
        return this.trace;
    }

    public int getJobThreads() {
        return this.jobThreads;
    }

    public Collection<String> getColumnFamilies() {
        return this.columnFamilies;
    }

    public Collection<Range<Token>> getRanges() {
        return this.ranges;
    }

    public Collection<String> getDataCenters() {
        return this.dataCenters;
    }

    public Collection<String> getHosts() {
        return this.hosts;
    }

    public String toString() {
        return "repair options (parallelism: " + (Object)((Object)this.parallelism) + ", primary range: " + this.primaryRange + ", incremental: " + this.incremental + ", job threads: " + this.jobThreads + ", ColumnFamilies: " + this.columnFamilies + ", dataCenters: " + this.dataCenters + ", hosts: " + this.hosts + ", # of ranges: " + this.ranges.size() + ')';
    }
}

