/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.utils.Pair;

public class IncludingExcludingBounds<T extends RingPosition<T>>
extends AbstractBounds<T> {
    public IncludingExcludingBounds(T left, T right) {
        super(left, right);
        assert (left.compareTo(right) < 0 || right.isMinimum()) : "[" + left + "," + right + ")";
    }

    @Override
    public boolean contains(T position) {
        return (Range.contains(this.left, this.right, position) || this.left.equals(position)) && !this.right.equals(position);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position));
        Bounds<RingPosition> lb = new Bounds<RingPosition>(this.left, (RingPosition)position);
        ExcludingBounds<RingPosition> rb = new ExcludingBounds<RingPosition>((RingPosition)position, this.right);
        return Pair.create(lb, rb);
    }

    @Override
    public boolean inclusiveLeft() {
        return true;
    }

    @Override
    public boolean inclusiveRight() {
        return false;
    }

    @Override
    public List<? extends AbstractBounds<T>> unwrap() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IncludingExcludingBounds)) {
            return false;
        }
        IncludingExcludingBounds rhs = (IncludingExcludingBounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + ")";
    }

    @Override
    protected String getOpeningString() {
        return "[";
    }

    @Override
    protected String getClosingString() {
        return ")";
    }

    @Override
    public AbstractBounds<T> withNewRight(T newRight) {
        return new IncludingExcludingBounds<RingPosition>(this.left, (RingPosition)newRight);
    }
}

