/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictionSet;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.ReversedPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class StatementRestrictions {
    public final CFMetaData cfm;
    private PrimaryKeyRestrictions partitionKeyRestrictions;
    private PrimaryKeyRestrictions clusteringColumnsRestrictions;
    private RestrictionSet nonPrimaryKeyRestrictions;
    private final List<Restrictions> indexRestrictions = new ArrayList<Restrictions>();
    private boolean usesSecondaryIndexing;
    private boolean isKeyRange;

    public static StatementRestrictions empty(CFMetaData cfm) {
        return new StatementRestrictions(cfm);
    }

    private StatementRestrictions(CFMetaData cfm) {
        this.cfm = cfm;
        this.partitionKeyRestrictions = new PrimaryKeyRestrictionSet(cfm.getKeyValidatorAsCType());
        this.clusteringColumnsRestrictions = new PrimaryKeyRestrictionSet(cfm.comparator);
        this.nonPrimaryKeyRestrictions = new RestrictionSet();
    }

    public StatementRestrictions(CFMetaData cfm, List<Relation> whereClause, VariableSpecifications boundNames, boolean selectsOnlyStaticColumns, boolean selectACollection) throws InvalidRequestException {
        this.cfm = cfm;
        this.partitionKeyRestrictions = new PrimaryKeyRestrictionSet(cfm.getKeyValidatorAsCType());
        this.clusteringColumnsRestrictions = new PrimaryKeyRestrictionSet(cfm.comparator);
        this.nonPrimaryKeyRestrictions = new RestrictionSet();
        for (Relation relation : whereClause) {
            this.addRestriction(relation.toRestriction(cfm, boundNames));
        }
        ColumnFamilyStore cfs = Keyspace.open(cfm.ksName).getColumnFamilyStore(cfm.cfName);
        SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
        boolean hasQueriableClusteringColumnIndex = this.clusteringColumnsRestrictions.hasSupportingIndex(secondaryIndexManager);
        boolean hasQueriableIndex = hasQueriableClusteringColumnIndex || this.partitionKeyRestrictions.hasSupportingIndex(secondaryIndexManager) || this.nonPrimaryKeyRestrictions.hasSupportingIndex(secondaryIndexManager);
        this.processPartitionKeyRestrictions(hasQueriableIndex);
        if (this.usesSecondaryIndexing) {
            this.indexRestrictions.add(this.partitionKeyRestrictions);
        }
        RequestValidations.checkFalse(selectsOnlyStaticColumns && this.hasClusteringColumnsRestriction(), "Cannot restrict clustering columns when selecting only static columns");
        this.processClusteringColumnsRestrictions(hasQueriableIndex, selectACollection);
        if (this.isKeyRange && hasQueriableClusteringColumnIndex) {
            this.usesSecondaryIndexing = true;
        }
        boolean bl = this.usesSecondaryIndexing = this.usesSecondaryIndexing || this.clusteringColumnsRestrictions.isContains();
        if (this.usesSecondaryIndexing) {
            this.indexRestrictions.add(this.clusteringColumnsRestrictions);
        }
        if (!this.nonPrimaryKeyRestrictions.isEmpty()) {
            this.usesSecondaryIndexing = true;
            this.indexRestrictions.add(this.nonPrimaryKeyRestrictions);
        }
        if (this.usesSecondaryIndexing) {
            this.validateSecondaryIndexSelections(selectsOnlyStaticColumns);
        }
    }

    private void addRestriction(Restriction restriction) throws InvalidRequestException {
        if (restriction.isMultiColumn()) {
            this.clusteringColumnsRestrictions = this.clusteringColumnsRestrictions.mergeWith(restriction);
        } else if (restriction.isOnToken()) {
            this.partitionKeyRestrictions = this.partitionKeyRestrictions.mergeWith(restriction);
        } else {
            this.addSingleColumnRestriction((SingleColumnRestriction)restriction);
        }
    }

    public Iterable<Function> getFunctions() {
        return Iterables.concat(this.partitionKeyRestrictions.getFunctions(), this.clusteringColumnsRestrictions.getFunctions(), this.nonPrimaryKeyRestrictions.getFunctions());
    }

    private void addSingleColumnRestriction(SingleColumnRestriction restriction) throws InvalidRequestException {
        ColumnDefinition def = restriction.columnDef;
        if (def.isPartitionKey()) {
            this.partitionKeyRestrictions = this.partitionKeyRestrictions.mergeWith(restriction);
        } else if (def.isClusteringColumn()) {
            this.clusteringColumnsRestrictions = this.clusteringColumnsRestrictions.mergeWith(restriction);
        } else {
            this.nonPrimaryKeyRestrictions = this.nonPrimaryKeyRestrictions.addRestriction(restriction);
        }
    }

    public boolean keyIsInRelation() {
        return this.partitionKeyRestrictions.isIN();
    }

    public boolean isKeyRange() {
        return this.isKeyRange;
    }

    public boolean usesSecondaryIndexing() {
        return this.usesSecondaryIndexing;
    }

    private void processPartitionKeyRestrictions(boolean hasQueriableIndex) throws InvalidRequestException {
        if (this.partitionKeyRestrictions.isOnToken()) {
            this.isKeyRange = true;
        }
        if (this.hasPartitionKeyUnrestrictedComponents()) {
            if (!this.partitionKeyRestrictions.isEmpty() && !hasQueriableIndex) {
                throw RequestValidations.invalidRequest("Partition key parts: %s must be restricted as other parts are", Joiner.on((String)", ").join(this.getPartitionKeyUnrestrictedComponents()));
            }
            this.isKeyRange = true;
            this.usesSecondaryIndexing = hasQueriableIndex;
        }
    }

    private boolean hasPartitionKeyUnrestrictedComponents() {
        return this.partitionKeyRestrictions.size() < this.cfm.partitionKeyColumns().size();
    }

    private List<ColumnIdentifier> getPartitionKeyUnrestrictedComponents() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>(this.cfm.partitionKeyColumns());
        list.removeAll(this.partitionKeyRestrictions.getColumnDefs());
        return ColumnDefinition.toIdentifiers(list);
    }

    private void processClusteringColumnsRestrictions(boolean hasQueriableIndex, boolean selectACollection) throws InvalidRequestException {
        RequestValidations.checkFalse(this.clusteringColumnsRestrictions.isIN() && selectACollection, "Cannot restrict clustering columns by IN relations when a collection is selected by the query");
        RequestValidations.checkFalse(this.clusteringColumnsRestrictions.isContains() && !hasQueriableIndex, "Cannot restrict clustering columns by a CONTAINS relation without a secondary index");
        if (this.hasClusteringColumnsRestriction()) {
            List<ColumnDefinition> clusteringColumns = this.cfm.clusteringColumns();
            LinkedList<ColumnDefinition> restrictedColumns = new LinkedList<ColumnDefinition>(this.clusteringColumnsRestrictions.getColumnDefs());
            int m = restrictedColumns.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition restrictedColumn;
                ColumnDefinition clusteringColumn = clusteringColumns.get(i);
                if (clusteringColumn.equals(restrictedColumn = (ColumnDefinition)restrictedColumns.get(i))) continue;
                RequestValidations.checkTrue(hasQueriableIndex, "PRIMARY KEY column \"%s\" cannot be restricted as preceding column \"%s\" is not restricted", restrictedColumn.name, clusteringColumn.name);
                this.usesSecondaryIndexing = true;
                break;
            }
        }
        if (this.clusteringColumnsRestrictions.isContains()) {
            this.usesSecondaryIndexing = true;
        }
    }

    public List<IndexExpression> getIndexExpressions(SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.indexRestrictions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (Restrictions restrictions : this.indexRestrictions) {
            restrictions.addIndexExpressionTo(expressions, indexManager, options);
        }
        return expressions;
    }

    public Collection<ByteBuffer> getPartitionKeys(QueryOptions options) throws InvalidRequestException {
        return this.partitionKeyRestrictions.values(options);
    }

    private ByteBuffer getPartitionKeyBound(Bound b, QueryOptions options) throws InvalidRequestException {
        if (this.hasPartitionKeyUnrestrictedComponents()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return this.partitionKeyRestrictions.bounds(b, options).get(0);
    }

    public AbstractBounds<RowPosition> getPartitionKeyBounds(QueryOptions options) throws InvalidRequestException {
        IPartitioner p = StorageService.getPartitioner();
        if (this.partitionKeyRestrictions.isOnToken()) {
            return this.getPartitionKeyBoundsForTokenRestrictions(p, options);
        }
        return this.getPartitionKeyBounds(p, options);
    }

    private AbstractBounds<RowPosition> getPartitionKeyBounds(IPartitioner p, QueryOptions options) throws InvalidRequestException {
        RowPosition finishKey;
        ByteBuffer startKeyBytes = this.getPartitionKeyBound(Bound.START, options);
        ByteBuffer finishKeyBytes = this.getPartitionKeyBound(Bound.END, options);
        RowPosition startKey = RowPosition.ForKey.get(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.ForKey.get(finishKeyBytes, p)) > 0 && !finishKey.isMinimum()) {
            return null;
        }
        if (this.partitionKeyRestrictions.isInclusive(Bound.START)) {
            return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private AbstractBounds<RowPosition> getPartitionKeyBoundsForTokenRestrictions(IPartitioner p, QueryOptions options) throws InvalidRequestException {
        Token startToken = this.getTokenBound(Bound.START, options, p);
        Token endToken = this.getTokenBound(Bound.END, options, p);
        boolean includeStart = this.partitionKeyRestrictions.isInclusive(Bound.START);
        boolean includeEnd = this.partitionKeyRestrictions.isInclusive(Bound.END);
        int cmp = startToken.compareTo(endToken);
        if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
            return null;
        }
        Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
        Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
        return new Range<RowPosition>(start, end);
    }

    private Token getTokenBound(Bound b, QueryOptions options, IPartitioner p) throws InvalidRequestException {
        if (!this.partitionKeyRestrictions.hasBound(b)) {
            return p.getMinimumToken();
        }
        ByteBuffer value = this.partitionKeyRestrictions.bounds(b, options).get(0);
        RequestValidations.checkNotNull(value, "Invalid null token value", new Object[0]);
        return p.getTokenFactory().fromByteArray(value);
    }

    public boolean hasNoClusteringColumnsRestriction() {
        return this.clusteringColumnsRestrictions.isEmpty();
    }

    public boolean hasClusteringColumnsRestriction() {
        return !this.clusteringColumnsRestrictions.isEmpty();
    }

    public boolean isNonCompositeSliceWithExclusiveBounds() {
        return !this.cfm.comparator.isCompound() && this.clusteringColumnsRestrictions.isSlice() && (!this.clusteringColumnsRestrictions.isInclusive(Bound.START) || !this.clusteringColumnsRestrictions.isInclusive(Bound.END));
    }

    public List<Composite> getClusteringColumnsAsComposites(QueryOptions options) throws InvalidRequestException {
        return this.clusteringColumnsRestrictions.valuesAsComposites(options);
    }

    public List<Composite> getClusteringColumnsBoundsAsComposites(Bound b, QueryOptions options) throws InvalidRequestException {
        return this.clusteringColumnsRestrictions.boundsAsComposites(b, options);
    }

    public List<ByteBuffer> getClusteringColumnsBounds(Bound b, QueryOptions options) throws InvalidRequestException {
        return this.clusteringColumnsRestrictions.bounds(b, options);
    }

    public boolean areRequestedBoundsInclusive(Bound bound) {
        return this.clusteringColumnsRestrictions.isInclusive(bound);
    }

    public boolean isColumnRange() {
        if (!this.cfm.comparator.isDense()) {
            return this.cfm.comparator.isCompound();
        }
        return this.clusteringColumnsRestrictions.size() < this.cfm.clusteringColumns().size() || this.clusteringColumnsRestrictions.isSlice();
    }

    public boolean needFiltering() {
        int numberOfRestrictedColumns = 0;
        for (Restrictions restrictions : this.indexRestrictions) {
            numberOfRestrictedColumns += restrictions.size();
        }
        return numberOfRestrictedColumns > 1 || numberOfRestrictedColumns == 0 && !this.clusteringColumnsRestrictions.isEmpty() || numberOfRestrictedColumns != 0 && this.nonPrimaryKeyRestrictions.hasMultipleContains();
    }

    private void validateSecondaryIndexSelections(boolean selectsOnlyStaticColumns) throws InvalidRequestException {
        RequestValidations.checkFalse(this.keyIsInRelation(), "Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
        RequestValidations.checkFalse(selectsOnlyStaticColumns, "Queries using 2ndary indexes don't support selecting only static columns");
    }

    public void reverse() {
        this.clusteringColumnsRestrictions = new ReversedPrimaryKeyRestrictions(this.clusteringColumnsRestrictions);
    }
}

