/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ReadyMessage;

public class CredentialsMessage
extends Message.Request {
    public static final Message.Codec<CredentialsMessage> codec = new Message.Codec<CredentialsMessage>(){

        @Override
        public CredentialsMessage decode(ByteBuf body, int version) {
            if (version > 1) {
                throw new ProtocolException("Legacy credentials authentication is not supported in protocol versions > 1. Please use SASL authentication via a SaslResponse message");
            }
            Map<String, String> credentials = CBUtil.readStringMap(body);
            return new CredentialsMessage(credentials);
        }

        @Override
        public void encode(CredentialsMessage msg, ByteBuf dest, int version) {
            CBUtil.writeStringMap(msg.credentials, dest);
        }

        @Override
        public int encodedSize(CredentialsMessage msg, int version) {
            return CBUtil.sizeOfStringMap(msg.credentials);
        }
    };
    public final Map<String, String> credentials;

    public CredentialsMessage() {
        this(new HashMap<String, String>());
    }

    private CredentialsMessage(Map<String, String> credentials) {
        super(Message.Type.CREDENTIALS);
        this.credentials = credentials;
    }

    @Override
    public Message.Response execute(QueryState state) {
        try {
            AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().legacyAuthenticate(this.credentials);
            state.getClientState().login(user);
        }
        catch (AuthenticationException e) {
            return ErrorMessage.fromException(e);
        }
        return new ReadyMessage();
    }

    public String toString() {
        return "CREDENTIALS " + this.credentials;
    }
}

