/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import java.net.InetAddress;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.OutboundTcpConnectionPool;

public class ConnectionMetrics {
    public static final String TYPE_NAME = "Connection";
    public static final Meter totalTimeouts = CassandraMetricsRegistry.Metrics.meter(DefaultNameFactory.createMetricName("Connection", "TotalTimeouts", null));
    public final String address;
    public final Gauge<Integer> largeMessagePendingTasks;
    public final Gauge<Long> largeMessageCompletedTasks;
    public final Gauge<Long> largeMessageDroppedTasks;
    public final Gauge<Integer> smallMessagePendingTasks;
    public final Gauge<Long> smallMessageCompletedTasks;
    public final Gauge<Long> smallMessageDroppedTasks;
    public final Meter timeouts;
    private final MetricNameFactory factory;

    public ConnectionMetrics(InetAddress ip, final OutboundTcpConnectionPool connectionPool) {
        this.address = ip.getHostAddress().replace(':', '.');
        this.factory = new DefaultNameFactory(TYPE_NAME, this.address);
        this.largeMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessagePendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return connectionPool.largeMessages.getPendingMessages();
            }
        });
        this.largeMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageCompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return connectionPool.largeMessages.getCompletedMesssages();
            }
        });
        this.largeMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return connectionPool.largeMessages.getDroppedMessages();
            }
        });
        this.smallMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessagePendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return connectionPool.smallMessages.getPendingMessages();
            }
        });
        this.smallMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageCompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return connectionPool.smallMessages.getCompletedMesssages();
            }
        });
        this.smallMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return connectionPool.smallMessages.getDroppedMessages();
            }
        });
        this.timeouts = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Timeouts"));
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Timeouts"));
    }
}

