/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TokenRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnFamilyInputFormat<K, Y>
extends InputFormat<K, Y>
implements org.apache.hadoop.mapred.InputFormat<K, Y> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractColumnFamilyInputFormat.class);
    public static final String MAPRED_TASK_ID = "mapred.task.id";
    public static final String CASSANDRA_HADOOP_MAX_KEY_SIZE = "cassandra.hadoop.max_key_size";
    public static final int CASSANDRA_HADOOP_MAX_KEY_SIZE_DEFAULT = 8192;
    private String keyspace;
    private String cfName;
    private IPartitioner partitioner;
    private Session session;

    protected void validateConfiguration(Configuration conf) {
        if (ConfigHelper.getInputKeyspace(conf) == null || ConfigHelper.getInputColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and table with setInputColumnFamily()");
        }
        if (ConfigHelper.getInputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node with setInputInitialAddress");
        }
        if (ConfigHelper.getInputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the Cassandra partitioner class with setInputPartitioner");
        }
    }

    /*
     * Exception decompiling
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TokenRange rangeToTokenRange(Metadata metadata, Range<Token> range) {
        return metadata.newTokenRange(metadata.newToken(this.partitioner.getTokenFactory().toString((Token)range.left)), metadata.newToken(this.partitioner.getTokenFactory().toString((Token)range.right)));
    }

    private Map<TokenRange, Long> getSubSplits(String keyspace, String cfName, TokenRange range, Configuration conf) throws IOException {
        int splitSize = ConfigHelper.getInputSplitSize(conf);
        try {
            return this.describeSplits(keyspace, cfName, range, splitSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<TokenRange, Set<Host>> getRangeMap(Configuration conf, String keyspace) {
        try (Session session = CqlConfigHelper.getInputCluster(ConfigHelper.getInputInitialAddress(conf).split(","), conf).connect();){
            HashMap<TokenRange, Set> map = new HashMap<TokenRange, Set>();
            Metadata metadata = session.getCluster().getMetadata();
            for (TokenRange tokenRange : metadata.getTokenRanges()) {
                map.put(tokenRange, metadata.getReplicas('\"' + keyspace + '\"', tokenRange));
            }
            HashMap<TokenRange, Set> hashMap = map;
            return hashMap;
        }
    }

    private Map<TokenRange, Long> describeSplits(String keyspace, String table, TokenRange tokenRange, int splitSize) {
        String query = String.format("SELECT mean_partition_size, partitions_count FROM %s.%s WHERE keyspace_name = ? AND table_name = ? AND range_start = ? AND range_end = ?", "system", "size_estimates");
        ResultSet resultSet = this.session.execute(query, new Object[]{keyspace, table, tokenRange.getStart().toString(), tokenRange.getEnd().toString()});
        Row row = resultSet.one();
        if (row == null) {
            HashMap<TokenRange, Long> wrappedTokenRange = new HashMap<TokenRange, Long>();
            wrappedTokenRange.put(tokenRange, 128L);
            return wrappedTokenRange;
        }
        long meanPartitionSize = row.getLong("mean_partition_size");
        long partitionCount = row.getLong("partitions_count");
        int splitCount = (int)(meanPartitionSize * partitionCount / (long)splitSize);
        List splitRanges = tokenRange.splitEvenly(splitCount);
        HashMap<TokenRange, Long> rangesWithLength = new HashMap<TokenRange, Long>();
        for (TokenRange range : splitRanges) {
            rangesWithLength.put(range, partitionCount / (long)splitCount);
        }
        return rangesWithLength;
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        TaskAttemptContext tac = HadoopCompat.newTaskAttemptContext((Configuration)jobConf, new TaskAttemptID());
        List<InputSplit> newInputSplits = this.getSplits((JobContext)tac);
        org.apache.hadoop.mapred.InputSplit[] oldInputSplits = new org.apache.hadoop.mapred.InputSplit[newInputSplits.size()];
        for (int i = 0; i < newInputSplits.size(); ++i) {
            oldInputSplits[i] = (ColumnFamilySplit)newInputSplits.get(i);
        }
        return oldInputSplits;
    }

    class SplitCallable
    implements Callable<List<InputSplit>> {
        private final TokenRange tokenRange;
        private final Set<Host> hosts;
        private final Configuration conf;

        public SplitCallable(TokenRange tr, Set<Host> hosts, Configuration conf) {
            this.tokenRange = tr;
            this.hosts = hosts;
            this.conf = conf;
        }

        @Override
        public List<InputSplit> call() throws Exception {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            Map subSplits = AbstractColumnFamilyInputFormat.this.getSubSplits(AbstractColumnFamilyInputFormat.this.keyspace, AbstractColumnFamilyInputFormat.this.cfName, this.tokenRange, this.conf);
            String[] endpoints = new String[this.hosts.size()];
            int endpointIndex = 0;
            for (Host endpoint : this.hosts) {
                endpoints[endpointIndex++] = endpoint.getAddress().getHostName();
            }
            boolean partitionerIsOpp = AbstractColumnFamilyInputFormat.this.partitioner instanceof OrderPreservingPartitioner || AbstractColumnFamilyInputFormat.this.partitioner instanceof ByteOrderedPartitioner;
            for (TokenRange subSplit : subSplits.keySet()) {
                List ranges = subSplit.unwrap();
                for (TokenRange subrange : ranges) {
                    ColumnFamilySplit split = new ColumnFamilySplit(partitionerIsOpp ? subrange.getStart().toString().substring(2) : subrange.getStart().toString(), partitionerIsOpp ? subrange.getEnd().toString().substring(2) : subrange.getStart().toString(), (Long)subSplits.get(subSplit), endpoints);
                    logger.debug("adding {}", (Object)split);
                    splits.add(split);
                }
            }
            return splits;
        }
    }
}

