/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.AlwaysPresentFilter;
import org.apache.cassandra.utils.OverlapIterator;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionController
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CompactionController.class);
    public final ColumnFamilyStore cfs;
    private Refs<SSTableReader> overlappingSSTables;
    private OverlapIterator<RowPosition, SSTableReader> overlapIterator;
    private final Iterable<SSTableReader> compacting;
    public final int gcBefore;

    protected CompactionController(ColumnFamilyStore cfs, int maxValue) {
        this(cfs, null, maxValue);
    }

    public CompactionController(ColumnFamilyStore cfs, Set<SSTableReader> compacting, int gcBefore) {
        assert (cfs != null);
        this.cfs = cfs;
        this.gcBefore = gcBefore;
        this.compacting = compacting;
        this.refreshOverlaps();
    }

    void maybeRefreshOverlaps() {
        for (SSTableReader reader : this.overlappingSSTables) {
            if (!reader.isMarkedCompacted()) continue;
            this.refreshOverlaps();
            return;
        }
    }

    private void refreshOverlaps() {
        if (this.overlappingSSTables != null) {
            this.overlappingSSTables.release();
        }
        this.overlappingSSTables = this.compacting == null ? Refs.tryRef(Collections.emptyList()) : this.cfs.getAndReferenceOverlappingSSTables(this.compacting);
        this.overlapIterator = new OverlapIterator(SSTableIntervalTree.buildIntervals(this.overlappingSSTables));
    }

    public Set<SSTableReader> getFullyExpiredSSTables() {
        return CompactionController.getFullyExpiredSSTables(this.cfs, this.compacting, this.overlappingSSTables, this.gcBefore);
    }

    public static Set<SSTableReader> getFullyExpiredSSTables(ColumnFamilyStore cfStore, Iterable<SSTableReader> compacting, Iterable<SSTableReader> overlapping, int gcBefore) {
        logger.debug("Checking droppable sstables in {}", (Object)cfStore);
        if (compacting == null) {
            return Collections.emptySet();
        }
        ArrayList<SSTableReader> candidates = new ArrayList<SSTableReader>();
        long minTimestamp = Long.MAX_VALUE;
        for (SSTableReader sstable : overlapping) {
            minTimestamp = Math.min(minTimestamp, sstable.getMinTimestamp());
        }
        for (SSTableReader candidate : compacting) {
            if (candidate.getSSTableMetadata().maxLocalDeletionTime < gcBefore) {
                candidates.add(candidate);
                continue;
            }
            minTimestamp = Math.min(minTimestamp, candidate.getMinTimestamp());
        }
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            SSTableReader candidate;
            candidate = (SSTableReader)iterator.next();
            if (candidate.getMaxTimestamp() >= minTimestamp) {
                iterator.remove();
                continue;
            }
            logger.debug("Dropping expired SSTable {} (maxLocalDeletionTime={}, gcBefore={})", new Object[]{candidate, candidate.getSSTableMetadata().maxLocalDeletionTime, gcBefore});
        }
        return new HashSet<SSTableReader>(candidates);
    }

    public String getKeyspace() {
        return this.cfs.keyspace.getName();
    }

    public String getColumnFamily() {
        return this.cfs.name;
    }

    public long maxPurgeableTimestamp(DecoratedKey key) {
        long min = Long.MAX_VALUE;
        this.overlapIterator.update(key);
        for (SSTableReader sstable : this.overlapIterator.overlaps()) {
            if (sstable.getBloomFilter() instanceof AlwaysPresentFilter && sstable.getPosition(key, SSTableReader.Operator.EQ, false) != null) {
                min = Math.min(min, sstable.getMinTimestamp());
                continue;
            }
            if (!sstable.getBloomFilter().isPresent(key)) continue;
            min = Math.min(min, sstable.getMinTimestamp());
        }
        return min;
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.cfs.invalidateCachedRow(key);
    }

    @Override
    public void close() {
        this.overlappingSSTables.release();
    }
}

