/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public final class SimpleSelector
extends Selector {
    private final String columnName;
    private final int idx;
    private final AbstractType<?> type;
    private ByteBuffer current;

    public static Selector.Factory newFactory(final String columnName, final int idx, final AbstractType<?> type) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return columnName;
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            public Selector newInstance() {
                return new SimpleSelector(columnName, idx, type);
            }
        };
    }

    @Override
    public void addInput(int protocolVersion, Selection.ResultSetBuilder rs) throws InvalidRequestException {
        this.current = rs.current.get(this.idx);
    }

    @Override
    public ByteBuffer getOutput(int protocolVersion) throws InvalidRequestException {
        return this.current;
    }

    @Override
    public void reset() {
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return this.columnName;
    }

    private SimpleSelector(String columnName, int idx, AbstractType<?> type) {
        this.columnName = columnName;
        this.idx = idx;
        this.type = type;
    }
}

