/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.JavaSourceUDFFactory;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.ScriptBasedUDF;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UDFunction
extends AbstractFunction
implements ScalarFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDFunction.class);
    protected final List<ColumnIdentifier> argNames;
    protected final String language;
    protected final String body;
    protected final DataType[] argDataTypes;
    protected final DataType returnDataType;
    protected final boolean calledOnNullInput;

    protected UDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) {
        this(name, argNames, argTypes, UDHelper.driverTypes(argTypes), returnType, UDHelper.driverType(returnType), calledOnNullInput, language, body);
    }

    protected UDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, DataType[] argDataTypes, AbstractType<?> returnType, DataType returnDataType, boolean calledOnNullInput, String language, String body) {
        super(name, argTypes, returnType);
        assert (new HashSet<ColumnIdentifier>(argNames).size() == argNames.size()) : "duplicate argument names";
        this.argNames = argNames;
        this.language = language;
        this.body = body;
        this.argDataTypes = argDataTypes;
        this.returnDataType = returnDataType;
        this.calledOnNullInput = calledOnNullInput;
    }

    public static UDFunction create(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body) throws InvalidRequestException {
        if (!DatabaseDescriptor.enableUserDefinedFunctions()) {
            throw new InvalidRequestException("User-defined-functions are disabled in cassandra.yaml - set enable_user_defined_functions=true to enable if you are aware of the security risks");
        }
        switch (language) {
            case "java": {
                return JavaSourceUDFFactory.buildUDF(name, argNames, argTypes, returnType, calledOnNullInput, body);
            }
        }
        return new ScriptBasedUDF(name, argNames, argTypes, returnType, calledOnNullInput, language, body);
    }

    public static UDFunction createBrokenFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String language, String body, final InvalidRequestException reason) {
        return new UDFunction(name, argNames, argTypes, returnType, calledOnNullInput, language, body){

            @Override
            public ByteBuffer executeUserDefined(int protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
                throw new InvalidRequestException(String.format("Function '%s' exists but hasn't been loaded successfully for the following reason: %s. Please see the server log for details", this, reason.getMessage()));
            }
        };
    }

    @Override
    public final ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        if (!DatabaseDescriptor.enableUserDefinedFunctions()) {
            throw new InvalidRequestException("User-defined-functions are disabled in cassandra.yaml - set enable_user_defined_functions=true to enable if you are aware of the security risks");
        }
        if (!this.isCallableWrtNullable(parameters)) {
            return null;
        }
        return this.executeUserDefined(protocolVersion, parameters);
    }

    public boolean isCallableWrtNullable(List<ByteBuffer> parameters) {
        if (!this.calledOnNullInput) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (!UDHelper.isNullOrEmpty((AbstractType)this.argTypes.get(i), parameters.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract ByteBuffer executeUserDefined(int var1, List<ByteBuffer> var2) throws InvalidRequestException;

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public List<ColumnIdentifier> argNames() {
        return this.argNames;
    }

    public String body() {
        return this.body;
    }

    public String language() {
        return this.language;
    }

    protected Object compose(int protocolVersion, int argIndex, ByteBuffer value) {
        return UDHelper.isNullOrEmpty((AbstractType)this.argTypes.get(argIndex), value) ? null : this.argDataTypes[argIndex].deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected float compose_float(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return ((Float)DataType.cfloat().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion))).floatValue();
    }

    protected double compose_double(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Double)DataType.cdouble().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected byte compose_byte(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Byte)DataType.tinyint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected short compose_short(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Short)DataType.smallint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected int compose_int(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Integer)DataType.cint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected long compose_long(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Long)DataType.bigint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected boolean compose_boolean(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Boolean)DataType.cboolean().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected ByteBuffer decompose(int protocolVersion, Object value) {
        return value == null ? null : this.returnDataType.serialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDFunction)) {
            return false;
        }
        UDFunction that = (UDFunction)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.argNames, that.argNames) && Functions.typeEquals(this.argTypes, that.argTypes) && Functions.typeEquals(this.returnType, that.returnType) && Objects.equal((Object)this.language, (Object)that.language) && Objects.equal((Object)this.body, (Object)that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.argNames, this.argTypes, this.returnType, this.language, this.body});
    }

    public void userTypeUpdated(String ksName, String typeName) {
        boolean updated = false;
        for (int i = 0; i < this.argDataTypes.length; ++i) {
            DataType newUserType;
            com.datastax.driver.core.UserType userType;
            DataType dataType = this.argDataTypes[i];
            if (!(dataType instanceof com.datastax.driver.core.UserType) || !(userType = (com.datastax.driver.core.UserType)dataType).getKeyspace().equals(ksName) || !userType.getTypeName().equals(typeName)) continue;
            KSMetaData ksm = Schema.instance.getKSMetaData(ksName);
            assert (ksm != null);
            UserType ut = ksm.userTypes.getType(ByteBufferUtil.bytes(typeName));
            this.argDataTypes[i] = newUserType = UDHelper.driverType(ut);
            this.argTypes.set(i, ut);
            updated = true;
        }
        if (updated) {
            MigrationManager.announceNewFunction(this, true);
        }
    }
}

