/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public abstract class TimeuuidFcts {
    public static final Function nowFct = new NativeScalarFunction("now", (AbstractType)TimeUUIDType.instance, new AbstractType[0]){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            return ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
        }
    };
    public static final Function minTimeuuidFct = new NativeScalarFunction("mintimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.minTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function maxTimeuuidFct = new NativeScalarFunction("maxtimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.maxTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function dateOfFct = new NativeScalarFunction("dateof", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return TimestampType.instance.decompose(new Date(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb))));
        }
    };
    public static final Function unixTimestampOfFct = new NativeScalarFunction("unixtimestampof", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBufferUtil.bytes(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb)));
        }
    };
}

