/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManager;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CommitLogMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("CommitLog");
    public Gauge<Long> completedTasks;
    public Gauge<Long> pendingTasks;
    public Gauge<Long> totalCommitLogSize;
    public final Timer waitingOnSegmentAllocation = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("WaitingOnSegmentAllocation"));
    public final Timer waitingOnCommit = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("WaitingOnCommit"));

    public void attach(final AbstractCommitLogService service, final CommitLogSegmentManager allocator) {
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return service.getCompletedTasks();
            }
        });
        this.pendingTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            public Long getValue() {
                return service.getPendingTasks();
            }
        });
        this.totalCommitLogSize = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("TotalCommitLogSize"), new Gauge<Long>(){

            public Long getValue() {
                return allocator.bytesUsed();
            }
        });
    }
}

