/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.io.FileNotFoundException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.RandomAccessReader;

public class ThrottledReader
extends RandomAccessReader {
    private final RateLimiter limiter;

    protected ThrottledReader(ChannelProxy channel, long overrideLength, RateLimiter limiter) throws FileNotFoundException {
        super(channel, 65536, overrideLength, false, null);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.capacity());
        super.reBuffer();
    }

    public static ThrottledReader open(ChannelProxy channel, long overrideLength, RateLimiter limiter) {
        try {
            return new ThrottledReader(channel, overrideLength, limiter);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

