/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableDeletingTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableDeletingTask.class);
    private static final Set<SSTableDeletingTask> failedTasks = new CopyOnWriteArraySet<SSTableDeletingTask>();
    private final SSTableReader referent;
    private final Descriptor desc;
    private final Set<Component> components;
    private DataTracker tracker;

    public SSTableDeletingTask(Descriptor realDescriptor, SSTableReader referent) {
        this.referent = referent;
        this.desc = realDescriptor;
        switch (this.desc.type) {
            case FINAL: {
                this.components = referent.components;
                break;
            }
            case TEMPLINK: {
                this.components = Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.PRIMARY_INDEX});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void setTracker(DataTracker tracker) {
        if (this.desc.type == Descriptor.Type.FINAL) {
            this.tracker = tracker;
        }
    }

    public void schedule() {
        ScheduledExecutors.nonPeriodicTasks.submit(this);
    }

    @Override
    public void run() {
        File datafile;
        long size = this.referent.bytesOnDisk();
        if (this.tracker != null) {
            this.tracker.notifyDeleting(this.referent);
        }
        if (!(datafile = new File(this.desc.filenameFor(Component.DATA))).delete()) {
            logger.error("Unable to delete {} (it will be removed on server restart; we'll also retry after GC)", (Object)datafile);
            failedTasks.add(this);
            return;
        }
        SSTable.delete(this.desc, (Set<Component>)Sets.difference(this.components, Collections.singleton(Component.DATA)));
        if (this.tracker != null) {
            this.tracker.spaceReclaimed(size);
        }
    }

    public static void rescheduleFailedTasks() {
        for (SSTableDeletingTask task : failedTasks) {
            failedTasks.remove(task);
            task.schedule();
        }
    }

    public static void waitForDeletions() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(runnable, 0L, TimeUnit.MILLISECONDS));
    }
}

