/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DeflateCompressor
implements ICompressor {
    public static final DeflateCompressor instance = new DeflateCompressor();
    private final ThreadLocal<Deflater> deflater = new ThreadLocal<Deflater>(){

        @Override
        protected Deflater initialValue() {
            return new Deflater();
        }
    };
    private final ThreadLocal<Inflater> inflater = new ThreadLocal<Inflater>(){

        @Override
        protected Inflater initialValue() {
            return new Inflater();
        }
    };

    public static DeflateCompressor create(Map<String, String> compressionOptions) {
        return instance;
    }

    private DeflateCompressor() {
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return chunkLength;
    }

    @Override
    public int compress(ByteBuffer src, ICompressor.WrappedByteBuffer dest) {
        assert (dest.buffer.hasArray());
        Deflater def = this.deflater.get();
        def.reset();
        def.setInput(src.array(), src.arrayOffset() + src.position(), src.remaining());
        def.finish();
        if (def.needsInput()) {
            return 0;
        }
        int startPos = dest.buffer.position();
        while (true) {
            int arrayOffset = dest.buffer.arrayOffset();
            int len = def.deflate(dest.buffer.array(), arrayOffset + dest.buffer.position(), dest.buffer.remaining());
            dest.buffer.position(dest.buffer.position() + len);
            if (def.finished()) {
                return dest.buffer.position() - startPos;
            }
            ByteBuffer newDest = ByteBuffer.allocate(dest.buffer.capacity() * 4 / 3 + 1);
            dest.buffer.rewind();
            newDest.put(dest.buffer);
            dest.buffer = newDest;
        }
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        Inflater inf = this.inflater.get();
        inf.reset();
        inf.setInput(input, inputOffset, inputLength);
        if (inf.needsInput()) {
            return 0;
        }
        try {
            return inf.inflate(output, outputOffset, output.length - outputOffset);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int uncompress(ByteBuffer input, ByteBuffer output) throws IOException {
        if (!output.hasArray()) {
            throw new IllegalArgumentException("DeflateCompressor doesn't work with direct byte buffers");
        }
        if (input.hasArray()) {
            return this.uncompress(input.array(), input.arrayOffset() + input.position(), input.remaining(), output.array(), output.arrayOffset() + output.position());
        }
        return this.uncompress(ByteBufferUtil.getArray(input), 0, input.remaining(), output.array(), output.arrayOffset() + output.position());
    }

    @Override
    public boolean useDirectOutputByteBuffers() {
        return false;
    }
}

