/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class CompositesBuilder {
    private final CType ctype;
    private final List<List<ByteBuffer>> elementsList = new ArrayList<List<ByteBuffer>>();
    private int size;
    private boolean built;
    private boolean containsNull;
    private boolean hasMissingElements;
    private boolean containsUnset;

    public CompositesBuilder(CType ctype) {
        this.ctype = ctype;
    }

    public CompositesBuilder addElementToAll(ByteBuffer value) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            if (value == null) {
                this.containsNull = true;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                this.containsUnset = true;
            }
            this.elementsList.get(i).add(value);
        }
        ++this.size;
        return this;
    }

    public CompositesBuilder addEachElementToAll(List<ByteBuffer> values) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        if (values.isEmpty()) {
            this.hasMissingElements = true;
        } else {
            int m = this.elementsList.size();
            for (int i = 0; i < m; ++i) {
                List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                int n = values.size();
                for (int j = 0; j < n; ++j) {
                    ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                    this.elementsList.add(newComposite);
                    ByteBuffer value = values.get(j);
                    if (value == null) {
                        this.containsNull = true;
                    }
                    if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                        this.containsUnset = true;
                    }
                    newComposite.add(values.get(j));
                }
            }
        }
        ++this.size;
        return this;
    }

    public CompositesBuilder addAllElementsToAll(List<List<ByteBuffer>> values) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        if (values.isEmpty()) {
            this.hasMissingElements = true;
        } else {
            int m = this.elementsList.size();
            for (int i = 0; i < m; ++i) {
                List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                int n = values.size();
                for (int j = 0; j < n; ++j) {
                    ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                    this.elementsList.add(newComposite);
                    List<ByteBuffer> value = values.get(j);
                    if (value.isEmpty()) {
                        this.hasMissingElements = true;
                    }
                    if (value.contains(null)) {
                        this.containsNull = true;
                    }
                    if (value.contains(ByteBufferUtil.UNSET_BYTE_BUFFER)) {
                        this.containsUnset = true;
                    }
                    newComposite.addAll(value);
                }
            }
            this.size += values.get(0).size();
        }
        return this;
    }

    public int remainingCount() {
        return this.ctype.size() - this.size;
    }

    public boolean hasRemaining() {
        return this.remainingCount() > 0;
    }

    public boolean isEmpty() {
        return this.elementsList.isEmpty();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean hasMissingElements() {
        return this.hasMissingElements;
    }

    public boolean containsUnset() {
        return this.containsUnset;
    }

    public List<Composite> build() {
        return this.buildWithEOC(Composite.EOC.NONE);
    }

    public List<Composite> buildWithEOC(Composite.EOC eoc) {
        this.built = true;
        if (this.hasMissingElements) {
            return Collections.emptyList();
        }
        CBuilder builder = this.ctype.builder();
        if (this.elementsList.isEmpty()) {
            return Collections.singletonList(builder.build().withEOC(eoc));
        }
        Set<Composite> set = this.newSet();
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            List<ByteBuffer> elements = this.elementsList.get(i);
            set.add(builder.buildWith(elements).withEOC(eoc));
        }
        return new ArrayList<Composite>(set);
    }

    private Set<Composite> newSet() {
        return new TreeSet<Composite>(this.ctype);
    }

    private void checkUpdateable() {
        if (!this.hasRemaining() || this.built) {
            throw new IllegalStateException("this CompositesBuilder cannot be updated anymore");
        }
    }
}

