/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MajorLeveledCompactionWriter
extends CompactionAwareWriter {
    private static final Logger logger = LoggerFactory.getLogger(MajorLeveledCompactionWriter.class);
    private final long maxSSTableSize;
    private final long expectedWriteSize;
    private final Set<SSTableReader> allSSTables;
    private int currentLevel = 1;
    private long averageEstimatedKeysPerSSTable;
    private long partitionsWritten = 0L;
    private long totalWrittenInLevel = 0L;
    private int sstablesWritten = 0;
    private final boolean skipAncestors;

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Set<SSTableReader> allSSTables, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, boolean offline, OperationType compactionType) {
        super(cfs, allSSTables, nonExpiredSSTables, offline);
        this.maxSSTableSize = maxSSTableSize;
        this.allSSTables = allSSTables;
        this.expectedWriteSize = Math.min(maxSSTableSize, cfs.getExpectedCompactedFileSize(nonExpiredSSTables, compactionType));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(nonExpiredSSTables) / maxSSTableSize);
        long keysPerSSTable = this.estimatedTotalKeys / estimatedSSTables;
        File sstableDirectory = cfs.directories.getLocationForDisk(this.getWriteDirectory(this.expectedWriteSize));
        boolean bl = this.skipAncestors = estimatedSSTables * (long)allSSTables.size() > 200000L;
        if (this.skipAncestors) {
            logger.warn("Many sstables involved in compaction, skipping storing ancestor information to avoid running out of memory");
        }
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(cfs.getTempSSTablePath(sstableDirectory)), keysPerSSTable, (Long)this.minRepairedAt, cfs.metadata, cfs.partitioner, new MetadataCollector(allSSTables, cfs.metadata.comparator, this.currentLevel, this.skipAncestors));
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    public boolean append(AbstractCompactedRow row) {
        long posBefore = this.sstableWriter.currentWriter().getOnDiskFilePointer();
        RowIndexEntry rie = this.sstableWriter.append(row);
        this.totalWrittenInLevel += this.sstableWriter.currentWriter().getOnDiskFilePointer() - posBefore;
        ++this.partitionsWritten;
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.maxSSTableSize) {
            if (this.totalWrittenInLevel > LeveledManifest.maxBytesForLevel(this.currentLevel, this.maxSSTableSize)) {
                this.totalWrittenInLevel = 0L;
                ++this.currentLevel;
            }
            this.averageEstimatedKeysPerSSTable = Math.round(((double)this.averageEstimatedKeysPerSSTable * (double)this.sstablesWritten + (double)this.partitionsWritten) / (double)(this.sstablesWritten + 1));
            File sstableDirectory = this.cfs.directories.getLocationForDisk(this.getWriteDirectory(this.expectedWriteSize));
            SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getTempSSTablePath(sstableDirectory)), this.averageEstimatedKeysPerSSTable, (Long)this.minRepairedAt, this.cfs.metadata, this.cfs.partitioner, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, this.currentLevel, this.skipAncestors));
            this.sstableWriter.switchWriter(writer);
            this.partitionsWritten = 0L;
            ++this.sstablesWritten;
        }
        return rie != null;
    }
}

