/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogArchiver {
    private static final Logger logger = LoggerFactory.getLogger(CommitLogArchiver.class);
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static final String DELIMITER = ",";
    public final Map<String, Future<?>> archivePending;
    private final ExecutorService executor;
    final String archiveCommand;
    final String restoreCommand;
    final String restoreDirectories;
    public long restorePointInTime;
    public final TimeUnit precision;

    public CommitLogArchiver() {
        InputStream stream;
        block9: {
            this.archivePending = new ConcurrentHashMap();
            this.executor = new JMXEnabledThreadPoolExecutor("CommitLogArchiver");
            Properties commitlog_commands = new Properties();
            stream = null;
            try {
                stream = this.getClass().getClassLoader().getResourceAsStream("commitlog_archiving.properties");
                if (stream == null) {
                    logger.debug("No commitlog_archiving properties found; archive + pitr will be disabled");
                    this.archiveCommand = null;
                    this.restoreCommand = null;
                    this.restoreDirectories = null;
                    this.restorePointInTime = Long.MAX_VALUE;
                    this.precision = TimeUnit.MICROSECONDS;
                    break block9;
                }
                commitlog_commands.load(stream);
                this.archiveCommand = commitlog_commands.getProperty("archive_command");
                this.restoreCommand = commitlog_commands.getProperty("restore_command");
                this.restoreDirectories = commitlog_commands.getProperty("restore_directories");
                if (this.restoreDirectories != null && !this.restoreDirectories.isEmpty()) {
                    for (String dir : this.restoreDirectories.split(DELIMITER)) {
                        File directory = new File(dir);
                        if (directory.exists() || directory.mkdir()) continue;
                        throw new RuntimeException("Unable to create directory: " + dir);
                    }
                }
                String targetTime = commitlog_commands.getProperty("restore_point_in_time");
                this.precision = TimeUnit.valueOf(commitlog_commands.getProperty("precision", "MICROSECONDS"));
                try {
                    this.restorePointInTime = Strings.isNullOrEmpty((String)targetTime) ? Long.MAX_VALUE : format.parse(targetTime).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to parse restore target time", e);
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Unable to load commitlog_archiving.properties", e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
        }
        FileUtils.closeQuietly(stream);
    }

    public void maybeArchive(final CommitLogSegment segment) {
        if (Strings.isNullOrEmpty((String)this.archiveCommand)) {
            return;
        }
        this.archivePending.put(segment.getName(), this.executor.submit(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                segment.waitForFinalSync();
                String command = CommitLogArchiver.this.archiveCommand.replace("%name", segment.getName());
                command = command.replace("%path", segment.getPath());
                CommitLogArchiver.this.exec(command);
            }
        }));
    }

    public void maybeArchive(final String path, final String name) {
        if (Strings.isNullOrEmpty((String)this.archiveCommand)) {
            return;
        }
        this.archivePending.put(name, this.executor.submit(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                String command = CommitLogArchiver.this.archiveCommand.replace("%name", name);
                command = command.replace("%path", path);
                CommitLogArchiver.this.exec(command);
            }
        }));
    }

    public boolean maybeWaitForArchiving(String name) {
        Future<?> f = this.archivePending.remove(name);
        if (f == null) {
            return true;
        }
        try {
            f.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                logger.error("Looks like the archiving of file {} failed earlier, cassandra is going to ignore this segment for now.", (Object)name);
                return false;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public void maybeRestoreArchive() {
        if (Strings.isNullOrEmpty((String)this.restoreDirectories)) {
            return;
        }
        for (String dir : this.restoreDirectories.split(DELIMITER)) {
            File[] files = new File(dir).listFiles();
            if (files == null) {
                throw new RuntimeException("Unable to list directory " + dir);
            }
            for (File fromFile : files) {
                File toFile;
                CommitLogDescriptor fromName;
                CommitLogDescriptor fromHeader = CommitLogDescriptor.fromHeader(fromFile);
                CommitLogDescriptor commitLogDescriptor = fromName = CommitLogDescriptor.isValid(fromFile.getName()) ? CommitLogDescriptor.fromFileName(fromFile.getName()) : null;
                if (fromHeader == null && fromName == null) {
                    throw new IllegalStateException("Cannot safely construct descriptor for segment, either from its name or its header: " + fromFile.getPath());
                }
                if (fromHeader != null && fromName != null && !fromHeader.equalsIgnoringCompression(fromName)) {
                    throw new IllegalStateException(String.format("Cannot safely construct descriptor for segment, as name and header descriptors do not match (%s vs %s): %s", fromHeader, fromName, fromFile.getPath()));
                }
                if (fromName != null && fromHeader == null && fromName.version >= 4) {
                    throw new IllegalStateException("Cannot safely construct descriptor for segment, as name descriptor implies a version that should contain a header descriptor, but that descriptor could not be read: " + fromFile.getPath());
                }
                CommitLogDescriptor descriptor = fromHeader != null ? fromHeader : fromName;
                if (descriptor.version > 5) {
                    throw new IllegalStateException("Unsupported commit log version: " + descriptor.version);
                }
                if (descriptor.compression != null) {
                    try {
                        CompressionParameters.createCompressor(descriptor.compression);
                    }
                    catch (ConfigurationException e) {
                        throw new IllegalStateException("Unknown compression", e);
                    }
                }
                if ((toFile = new File(DatabaseDescriptor.getCommitLogLocation(), descriptor.fileName())).exists()) {
                    logger.debug("Skipping restore of archive {} as the segment already exists in the restore location {}", (Object)fromFile.getPath(), (Object)toFile.getPath());
                    continue;
                }
                String command = this.restoreCommand.replace("%from", fromFile.getPath());
                command = command.replace("%to", toFile.getPath());
                try {
                    this.exec(command);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void exec(String command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command.split(" "));
        pb.redirectErrorStream(true);
        FBUtilities.exec(pb);
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

