/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public final class CreateFunctionStatement
extends SchemaAlteringStatement {
    private final boolean orReplace;
    private final boolean ifNotExists;
    private FunctionName functionName;
    private final String language;
    private final String body;
    private final List<ColumnIdentifier> argNames;
    private final List<CQL3Type.Raw> argRawTypes;
    private final CQL3Type.Raw rawReturnType;
    private final boolean calledOnNullInput;
    private List<AbstractType<?>> argTypes;
    private AbstractType<?> returnType;
    private UDFunction udFunction;
    private boolean replaced;

    public CreateFunctionStatement(FunctionName functionName, String language, String body, List<ColumnIdentifier> argNames, List<CQL3Type.Raw> argRawTypes, CQL3Type.Raw rawReturnType, boolean calledOnNullInput, boolean orReplace, boolean ifNotExists) {
        this.functionName = functionName;
        this.language = language;
        this.body = body;
        this.argNames = argNames;
        this.argRawTypes = argRawTypes;
        this.rawReturnType = rawReturnType;
        this.calledOnNullInput = calledOnNullInput;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        if (new HashSet<ColumnIdentifier>(this.argNames).size() != this.argNames.size()) {
            throw new InvalidRequestException(String.format("duplicate argument names for given function %s with argument names %s", this.functionName, this.argNames));
        }
        this.argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            this.argTypes.add(rawType.prepare(this.typeKeyspace(rawType)).getType());
        }
        this.returnType = this.rawReturnType.prepare(this.typeKeyspace(this.rawReturnType)).getType();
        return super.prepare();
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getRawKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem(this.functionName.keyspace);
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            FunctionResource resource = FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes);
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, RoleResource.role(state.getClientState().getUser().getName()));
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (Functions.find(this.functionName, this.argTypes) != null && this.orReplace) {
            state.ensureHasPermission(Permission.ALTER, FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes));
        } else {
            state.ensureHasPermission(Permission.CREATE, FunctionResource.keyspace(this.functionName.keyspace));
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (!DatabaseDescriptor.enableUserDefinedFunctions()) {
            throw new InvalidRequestException("User-defined-functions are disabled in cassandra.yaml - set enable_user_defined_functions=true to enable if you are aware of the security risks");
        }
        if (this.ifNotExists && this.orReplace) {
            throw new InvalidRequestException("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives");
        }
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) == null) {
            throw new InvalidRequestException(String.format("Cannot add function '%s' to non existing keyspace '%s'.", this.functionName.name, this.functionName.keyspace));
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(this.replaced ? Event.SchemaChange.Change.UPDATED : Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.FUNCTION, this.udFunction.name().keyspace, this.udFunction.name().name, AbstractType.asCQLTypeStringList(this.udFunction.argTypes()));
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Function old = Functions.find(this.functionName, this.argTypes);
        if (old != null) {
            if (this.ifNotExists) {
                return false;
            }
            if (!this.orReplace) {
                throw new InvalidRequestException(String.format("Function %s already exists", old));
            }
            if (!(old instanceof ScalarFunction)) {
                throw new InvalidRequestException(String.format("Function %s can only replace a function", old));
            }
            if (this.calledOnNullInput != ((ScalarFunction)old).isCalledOnNullInput()) {
                throw new InvalidRequestException(String.format("Function %s can only be replaced with %s", old, this.calledOnNullInput ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT"));
            }
            if (!Functions.typeEquals(old.returnType(), this.returnType)) {
                throw new InvalidRequestException(String.format("Cannot replace function %s, the new return type %s is not compatible with the return type %s of existing function", this.functionName, this.returnType.asCQL3Type(), old.returnType().asCQL3Type()));
            }
        }
        this.udFunction = UDFunction.create(this.functionName, this.argNames, this.argTypes, this.returnType, this.calledOnNullInput, this.language, this.body);
        this.replaced = old != null;
        MigrationManager.announceNewFunction(this.udFunction, isLocalOnly);
        return true;
    }

    private String typeKeyspace(CQL3Type.Raw rawType) {
        String ks = rawType.keyspace();
        if (ks != null) {
            return ks;
        }
        return this.functionName.keyspace;
    }
}

