/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class PrimaryKeyRestrictionSet
extends AbstractPrimaryKeyRestrictions {
    private final RestrictionSet restrictions;
    private boolean eq;
    private boolean in;
    private boolean slice;
    private boolean contains;

    public PrimaryKeyRestrictionSet(CType ctype) {
        super(ctype);
        this.restrictions = new RestrictionSet();
        this.eq = true;
    }

    private PrimaryKeyRestrictionSet(PrimaryKeyRestrictionSet primaryKeyRestrictions, Restriction restriction) throws InvalidRequestException {
        super(primaryKeyRestrictions.ctype);
        this.restrictions = primaryKeyRestrictions.restrictions.addRestriction(restriction);
        if (!primaryKeyRestrictions.isEmpty()) {
            ColumnDefinition lastRestrictionStart = primaryKeyRestrictions.restrictions.lastRestriction().getFirstColumn();
            ColumnDefinition newRestrictionStart = restriction.getFirstColumn();
            RequestValidations.checkFalse(primaryKeyRestrictions.isSlice() && newRestrictionStart.position() > lastRestrictionStart.position(), "Clustering column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", newRestrictionStart.name, lastRestrictionStart.name);
            if (newRestrictionStart.position() < lastRestrictionStart.position() && restriction.isSlice()) {
                throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", this.restrictions.nextColumn((ColumnDefinition)newRestrictionStart).name, newRestrictionStart.name);
            }
        }
        if (restriction.isSlice() || primaryKeyRestrictions.isSlice()) {
            this.slice = true;
        } else if (restriction.isContains() || primaryKeyRestrictions.isContains()) {
            this.contains = true;
        } else if (restriction.isIN()) {
            this.in = true;
        } else {
            this.eq = true;
        }
    }

    @Override
    public boolean isSlice() {
        return this.slice;
    }

    @Override
    public boolean isEQ() {
        return this.eq;
    }

    @Override
    public boolean isIN() {
        return this.in;
    }

    @Override
    public boolean isOnToken() {
        return false;
    }

    @Override
    public boolean isContains() {
        return this.contains;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return this.restrictions.getFunctions();
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            if (this.isEmpty()) {
                return (PrimaryKeyRestrictions)restriction;
            }
            return new TokenFilter(this, (TokenRestriction)restriction);
        }
        return new PrimaryKeyRestrictionSet(this, restriction);
    }

    @Override
    public List<Composite> valuesAsComposites(QueryOptions options) throws InvalidRequestException {
        return this.appendTo(new CompositesBuilder(this.ctype), options).build();
    }

    @Override
    public CompositesBuilder appendTo(CompositesBuilder builder, QueryOptions options) {
        for (Restriction r : this.restrictions) {
            r.appendTo(builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return builder;
    }

    @Override
    public CompositesBuilder appendBoundTo(CompositesBuilder builder, Bound bound, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Composite> boundsAsComposites(Bound bound, QueryOptions options) throws InvalidRequestException {
        CompositesBuilder builder = new CompositesBuilder(this.ctype);
        int keyPosition = 0;
        for (Restriction r : this.restrictions) {
            Bound b;
            ColumnDefinition def = r.getFirstColumn();
            Bound bound2 = b = !def.isReversedType() ? bound : bound.reverse();
            if (keyPosition != def.position() || r.isContains()) break;
            if (r.isSlice()) {
                if (!r.hasBound(b)) {
                    return builder.buildWithEOC(bound.isEnd() ? Composite.EOC.END : Composite.EOC.START);
                }
                r.appendBoundTo(builder, b, options);
                Composite.EOC eoc = PrimaryKeyRestrictionSet.eocFor(r, bound, b);
                return builder.buildWithEOC(eoc);
            }
            r.appendBoundTo(builder, b, options);
            if (builder.hasMissingElements()) {
                return Collections.emptyList();
            }
            keyPosition = r.getLastColumn().position() + 1;
        }
        Composite.EOC eoc = !builder.hasRemaining() ? Composite.EOC.NONE : (bound.isEnd() ? Composite.EOC.END : Composite.EOC.START);
        return builder.buildWithEOC(eoc);
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
        return Composites.toByteBuffers(this.valuesAsComposites(options));
    }

    @Override
    public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
        return Composites.toByteBuffers(this.boundsAsComposites(b, options));
    }

    private static Composite.EOC eocFor(Restriction r, Bound eocBound, Bound inclusiveBound) {
        if (eocBound.isStart()) {
            return r.isInclusive(inclusiveBound) ? Composite.EOC.NONE : Composite.EOC.END;
        }
        return r.isInclusive(inclusiveBound) ? Composite.EOC.END : Composite.EOC.START;
    }

    @Override
    public boolean hasBound(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().hasBound(b);
    }

    @Override
    public boolean isInclusive(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().isInclusive(b);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        return this.restrictions.hasSupportingIndex(indexManager);
    }

    @Override
    public void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        Boolean clusteringColumns = null;
        int position = 0;
        for (Restriction restriction : this.restrictions) {
            ColumnDefinition columnDef = restriction.getFirstColumn();
            if (clusteringColumns == null) {
                Boolean bl = clusteringColumns = columnDef.isClusteringColumn() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (clusteringColumns.booleanValue() && !restriction.isContains() && position == columnDef.position()) {
                position = restriction.getLastColumn().position() + 1;
                if (!restriction.hasSupportingIndex(indexManager)) continue;
            }
            restriction.addIndexExpressionTo(expressions, indexManager, options);
        }
    }

    @Override
    public Collection<ColumnDefinition> getColumnDefs() {
        return this.restrictions.getColumnDefs();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.restrictions.firstColumn();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.restrictions.lastColumn();
    }
}

