/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    public static final String[] ACCEPTED_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static boolean checkedExpiry = false;

    public static SSLServerSocket getServerSocket(EncryptionOptions options, InetAddress address, int port) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options, true);
        SSLServerSocket serverSocket = (SSLServerSocket)ctx.getServerSocketFactory().createServerSocket();
        serverSocket.setReuseAddress(true);
        String[] suits = SSLFactory.filterCipherSuites(serverSocket.getSupportedCipherSuites(), options.cipher_suites);
        serverSocket.setEnabledCipherSuites(suits);
        serverSocket.setNeedClientAuth(options.require_client_auth);
        serverSocket.setEnabledProtocols(ACCEPTED_PROTOCOLS);
        serverSocket.bind(new InetSocketAddress(address, port), 500);
        return serverSocket;
    }

    public static SSLSocket getSocket(EncryptionOptions options, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options, true);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket(address, port, localAddress, localPort);
        String[] suits = SSLFactory.filterCipherSuites(socket.getSupportedCipherSuites(), options.cipher_suites);
        socket.setEnabledCipherSuites(suits);
        socket.setEnabledProtocols(ACCEPTED_PROTOCOLS);
        return socket;
    }

    public static SSLSocket getSocket(EncryptionOptions options, InetAddress address, int port) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options, true);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket(address, port);
        String[] suits = SSLFactory.filterCipherSuites(socket.getSupportedCipherSuites(), options.cipher_suites);
        socket.setEnabledCipherSuites(suits);
        socket.setEnabledProtocols(ACCEPTED_PROTOCOLS);
        return socket;
    }

    public static SSLSocket getSocket(EncryptionOptions options) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options, true);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket();
        String[] suits = SSLFactory.filterCipherSuites(socket.getSupportedCipherSuites(), options.cipher_suites);
        socket.setEnabledCipherSuites(suits);
        socket.setEnabledProtocols(ACCEPTED_PROTOCOLS);
        return socket;
    }

    public static SSLContext createSSLContext(EncryptionOptions options, boolean buildTruststore) throws IOException {
        SSLContext ctx;
        FileInputStream tsf = null;
        FileInputStream ksf = null;
        try {
            ctx = SSLContext.getInstance(options.protocol);
            TrustManager[] trustManagers = null;
            if (buildTruststore) {
                tsf = new FileInputStream(options.truststore);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(options.algorithm);
                KeyStore ts = KeyStore.getInstance(options.store_type);
                ts.load(tsf, options.truststore_password.toCharArray());
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            }
            ksf = new FileInputStream(options.keystore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(options.algorithm);
            KeyStore ks = KeyStore.getInstance(options.store_type);
            ks.load(ksf, options.keystore_password.toCharArray());
            if (!checkedExpiry) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    Date expires;
                    String alias = aliases.nextElement();
                    if (!ks.getCertificate(alias).getType().equals("X.509") || !(expires = ((X509Certificate)ks.getCertificate(alias)).getNotAfter()).before(new Date())) continue;
                    logger.warn("Certificate for {} expired on {}", (Object)alias, (Object)expires);
                }
                checkedExpiry = true;
            }
            kmf.init(ks, options.keystore_password.toCharArray());
            ctx.init(kmf.getKeyManagers(), trustManagers, null);
        }
        catch (Exception e) {
            try {
                throw new IOException("Error creating the initializing the SSL Context", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(tsf);
                FileUtils.closeQuietly(ksf);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(tsf);
        FileUtils.closeQuietly(ksf);
        return ctx;
    }

    private static String[] filterCipherSuites(String[] supported, String[] desired) {
        HashSet des = Sets.newHashSet((Object[])desired);
        Sets.SetView toReturn = Sets.intersection((Set)Sets.newHashSet((Object[])supported), (Set)des);
        if (des.size() > toReturn.size()) {
            logger.warn("Filtering out {} as it isnt supported by the socket", (Object)StringUtils.join((Iterable)Sets.difference((Set)des, (Set)toReturn), (String)","));
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }
}

