/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.repair.IRequestCoordinator;
import org.apache.cassandra.repair.IRequestProcessor;

public class DatacenterAwareRequestCoordinator
implements IRequestCoordinator<InetAddress> {
    private Map<String, Queue<InetAddress>> requestsByDatacenter = new HashMap<String, Queue<InetAddress>>();
    private int remaining = 0;
    private final IRequestProcessor<InetAddress> processor;

    protected DatacenterAwareRequestCoordinator(IRequestProcessor<InetAddress> processor) {
        this.processor = processor;
    }

    @Override
    public void add(InetAddress request) {
        String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(request);
        Queue<InetAddress> queue = this.requestsByDatacenter.get(dc);
        if (queue == null) {
            queue = new LinkedList<InetAddress>();
            this.requestsByDatacenter.put(dc, queue);
        }
        queue.add(request);
        ++this.remaining;
    }

    @Override
    public void start() {
        for (Queue<InetAddress> requests : this.requestsByDatacenter.values()) {
            if (requests.isEmpty()) continue;
            this.processor.process(requests.peek());
        }
    }

    @Override
    public int completed(InetAddress request) {
        String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(request);
        Queue<InetAddress> requests = this.requestsByDatacenter.get(dc);
        assert (requests != null);
        assert (request.equals(requests.peek()));
        requests.poll();
        if (!requests.isEmpty()) {
            this.processor.process(requests.peek());
        }
        return --this.remaining;
    }
}

