/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedSegmentedFile
extends SegmentedFile {
    public BufferedSegmentedFile(String path, long length) {
        super(new Cleanup(path), path, length);
    }

    private BufferedSegmentedFile(BufferedSegmentedFile copy) {
        super(copy);
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = RandomAccessReader.open(new File(this.path));
        reader.seek(position);
        return reader;
    }

    @Override
    public BufferedSegmentedFile sharedCopy() {
        return new BufferedSegmentedFile(this);
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path, long overrideLength, boolean isFinal) {
            assert (!isFinal || overrideLength <= 0L);
            long length = overrideLength > 0L ? overrideLength : new File(path).length();
            return new BufferedSegmentedFile(path, length);
        }
    }

    private static class Cleanup
    extends SegmentedFile.Cleanup {
        protected Cleanup(String path) {
            super(path);
        }

        @Override
        public void tidy() throws Exception {
        }
    }
}

