/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkRecordWriter<K, V>
extends RecordWriter<K, V>
implements org.apache.hadoop.mapred.RecordWriter<K, V> {
    public static final String OUTPUT_LOCATION = "mapreduce.output.bulkoutputformat.localdir";
    public static final String BUFFER_SIZE_IN_MB = "mapreduce.output.bulkoutputformat.buffersize";
    public static final String STREAM_THROTTLE_MBITS = "mapreduce.output.bulkoutputformat.streamthrottlembits";
    public static final String MAX_FAILED_HOSTS = "mapreduce.output.bulkoutputformat.maxfailedhosts";
    private final Logger logger = LoggerFactory.getLogger(AbstractBulkRecordWriter.class);
    protected final Configuration conf;
    protected final int maxFailures;
    protected final int bufferSize;
    protected Closeable writer;
    protected SSTableLoader loader;
    protected Progressable progress;
    protected TaskAttemptContext context;

    protected AbstractBulkRecordWriter(TaskAttemptContext context) {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
    }

    protected AbstractBulkRecordWriter(Configuration conf, Progressable progress) {
        this(conf);
        this.progress = progress;
    }

    protected AbstractBulkRecordWriter(Configuration conf) {
        Config.setClientMode(true);
        Config.setOutboundBindAny(true);
        this.conf = conf;
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(Integer.parseInt(conf.get(STREAM_THROTTLE_MBITS, "0")));
        this.maxFailures = Integer.parseInt(conf.get(MAX_FAILED_HOSTS, "0"));
        this.bufferSize = Integer.parseInt(conf.get(BUFFER_SIZE_IN_MB, "64"));
    }

    protected String getOutputLocation() throws IOException {
        String dir = this.conf.get(OUTPUT_LOCATION, System.getProperty("java.io.tmpdir"));
        if (dir == null) {
            throw new IOException("Output directory not defined, if hadoop is not setting java.io.tmpdir then define mapreduce.output.bulkoutputformat.localdir");
        }
        return dir;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            StreamResultFuture future = this.loader.stream();
            while (true) {
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException te) {
                    if (null != this.progress) {
                        this.progress.progress();
                    }
                    if (null == this.context) continue;
                    HadoopCompat.progress(this.context);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                break;
            }
            if (this.loader.getFailedHosts().size() > 0) {
                if (this.loader.getFailedHosts().size() > this.maxFailures) {
                    throw new IOException("Too many hosts failed: " + this.loader.getFailedHosts());
                }
                this.logger.warn("Some hosts failed: {}", this.loader.getFailedHosts());
            }
        }
    }

    public static class NullOutputHandler
    implements OutputHandler {
        @Override
        public void output(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String msg, Throwable th) {
        }
    }

    public static class ExternalClient
    extends SSTableLoader.Client {
        private final Map<String, Map<String, CFMetaData>> knownCfs = new HashMap<String, Map<String, CFMetaData>>();
        private final Configuration conf;
        private final String hostlist;
        private final int rpcPort;
        private final String username;
        private final String password;

        public ExternalClient(Configuration conf) {
            this.conf = conf;
            this.hostlist = ConfigHelper.getOutputInitialAddress(conf);
            this.rpcPort = ConfigHelper.getOutputRpcPort(conf);
            this.username = ConfigHelper.getOutputKeyspaceUserName(conf);
            this.password = ConfigHelper.getOutputKeyspacePassword(conf);
        }

        @Override
        public void init(String keyspace) {
            String[] nodes;
            HashSet<InetAddress> hosts = new HashSet<InetAddress>();
            for (String node : nodes = this.hostlist.split(",")) {
                try {
                    hosts.add(InetAddress.getByName(node));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            Iterator hostiter = hosts.iterator();
            while (hostiter.hasNext()) {
                try {
                    InetAddress host = (InetAddress)hostiter.next();
                    Cassandra.Client client = ConfigHelper.createConnection(this.conf, host.getHostAddress(), this.rpcPort);
                    client.set_keyspace(keyspace);
                    if (this.username != null) {
                        HashMap<String, String> creds = new HashMap<String, String>();
                        creds.put("username", this.username);
                        creds.put("password", this.password);
                        AuthenticationRequest authRequest = new AuthenticationRequest(creds);
                        client.login(authRequest);
                    }
                    List tokenRanges = client.describe_ring(keyspace);
                    List ksDefs = client.describe_keyspaces();
                    this.setPartitioner(client.describe_partitioner());
                    Token.TokenFactory tkFactory = this.getPartitioner().getTokenFactory();
                    for (TokenRange tr : tokenRanges) {
                        Range<Token> range = new Range<Token>(tkFactory.fromString(tr.start_token), tkFactory.fromString(tr.end_token));
                        for (String ep : tr.endpoints) {
                            this.addRangeForEndpoint(range, InetAddress.getByName(ep));
                        }
                    }
                    for (KsDef ksDef : ksDefs) {
                        HashMap<String, CFMetaData> cfs = new HashMap<String, CFMetaData>(ksDef.cf_defs.size());
                        for (CfDef cfDef : ksDef.cf_defs) {
                            cfs.put(cfDef.name, CFMetaData.fromThrift(cfDef));
                        }
                        this.knownCfs.put(ksDef.name, cfs);
                    }
                    break;
                }
                catch (Exception e) {
                    if (hostiter.hasNext()) continue;
                    throw new RuntimeException("Could not retrieve endpoint ranges: ", e);
                }
            }
        }

        @Override
        public CFMetaData getCFMetaData(String keyspace, String cfName) {
            Map<String, CFMetaData> cfs = this.knownCfs.get(keyspace);
            return cfs != null ? cfs.get(cfName) : null;
        }
    }
}

