/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.CompactionHistoryTabularData;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SystemKeyspace.class);
    public static final String PEERS_CF = "peers";
    public static final String PEER_EVENTS_CF = "peer_events";
    public static final String LOCAL_CF = "local";
    public static final String INDEX_CF = "IndexInfo";
    public static final String HINTS_CF = "hints";
    public static final String RANGE_XFERS_CF = "range_xfers";
    public static final String BATCHLOG_CF = "batchlog";
    public static final String SCHEMA_KEYSPACES_CF = "schema_keyspaces";
    public static final String SCHEMA_COLUMNFAMILIES_CF = "schema_columnfamilies";
    public static final String SCHEMA_COLUMNS_CF = "schema_columns";
    public static final String SCHEMA_TRIGGERS_CF = "schema_triggers";
    public static final String SCHEMA_USER_TYPES_CF = "schema_usertypes";
    public static final String COMPACTION_LOG = "compactions_in_progress";
    public static final String PAXOS_CF = "paxos";
    public static final String SSTABLE_ACTIVITY_CF = "sstable_activity";
    public static final String COMPACTION_HISTORY_CF = "compaction_history";
    public static final String SIZE_ESTIMATES_CF = "size_estimates";
    private static final String LOCAL_KEY = "local";
    public static final List<String> allSchemaCfs = Arrays.asList("schema_keyspaces", "schema_columnfamilies", "schema_columns", "schema_triggers", "schema_usertypes");
    private static volatile Map<UUID, Pair<ReplayPosition, Long>> truncationRecords;

    private static DecoratedKey decorate(ByteBuffer key) {
        return StorageService.getPartitioner().decorateKey(key);
    }

    public static void finishStartup() {
        SystemKeyspace.setupVersion();
        SystemKeyspace.migrateIndexInterval();
        SystemKeyspace.migrateCachingOption();
        KSMetaData ksmd = Schema.instance.getKSMetaData("system");
        long timestamp = FBUtilities.timestampMicros();
        for (String cfname : Arrays.asList(SCHEMA_KEYSPACES_CF, SCHEMA_COLUMNFAMILIES_CF, SCHEMA_COLUMNS_CF, SCHEMA_TRIGGERS_CF, SCHEMA_USER_TYPES_CF)) {
            QueryProcessor.executeOnceInternal(String.format("DELETE FROM system.%s USING TIMESTAMP ? WHERE keyspace_name = ?", cfname), timestamp, ksmd.name);
        }
        ksmd.toSchema(timestamp + 1L).apply();
    }

    private static void setupVersion() {
        String req = "INSERT INTO system.%s (key, release_version, cql_version, thrift_version, native_protocol_version, data_center, rack, partitioner, rpc_address, broadcast_address) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        QueryProcessor.executeOnceInternal(String.format(req, "local"), "local", FBUtilities.getReleaseVersionString(), QueryProcessor.CQL_VERSION.toString(), "19.39.0", String.valueOf(3), snitch.getDatacenter(FBUtilities.getBroadcastAddress()), snitch.getRack(FBUtilities.getBroadcastAddress()), DatabaseDescriptor.getPartitioner().getClass().getName(), DatabaseDescriptor.getRpcAddress(), FBUtilities.getBroadcastAddress());
    }

    private static void migrateIndexInterval() {
        for (UntypedResultSet.Row row : QueryProcessor.executeOnceInternal(String.format("SELECT * FROM system.%s", SCHEMA_COLUMNFAMILIES_CF), new Object[0])) {
            if (!row.has("index_interval")) continue;
            logger.debug("Migrating index_interval to min_index_interval");
            CFMetaData table = CFMetaData.fromSchema(row);
            String query = String.format("SELECT writetime(type) FROM system.%s WHERE keyspace_name = ? AND columnfamily_name = ?", SCHEMA_COLUMNFAMILIES_CF);
            long timestamp = QueryProcessor.executeOnceInternal(query, table.ksName, table.cfName).one().getLong("writetime(type)");
            try {
                table.toSchema(timestamp).apply();
            }
            catch (ConfigurationException configurationException) {}
        }
    }

    private static void migrateCachingOption() {
        for (UntypedResultSet.Row row : QueryProcessor.executeOnceInternal(String.format("SELECT * FROM system.%s", SCHEMA_COLUMNFAMILIES_CF), new Object[0])) {
            if (!row.has("caching") || !CachingOptions.isLegacy(row.getString("caching"))) continue;
            try {
                CachingOptions caching = CachingOptions.fromString(row.getString("caching"));
                CFMetaData table = CFMetaData.fromSchema(row);
                logger.info("Migrating caching option {} to {} for {}.{}", new Object[]{row.getString("caching"), caching.toString(), table.ksName, table.cfName});
                String query = String.format("SELECT writetime(type) FROM system.%s WHERE keyspace_name = ? AND columnfamily_name = ?", SCHEMA_COLUMNFAMILIES_CF);
                long timestamp = QueryProcessor.executeOnceInternal(query, table.ksName, table.cfName).one().getLong("writetime(type)");
                table.toSchema(timestamp).apply();
            }
            catch (ConfigurationException configurationException) {}
        }
    }

    public static UUID startCompaction(ColumnFamilyStore cfs, Iterable<SSTableReader> toCompact) {
        if ("system".equals(cfs.keyspace.getName())) {
            return null;
        }
        UUID compactionId = UUIDGen.getTimeUUID();
        Iterable generations = Iterables.transform(toCompact, (Function)new Function<SSTableReader, Integer>(){

            public Integer apply(SSTableReader sstable) {
                return sstable.descriptor.generation;
            }
        });
        String req = "INSERT INTO system.%s (id, keyspace_name, columnfamily_name, inputs) VALUES (?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, COMPACTION_LOG), compactionId, cfs.keyspace.getName(), cfs.name, Sets.newHashSet((Iterable)generations));
        SystemKeyspace.forceBlockingFlush(COMPACTION_LOG);
        return compactionId;
    }

    public static void finishCompaction(UUID taskId) {
        assert (taskId != null);
        QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE id = ?", COMPACTION_LOG), taskId);
        SystemKeyspace.forceBlockingFlush(COMPACTION_LOG);
    }

    public static Map<Pair<String, String>, Map<Integer, UUID>> getUnfinishedCompactions() {
        String req = "SELECT * FROM system.%s";
        UntypedResultSet resultSet = QueryProcessor.executeInternal(String.format(req, COMPACTION_LOG), new Object[0]);
        HashMap<Pair<String, String>, Map<Integer, UUID>> unfinishedCompactions = new HashMap<Pair<String, String>, Map<Integer, UUID>>();
        for (UntypedResultSet.Row row : resultSet) {
            String keyspace = row.getString("keyspace_name");
            String columnfamily = row.getString("columnfamily_name");
            Set<Integer> inputs = row.getSet("inputs", Int32Type.instance);
            UUID taskID = row.getUUID("id");
            Pair<String, String> kscf = Pair.create(keyspace, columnfamily);
            HashMap<Integer, UUID> generationToTaskID = (HashMap<Integer, UUID>)unfinishedCompactions.get(kscf);
            if (generationToTaskID == null) {
                generationToTaskID = new HashMap<Integer, UUID>(inputs.size());
            }
            for (Integer generation : inputs) {
                generationToTaskID.put(generation, taskID);
            }
            unfinishedCompactions.put(kscf, generationToTaskID);
        }
        return unfinishedCompactions;
    }

    public static void discardCompactionsInProgress() {
        ColumnFamilyStore compactionLog = Keyspace.open("system").getColumnFamilyStore(COMPACTION_LOG);
        compactionLog.truncateBlocking();
    }

    public static void updateCompactionHistory(String ksname, String cfname, long compactedAt, long bytesIn, long bytesOut, Map<Integer, Long> rowsMerged) {
        if (ksname.equals("system") && cfname.equals(COMPACTION_HISTORY_CF)) {
            return;
        }
        String req = "INSERT INTO system.%s (id, keyspace_name, columnfamily_name, compacted_at, bytes_in, bytes_out, rows_merged) VALUES (?, ?, ?, ?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, COMPACTION_HISTORY_CF), UUIDGen.getTimeUUID(), ksname, cfname, ByteBufferUtil.bytes(compactedAt), bytesIn, bytesOut, rowsMerged);
    }

    public static TabularData getCompactionHistory() throws OpenDataException {
        UntypedResultSet queryResultSet = QueryProcessor.executeInternal(String.format("SELECT * from system.%s", COMPACTION_HISTORY_CF), new Object[0]);
        return CompactionHistoryTabularData.from(queryResultSet);
    }

    public static synchronized void saveTruncationRecord(ColumnFamilyStore cfs, long truncatedAt, ReplayPosition position) {
        String req = "UPDATE system.%s SET truncated_at = truncated_at + ? WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), SystemKeyspace.truncationAsMapEntry(cfs, truncatedAt, position));
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush("local");
    }

    public static synchronized void removeTruncationRecord(UUID cfId) {
        String req = "DELETE truncated_at[?] from system.%s WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), cfId);
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush("local");
    }

    private static Map<UUID, ByteBuffer> truncationAsMapEntry(ColumnFamilyStore cfs, long truncatedAt, ReplayPosition position) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            ReplayPosition.serializer.serialize(position, (DataOutputPlus)out);
            out.writeLong(truncatedAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap(cfs.metadata.cfId, ByteBuffer.wrap(out.getData(), 0, out.getLength()));
    }

    public static ReplayPosition getTruncatedPosition(UUID cfId) {
        Pair<ReplayPosition, Long> record = SystemKeyspace.getTruncationRecord(cfId);
        return record == null ? null : (ReplayPosition)record.left;
    }

    public static long getTruncatedAt(UUID cfId) {
        Pair<ReplayPosition, Long> record = SystemKeyspace.getTruncationRecord(cfId);
        return record == null ? Long.MIN_VALUE : (Long)record.right;
    }

    private static synchronized Pair<ReplayPosition, Long> getTruncationRecord(UUID cfId) {
        if (truncationRecords == null) {
            truncationRecords = SystemKeyspace.readTruncationRecords();
        }
        return truncationRecords.get(cfId);
    }

    private static Map<UUID, Pair<ReplayPosition, Long>> readTruncationRecords() {
        UntypedResultSet rows = QueryProcessor.executeInternal(String.format("SELECT truncated_at FROM system.%s WHERE key = '%s'", "local", "local"), new Object[0]);
        HashMap<UUID, Pair<ReplayPosition, Long>> records = new HashMap<UUID, Pair<ReplayPosition, Long>>();
        if (!rows.isEmpty() && rows.one().has("truncated_at")) {
            Map<UUID, ByteBuffer> map = rows.one().getMap("truncated_at", UUIDType.instance, BytesType.instance);
            for (Map.Entry<UUID, ByteBuffer> entry : map.entrySet()) {
                records.put(entry.getKey(), SystemKeyspace.truncationRecordFromBlob(entry.getValue()));
            }
        }
        return records;
    }

    private static Pair<ReplayPosition, Long> truncationRecordFromBlob(ByteBuffer bytes) {
        try {
            DataInputStream in = new DataInputStream(ByteBufferUtil.inputStream(bytes));
            return Pair.create(ReplayPosition.serializer.deserialize(in), in.available() > 0 ? in.readLong() : Long.MIN_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void updateTokens(InetAddress ep, Collection<Token> tokens) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            SystemKeyspace.removeEndpoint(ep);
            return;
        }
        String req = "INSERT INTO system.%s (peer, tokens) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_CF), ep, SystemKeyspace.tokensAsSet(tokens));
    }

    public static synchronized void updatePreferredIP(InetAddress ep, InetAddress preferred_ip) {
        String req = "INSERT INTO system.%s (peer, preferred_ip) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_CF), ep, preferred_ip);
        SystemKeyspace.forceBlockingFlush(PEERS_CF);
    }

    public static synchronized void updatePeerInfo(InetAddress ep, String columnName, Object value) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            return;
        }
        String req = "INSERT INTO system.%s (peer, %s) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_CF, columnName), ep, value);
    }

    public static synchronized void updateHintsDropped(InetAddress ep, UUID timePeriod, int value) {
        String req = "UPDATE system.%s USING TTL 2592000 SET hints_dropped[ ? ] = ? WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, PEER_EVENTS_CF), timePeriod, value, ep);
    }

    public static synchronized void updateSchemaVersion(UUID version) {
        String req = "INSERT INTO system.%s (key, schema_version) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), version);
    }

    private static Set<String> tokensAsSet(Collection<Token> tokens) {
        Token.TokenFactory factory = StorageService.getPartitioner().getTokenFactory();
        HashSet<String> s = new HashSet<String>(tokens.size());
        for (Token tk : tokens) {
            s.add(factory.toString(tk));
        }
        return s;
    }

    private static Collection<Token> deserializeTokens(Collection<String> tokensStrings) {
        Token.TokenFactory factory = StorageService.getPartitioner().getTokenFactory();
        ArrayList<Token> tokens = new ArrayList<Token>(tokensStrings.size());
        for (String tk : tokensStrings) {
            tokens.add(factory.fromString(tk));
        }
        return tokens;
    }

    public static synchronized void removeEndpoint(InetAddress ep) {
        String req = "DELETE FROM system.%s WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, PEERS_CF), ep);
    }

    public static synchronized void updateTokens(Collection<Token> tokens) {
        assert (!tokens.isEmpty()) : "removeEndpoint should be used instead";
        String req = "INSERT INTO system.%s (key, tokens) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), SystemKeyspace.tokensAsSet(tokens));
        SystemKeyspace.forceBlockingFlush("local");
    }

    public static synchronized Collection<Token> updateLocalTokens(Collection<Token> addTokens, Collection<Token> rmTokens) {
        Collection<Token> tokens = SystemKeyspace.getSavedTokens();
        tokens.removeAll(rmTokens);
        tokens.addAll(addTokens);
        SystemKeyspace.updateTokens(tokens);
        return tokens;
    }

    public static void forceBlockingFlush(String cfname) {
        if (!Boolean.getBoolean("cassandra.unsafesystem")) {
            FBUtilities.waitOnFuture(Keyspace.open("system").getColumnFamilyStore(cfname).forceFlush());
        }
    }

    public static SetMultimap<InetAddress, Token> loadTokens() {
        HashMultimap tokenMap = HashMultimap.create();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, tokens FROM system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("tokens")) continue;
            tokenMap.putAll((Object)peer, SystemKeyspace.deserializeTokens(row.getSet("tokens", UTF8Type.instance)));
        }
        return tokenMap;
    }

    public static Map<InetAddress, UUID> loadHostIds() {
        HashMap<InetAddress, UUID> hostIdMap = new HashMap<InetAddress, UUID>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, host_id FROM system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("host_id")) continue;
            hostIdMap.put(peer, row.getUUID("host_id"));
        }
        return hostIdMap;
    }

    public static InetAddress getPreferredIP(InetAddress ep) {
        String req = "SELECT preferred_ip FROM system.%s WHERE peer=?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS_CF), ep);
        if (!result.isEmpty() && result.one().has("preferred_ip")) {
            return result.one().getInetAddress("preferred_ip");
        }
        return ep;
    }

    public static Map<InetAddress, Map<String, String>> loadDcRackInfo() {
        HashMap<InetAddress, Map<String, String>> result = new HashMap<InetAddress, Map<String, String>>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, data_center, rack from system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("data_center") || !row.has("rack")) continue;
            HashMap<String, String> dcRack = new HashMap<String, String>();
            dcRack.put("data_center", row.getString("data_center"));
            dcRack.put("rack", row.getString("rack"));
            result.put(peer, dcRack);
        }
        return result;
    }

    public static SemanticVersion getReleaseVersion(InetAddress ep) {
        try {
            if (FBUtilities.getBroadcastAddress().equals(ep)) {
                return new SemanticVersion(FBUtilities.getReleaseVersionString());
            }
            String req = "SELECT release_version FROM system.%s WHERE peer=?";
            UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS_CF), ep);
            if (result != null && result.one().has("release_version")) {
                return new SemanticVersion(result.one().getString("release_version"));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void checkHealth() throws ConfigurationException {
        Keyspace keyspace;
        try {
            keyspace = Keyspace.open("system");
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system keyspace!");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore("local");
        String req = "SELECT cluster_name FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "local", "local"), new Object[0]);
        if (result.isEmpty() || !result.one().has("cluster_name")) {
            if (!cfs.getSSTables().isEmpty()) {
                throw new ConfigurationException("Found system keyspace files, but they couldn't be loaded!");
            }
            req = "INSERT INTO system.%s (key, cluster_name) VALUES ('%s', ?)";
            QueryProcessor.executeInternal(String.format(req, "local", "local"), DatabaseDescriptor.getClusterName());
            return;
        }
        String savedClusterName = result.one().getString("cluster_name");
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Collection<Token> getSavedTokens() {
        String req = "SELECT tokens FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "local", "local"), new Object[0]);
        return result.isEmpty() || !result.one().has("tokens") ? Collections.emptyList() : SystemKeyspace.deserializeTokens(result.one().getSet("tokens", UTF8Type.instance));
    }

    public static int incrementAndGetGeneration() {
        int generation;
        String req = "SELECT gossip_generation FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "local", "local"), new Object[0]);
        if (result.isEmpty() || !result.one().has("gossip_generation")) {
            generation = (int)(System.currentTimeMillis() / 1000L);
        } else {
            int now;
            int storedGeneration = result.one().getInt("gossip_generation") + 1;
            if (storedGeneration >= (now = (int)(System.currentTimeMillis() / 1000L))) {
                logger.warn("Using stored Gossip Generation {} as it is greater than current system time {}.  See CASSANDRA-3654 if you experience problems", (Object)storedGeneration, (Object)now);
                generation = storedGeneration;
            } else {
                generation = now;
            }
        }
        req = "INSERT INTO system.%s (key, gossip_generation) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), generation);
        SystemKeyspace.forceBlockingFlush("local");
        return generation;
    }

    public static BootstrapState getBootstrapState() {
        String req = "SELECT bootstrapped FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "local", "local"), new Object[0]);
        if (result.isEmpty() || !result.one().has("bootstrapped")) {
            return BootstrapState.NEEDS_BOOTSTRAP;
        }
        return BootstrapState.valueOf(result.one().getString("bootstrapped"));
    }

    public static boolean bootstrapComplete() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.COMPLETED;
    }

    public static boolean bootstrapInProgress() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.IN_PROGRESS;
    }

    public static void setBootstrapState(BootstrapState state) {
        String req = "INSERT INTO system.%s (key, bootstrapped) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), state.name());
        SystemKeyspace.forceBlockingFlush("local");
    }

    public static boolean isIndexBuilt(String keyspaceName, String indexName) {
        ColumnFamilyStore cfs = Keyspace.open("system").getColumnFamilyStore(INDEX_CF);
        QueryFilter filter = QueryFilter.getNamesFilter(SystemKeyspace.decorate(ByteBufferUtil.bytes(keyspaceName)), INDEX_CF, FBUtilities.singleton(cfs.getComparator().makeCellName(indexName), cfs.getComparator()), System.currentTimeMillis());
        return ColumnFamilyStore.removeDeleted(cfs.getColumnFamily(filter), Integer.MAX_VALUE) != null;
    }

    public static void setIndexBuilt(String keyspaceName, String indexName) {
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create("system", INDEX_CF);
        ((ColumnFamily)cf).addColumn(new BufferCell(cf.getComparator().makeCellName(indexName), ByteBufferUtil.EMPTY_BYTE_BUFFER, FBUtilities.timestampMicros()));
        new Mutation("system", ByteBufferUtil.bytes(keyspaceName), cf).apply();
        SystemKeyspace.forceBlockingFlush(INDEX_CF);
    }

    public static void setIndexRemoved(String keyspaceName, String indexName) {
        Mutation mutation = new Mutation("system", ByteBufferUtil.bytes(keyspaceName));
        mutation.delete(INDEX_CF, CFMetaData.IndexCf.comparator.makeCellName(indexName), FBUtilities.timestampMicros());
        mutation.apply();
    }

    public static UUID getLocalHostId() {
        String req = "SELECT host_id FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "local", "local"), new Object[0]);
        if (!result.isEmpty() && result.one().has("host_id")) {
            return result.one().getUUID("host_id");
        }
        UUID hostId = UUID.randomUUID();
        logger.warn("No host ID found, created {} (Note: This should happen exactly once per node).", (Object)hostId);
        return SystemKeyspace.setLocalHostId(hostId);
    }

    public static UUID setLocalHostId(UUID hostId) {
        String req = "INSERT INTO system.%s (key, host_id) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, "local", "local"), hostId);
        return hostId;
    }

    public static ColumnFamilyStore schemaCFS(String cfName) {
        return Keyspace.open("system").getColumnFamilyStore(cfName);
    }

    public static List<Row> serializedSchema() {
        ArrayList<Row> schema = new ArrayList<Row>();
        for (String cf : allSchemaCfs) {
            schema.addAll(SystemKeyspace.serializedSchema(cf));
        }
        return schema;
    }

    public static List<Row> serializedSchema(String schemaCfName) {
        Token minToken = StorageService.getPartitioner().getMinimumToken();
        return SystemKeyspace.schemaCFS(schemaCfName).getRangeSlice(new Range<RowPosition>(minToken.minKeyBound(), minToken.maxKeyBound()), null, new IdentityQueryFilter(), Integer.MAX_VALUE, System.currentTimeMillis());
    }

    public static Collection<Mutation> serializeSchema() {
        HashMap<DecoratedKey, Mutation> mutationMap = new HashMap<DecoratedKey, Mutation>();
        for (String cf : allSchemaCfs) {
            SystemKeyspace.serializeSchema(mutationMap, cf);
        }
        return mutationMap.values();
    }

    private static void serializeSchema(Map<DecoratedKey, Mutation> mutationMap, String schemaCfName) {
        for (Row schemaRow : SystemKeyspace.serializedSchema(schemaCfName)) {
            if (Schema.ignoredSchemaRow(schemaRow)) continue;
            Mutation mutation = mutationMap.get(schemaRow.key);
            if (mutation == null) {
                mutation = new Mutation("system", schemaRow.key.getKey());
                mutationMap.put(schemaRow.key, mutation);
            }
            mutation.add(schemaRow.cf);
        }
    }

    public static Map<DecoratedKey, ColumnFamily> getSchema(String schemaCfName, Set<String> keyspaces) {
        HashMap<DecoratedKey, ColumnFamily> schema = new HashMap<DecoratedKey, ColumnFamily>();
        for (String keyspace : keyspaces) {
            Row schemaEntity = SystemKeyspace.readSchemaRow(schemaCfName, keyspace);
            if (schemaEntity.cf == null) continue;
            schema.put(schemaEntity.key, schemaEntity.cf);
        }
        return schema;
    }

    public static ByteBuffer getSchemaKSKey(String ksName) {
        return AsciiType.instance.fromString(ksName);
    }

    public static Row readSchemaRow(String schemaCfName, String ksName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemKeyspace.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemKeyspace.schemaCFS(schemaCfName);
        ColumnFamily result = schemaCFS.getColumnFamily(QueryFilter.getIdentityFilter(key, schemaCfName, System.currentTimeMillis()));
        return new Row(key, result);
    }

    public static Row readSchemaRow(String schemaCfName, String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemKeyspace.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemKeyspace.schemaCFS(schemaCfName);
        Composite prefix = schemaCFS.getComparator().make(cfName);
        ColumnFamily cf = schemaCFS.getColumnFamily(key, prefix, prefix.end(), false, Integer.MAX_VALUE, System.currentTimeMillis());
        return new Row(key, cf);
    }

    public static PaxosState loadPaxosState(ByteBuffer key, CFMetaData metadata) {
        String req = "SELECT * FROM system.%s WHERE row_key = ? AND cf_id = ?";
        UntypedResultSet results = QueryProcessor.executeInternal(String.format(req, PAXOS_CF), key, metadata.cfId);
        if (results.isEmpty()) {
            return new PaxosState(key, metadata);
        }
        UntypedResultSet.Row row = results.one();
        Commit promised = row.has("in_progress_ballot") ? new Commit(key, row.getUUID("in_progress_ballot"), ArrayBackedSortedColumns.factory.create(metadata)) : Commit.emptyCommit(key, metadata);
        Commit accepted = row.has("proposal") ? new Commit(key, row.getUUID("proposal_ballot"), ColumnFamily.fromBytes(row.getBytes("proposal"))) : Commit.emptyCommit(key, metadata);
        Commit mostRecent = row.has("most_recent_commit") ? new Commit(key, row.getUUID("most_recent_commit_at"), ColumnFamily.fromBytes(row.getBytes("most_recent_commit"))) : Commit.emptyCommit(key, metadata);
        return new PaxosState(promised, accepted, mostRecent);
    }

    public static void savePaxosPromise(Commit promise) {
        String req = "UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET in_progress_ballot = ? WHERE row_key = ? AND cf_id = ?";
        QueryProcessor.executeInternal(String.format(req, PAXOS_CF), UUIDGen.microsTimestamp(promise.ballot), SystemKeyspace.paxosTtl(promise.update.metadata), promise.ballot, promise.key, promise.update.id());
    }

    public static void savePaxosProposal(Commit proposal) {
        QueryProcessor.executeInternal(String.format("UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET proposal_ballot = ?, proposal = ? WHERE row_key = ? AND cf_id = ?", PAXOS_CF), UUIDGen.microsTimestamp(proposal.ballot), SystemKeyspace.paxosTtl(proposal.update.metadata), proposal.ballot, proposal.update.toBytes(), proposal.key, proposal.update.id());
    }

    private static int paxosTtl(CFMetaData metadata) {
        return Math.max(10800, metadata.getGcGraceSeconds());
    }

    public static void savePaxosCommit(Commit commit) {
        String cql = "UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET proposal_ballot = null, proposal = null, most_recent_commit_at = ?, most_recent_commit = ? WHERE row_key = ? AND cf_id = ?";
        QueryProcessor.executeInternal(String.format(cql, PAXOS_CF), UUIDGen.microsTimestamp(commit.ballot), SystemKeyspace.paxosTtl(commit.update.metadata), commit.ballot, commit.update.toBytes(), commit.key, commit.update.id());
    }

    public static RestorableMeter getSSTableReadMeter(String keyspace, String table, int generation) {
        String cql = "SELECT * FROM system.%s WHERE keyspace_name=? and columnfamily_name=? and generation=?";
        UntypedResultSet results = QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_CF), keyspace, table, generation);
        if (results.isEmpty()) {
            return new RestorableMeter();
        }
        UntypedResultSet.Row row = results.one();
        double m15rate = row.getDouble("rate_15m");
        double m120rate = row.getDouble("rate_120m");
        return new RestorableMeter(m15rate, m120rate);
    }

    public static void persistSSTableReadMeter(String keyspace, String table, int generation, RestorableMeter meter) {
        String cql = "INSERT INTO system.%s (keyspace_name, columnfamily_name, generation, rate_15m, rate_120m) VALUES (?, ?, ?, ?, ?) USING TTL 864000";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_CF), keyspace, table, generation, meter.fifteenMinuteRate(), meter.twoHourRate());
    }

    public static void clearSSTableReadMeter(String keyspace, String table, int generation) {
        String cql = "DELETE FROM system.%s WHERE keyspace_name=? AND columnfamily_name=? and generation=?";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_CF), keyspace, table, generation);
    }

    public static void updateSizeEstimates(String keyspace, String table, Map<Range<Token>, Pair<Long, Long>> estimates) {
        long timestamp = FBUtilities.timestampMicros();
        CFMetaData estimatesTable = CFMetaData.SizeEstimatesCf;
        Mutation mutation = new Mutation("system", UTF8Type.instance.decompose(keyspace));
        mutation.deleteRange(SIZE_ESTIMATES_CF, estimatesTable.comparator.make(table).start(), estimatesTable.comparator.make(table).end(), timestamp - 1L);
        ColumnFamily cells = mutation.addOrGet(estimatesTable);
        for (Map.Entry<Range<Token>, Pair<Long, Long>> entry : estimates.entrySet()) {
            Range<Token> range = entry.getKey();
            Pair<Long, Long> values = entry.getValue();
            Composite prefix = estimatesTable.comparator.make(table, ((Token)range.left).toString(), ((Token)range.right).toString());
            CFRowAdder adder = new CFRowAdder(cells, prefix, timestamp);
            adder.add("partitions_count", values.left).add("mean_partition_size", values.right);
        }
        mutation.apply();
    }

    public static void clearSizeEstimates(String keyspace, String table) {
        String cql = String.format("DELETE FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system", SIZE_ESTIMATES_CF);
        QueryProcessor.executeInternal(cql, keyspace, table);
    }

    public static enum BootstrapState {
        NEEDS_BOOTSTRAP,
        COMPLETED,
        IN_PROGRESS;

    }
}

