/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamWriter;
import org.apache.cassandra.streaming.compress.CompressedStreamWriter;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Ref;

public class OutgoingFileMessage
extends StreamMessage {
    public static StreamMessage.Serializer<OutgoingFileMessage> serializer = new StreamMessage.Serializer<OutgoingFileMessage>(){

        @Override
        public OutgoingFileMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            throw new UnsupportedOperationException("Not allowed to call deserialize on an outgoing file");
        }

        @Override
        public void serialize(OutgoingFileMessage message, DataOutputStreamAndChannel out, int version, StreamSession session) throws IOException {
            FileMessageHeader.serializer.serialize(message.header, out, version);
            SSTableReader reader = message.sstable;
            StreamWriter writer = message.header.compressionInfo == null ? new StreamWriter(reader, message.header.sections, session) : new CompressedStreamWriter(reader, message.header.sections, message.header.compressionInfo, session);
            writer.write(out.getChannel());
            session.fileSent(message.header);
        }
    };
    public final FileMessageHeader header;
    public final SSTableReader sstable;
    public final Ref<SSTableReader> ref;

    public OutgoingFileMessage(SSTableReader sstable, Ref ref, int sequenceNumber, long estimatedKeys, List<Pair<Long, Long>> sections, long repairedAt) {
        super(StreamMessage.Type.FILE);
        this.sstable = sstable;
        this.ref = ref;
        CompressionInfo compressionInfo = null;
        if (sstable.compression) {
            CompressionMetadata meta = sstable.getCompressionMetadata();
            compressionInfo = new CompressionInfo(meta.getChunksForSections(sections), meta.parameters);
        }
        this.header = new FileMessageHeader(sstable.metadata.cfId, sequenceNumber, sstable.descriptor.version.toString(), estimatedKeys, sections, compressionInfo, repairedAt);
    }

    public String toString() {
        return "File (" + this.header + ", file: " + this.sstable.getFilename() + ")";
    }
}

