/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceByNamesReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceByNamesReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand cmd, DataOutputPlus out, int version) throws IOException {
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        out.writeBoolean(command.isDigestQuery());
        out.writeUTF(command.ksName);
        ByteBufferUtil.writeWithShortLength(command.key, out);
        out.writeUTF(command.cfName);
        out.writeLong(cmd.timestamp);
        CFMetaData metadata = Schema.instance.getCFMetaData(cmd.ksName, cmd.cfName);
        metadata.comparator.namesQueryFilterSerializer().serialize(command.filter, out, version);
    }

    @Override
    public ReadCommand deserialize(DataInput in, int version) throws IOException {
        boolean isDigest = in.readBoolean();
        String keyspaceName = in.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
        String cfName = in.readUTF();
        long timestamp = in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
        NamesQueryFilter filter = metadata.comparator.namesQueryFilterSerializer().deserialize(in, version);
        return new SliceByNamesReadCommand(keyspaceName, key, cfName, timestamp, filter).setIsDigestQuery(isDigest);
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        TypeSizes sizes = TypeSizes.NATIVE;
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        int size = sizes.sizeof(command.isDigestQuery());
        int keySize = command.key.remaining();
        CFMetaData metadata = Schema.instance.getCFMetaData(cmd.ksName, cmd.cfName);
        size += sizes.sizeof(command.ksName);
        size += sizes.sizeof((short)keySize) + keySize;
        size += sizes.sizeof(command.cfName);
        size += sizes.sizeof(cmd.timestamp);
        size = (int)((long)size + metadata.comparator.namesQueryFilterSerializer().serializedSize(command.filter, version));
        return size;
    }
}

