/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.NotificationEmitter;
import javax.management.openmbean.TabularData;

public interface StorageServiceMBean
extends NotificationEmitter {
    public List<String> getLiveNodes();

    public List<String> getUnreachableNodes();

    public List<String> getJoiningNodes();

    public List<String> getLeavingNodes();

    public List<String> getMovingNodes();

    public List<String> getTokens();

    public List<String> getTokens(String var1) throws UnknownHostException;

    public String getReleaseVersion();

    public String getSchemaVersion();

    public String[] getAllDataFileLocations();

    public String getCommitLogLocation();

    public String getSavedCachesLocation();

    public Map<List<String>, List<String>> getRangeToEndpointMap(String var1);

    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String var1);

    public List<String> describeRingJMX(String var1) throws IOException;

    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String var1);

    public Map<String, String> getTokenToEndpointMap();

    public String getLocalHostId();

    public Map<String, String> getHostIdMap();

    @Deprecated
    public double getLoad();

    public String getLoadString();

    public Map<String, String> getLoadMap();

    public int getCurrentGenerationNumber();

    public List<InetAddress> getNaturalEndpoints(String var1, String var2, String var3);

    public List<InetAddress> getNaturalEndpoints(String var1, ByteBuffer var2);

    public void takeSnapshot(String var1, String ... var2) throws IOException;

    public void takeColumnFamilySnapshot(String var1, String var2, String var3) throws IOException;

    public void clearSnapshot(String var1, String ... var2) throws IOException;

    public Map<String, TabularData> getSnapshotDetails();

    public long trueSnapshotsSize();

    public void forceKeyspaceCompaction(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public int forceKeyspaceCleanup(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public int scrub(boolean var1, boolean var2, String var3, String ... var4) throws IOException, ExecutionException, InterruptedException;

    public int upgradeSSTables(String var1, boolean var2, String ... var3) throws IOException, ExecutionException, InterruptedException;

    public void forceKeyspaceFlush(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public int forceRepairAsync(String var1, boolean var2, Collection<String> var3, Collection<String> var4, boolean var5, boolean var6, String ... var7) throws IOException;

    public int forceRepairAsync(String var1, int var2, Collection<String> var3, Collection<String> var4, boolean var5, boolean var6, String ... var7);

    public int forceRepairRangeAsync(String var1, String var2, String var3, boolean var4, Collection<String> var5, Collection<String> var6, boolean var7, String ... var8) throws IOException;

    public int forceRepairRangeAsync(String var1, String var2, String var3, int var4, Collection<String> var5, Collection<String> var6, boolean var7, String ... var8);

    public int forceRepairAsync(String var1, boolean var2, boolean var3, boolean var4, boolean var5, String ... var6);

    public int forceRepairRangeAsync(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6, String ... var7);

    public void forceTerminateAllRepairSessions();

    public void decommission() throws InterruptedException;

    public void move(String var1) throws IOException;

    public void removeNode(String var1);

    public String getRemovalStatus();

    public void forceRemoveCompletion();

    public void setLoggingLevel(String var1, String var2) throws Exception;

    public Map<String, String> getLoggingLevels();

    public String getOperationMode();

    public boolean isStarting();

    public String getDrainProgress();

    public void drain() throws IOException, InterruptedException, ExecutionException;

    public void truncate(String var1, String var2) throws TimeoutException, IOException;

    public Map<InetAddress, Float> getOwnership();

    public Map<InetAddress, Float> effectiveOwnership(String var1) throws IllegalStateException;

    public List<String> getKeyspaces();

    public void updateSnitch(String var1, Boolean var2, Integer var3, Integer var4, Double var5) throws ClassNotFoundException;

    public void stopGossiping();

    public void startGossiping();

    public boolean isGossipRunning();

    public void stopDaemon();

    public boolean isInitialized();

    public void stopRPCServer();

    public void startRPCServer();

    public boolean isRPCServerRunning();

    public void stopNativeTransport();

    public void startNativeTransport();

    public boolean isNativeTransportRunning();

    public void joinRing() throws IOException;

    public boolean isJoined();

    @Deprecated
    public int getExceptionCount();

    public void setStreamThroughputMbPerSec(int var1);

    public int getStreamThroughputMbPerSec();

    public int getCompactionThroughputMbPerSec();

    public void setCompactionThroughputMbPerSec(int var1);

    public boolean isIncrementalBackupsEnabled();

    public void setIncrementalBackupsEnabled(boolean var1);

    public void rebuild(String var1);

    public void bulkLoad(String var1);

    public String bulkLoadAsync(String var1);

    public void rescheduleFailedDeletions();

    public void loadNewSSTables(String var1, String var2);

    public List<String> sampleKeyRange();

    public void rebuildSecondaryIndex(String var1, String var2, String ... var3);

    public void resetLocalSchema() throws IOException;

    public void setTraceProbability(double var1);

    public double getTracingProbability();

    public void disableAutoCompaction(String var1, String ... var2) throws IOException;

    public void enableAutoCompaction(String var1, String ... var2) throws IOException;

    public void deliverHints(String var1) throws UnknownHostException;

    public String getClusterName();

    public String getPartitionerName();

    public int getTombstoneWarnThreshold();

    public void setTombstoneWarnThreshold(int var1);

    public int getTombstoneFailureThreshold();

    public void setTombstoneFailureThreshold(int var1);

    public void setHintedHandoffThrottleInKB(int var1);
}

