/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialWriter
extends OutputStream
implements WritableByteChannel {
    private static final Logger logger = LoggerFactory.getLogger(SequentialWriter.class);
    protected boolean isDirty = false;
    protected boolean syncNeeded = false;
    private final String filePath;
    protected byte[] buffer;
    private final int fd;
    private int directoryFD;
    private boolean directorySynced = false;
    protected long current = 0L;
    protected long bufferOffset;
    protected int validBufferBytes;
    protected final RandomAccessFile out;
    private boolean trickleFsync;
    private int trickleFsyncByteInterval;
    private int bytesSinceTrickleFsync = 0;
    public final DataOutputPlus stream;
    protected long lastFlushOffset;

    public SequentialWriter(File file, int bufferSize) {
        try {
            this.out = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.filePath = file.getAbsolutePath();
        this.buffer = new byte[bufferSize];
        this.trickleFsync = DatabaseDescriptor.getTrickleFsync();
        this.trickleFsyncByteInterval = DatabaseDescriptor.getTrickleFsyncIntervalInKb() * 1024;
        try {
            this.fd = CLibrary.getfd(this.out.getFD());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.directoryFD = CLibrary.tryOpenDirectory(file.getParent());
        this.stream = new DataOutputStreamAndChannel(this, this);
    }

    public static SequentialWriter open(File file) {
        return SequentialWriter.open(file, 65536);
    }

    public static SequentialWriter open(File file, int bufferSize) {
        return new SequentialWriter(file, bufferSize);
    }

    public static ChecksummedSequentialWriter open(File file, File crcPath) {
        return new ChecksummedSequentialWriter(file, 65536, crcPath);
    }

    public static CompressedSequentialWriter open(String dataFilePath, String offsetsPath, CompressionParameters parameters, MetadataCollector sstableMetadataCollector) {
        return new CompressedSequentialWriter(new File(dataFilePath), offsetsPath, parameters, sstableMetadataCollector);
    }

    @Override
    public void write(int value) throws ClosedChannelException {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.buffer[this.bufferCursor()] = (byte)value;
        ++this.validBufferBytes;
        ++this.current;
        this.isDirty = true;
        this.syncNeeded = true;
    }

    @Override
    public void write(byte[] buffer) throws ClosedChannelException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws ClosedChannelException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        while (length > 0) {
            int n = this.writeAtMost(data, offset, length);
            offset += n;
            length -= n;
            this.isDirty = true;
            this.syncNeeded = true;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int length;
        int n;
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        int offset = src.position();
        for (length = src.remaining(); length > 0; length -= n) {
            n = this.writeAtMost(src, offset, length);
            offset += n;
            this.isDirty = true;
            this.syncNeeded = true;
        }
        src.position(offset);
        return length;
    }

    private int writeAtMost(ByteBuffer data, int offset, int length) {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        int toCopy = Math.min(length, this.buffer.length - this.bufferCursor());
        ByteBufferUtil.arrayCopy(data, offset, this.buffer, this.bufferCursor(), toCopy);
        assert (this.current <= this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.validBufferBytes = Math.max(this.validBufferBytes, this.bufferCursor() + toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    private int writeAtMost(byte[] data, int offset, int length) {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        int toCopy = Math.min(length, this.buffer.length - this.bufferCursor());
        System.arraycopy(data, offset, this.buffer, this.bufferCursor(), toCopy);
        assert (this.current <= this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.validBufferBytes = Math.max(this.validBufferBytes, this.bufferCursor() + toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    public void sync() {
        this.syncInternal();
    }

    protected void syncDataOnlyInternal() {
        try {
            this.out.getFD().sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    protected void syncInternal() {
        if (this.syncNeeded) {
            this.flushInternal();
            this.syncDataOnlyInternal();
            if (!this.directorySynced) {
                CLibrary.trySync(this.directoryFD);
                this.directorySynced = true;
            }
            this.syncNeeded = false;
        }
    }

    @Override
    public void flush() {
        this.flushInternal();
    }

    protected void flushInternal() {
        if (this.isDirty) {
            this.flushData();
            if (this.trickleFsync) {
                this.bytesSinceTrickleFsync += this.validBufferBytes;
                if (this.bytesSinceTrickleFsync >= this.trickleFsyncByteInterval) {
                    this.syncDataOnlyInternal();
                    this.bytesSinceTrickleFsync = 0;
                }
            }
            this.resetBuffer();
            this.isDirty = false;
        }
    }

    protected void flushData() {
        try {
            this.out.write(this.buffer, 0, this.validBufferBytes);
            this.lastFlushOffset += (long)this.validBufferBytes;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    public long getFilePointer() {
        return this.current;
    }

    public long getOnDiskFilePointer() {
        return this.getFilePointer();
    }

    public long length() {
        try {
            return Math.max(Math.max(this.current, this.out.length()), this.bufferOffset + (long)this.validBufferBytes);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    public String getPath() {
        return this.filePath;
    }

    protected void reBuffer() {
        this.flushInternal();
        this.resetBuffer();
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current;
        this.validBufferBytes = 0;
    }

    private int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    public FileMark mark() {
        return new BufferedFileWriterMark(this.current);
    }

    public void resetAndTruncate(FileMark mark) {
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current;
        this.current = ((BufferedFileWriterMark)mark).pointer;
        if (previous - this.current <= (long)this.validBufferBytes) {
            this.validBufferBytes -= (int)(previous - this.current);
            return;
        }
        this.syncInternal();
        this.truncate(this.current);
        try {
            this.out.seek(this.current);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.resetBuffer();
    }

    public long getLastFlushOffset() {
        return this.lastFlushOffset;
    }

    public void truncate(long toSize) {
        try {
            this.out.getChannel().truncate(toSize);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public boolean isOpen() {
        return this.out.getChannel().isOpen();
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.syncInternal();
        this.buffer = null;
        this.cleanup(true);
    }

    public void abort() {
        this.cleanup(false);
    }

    private void cleanup(boolean throwExceptions) {
        if (this.directoryFD >= 0) {
            try {
                CLibrary.tryCloseFD(this.directoryFD);
            }
            catch (Throwable t) {
                this.handle(t, throwExceptions);
            }
            this.directoryFD = -1;
        }
        try {
            this.out.close();
        }
        catch (Throwable t) {
            this.handle(t, throwExceptions);
        }
    }

    private void handle(Throwable t, boolean throwExceptions) {
        if (throwExceptions) {
            throw new FSWriteError(t, this.getPath());
        }
        logger.warn("Suppressing exception thrown while aborting writer", t);
    }

    public void writeFullChecksum(Descriptor descriptor) {
    }

    protected static class BufferedFileWriterMark
    implements FileMark {
        final long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

