/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedSegmentedFile
extends SegmentedFile {
    public BufferedSegmentedFile(String path, long length) {
        super(path, length);
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = RandomAccessReader.open(new File(this.path));
        reader.seek(position);
        return reader;
    }

    @Override
    public void cleanup() {
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path, SSTableWriter.FinishType finishType) {
            long length = new File(path).length();
            return new BufferedSegmentedFile(path, length);
        }
    }
}

