/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.MigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeEstimatesRecorder
extends MigrationListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SizeEstimatesRecorder.class);
    public static final SizeEstimatesRecorder instance = new SizeEstimatesRecorder();

    private SizeEstimatesRecorder() {
        MigrationManager.instance.register(this);
    }

    @Override
    public void run() {
        logger.debug("Recording size estimates");
        Collection<Token> localTokens = StorageService.instance.getLocalTokens();
        Collection<Range<Token>> localRanges = StorageService.instance.getTokenMetadata().getPrimaryRangesFor(localTokens);
        for (Keyspace keyspace : Keyspace.nonSystem()) {
            for (ColumnFamilyStore table : keyspace.getColumnFamilyStores()) {
                this.recordSizeEstimates(table, localRanges);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSizeEstimates(ColumnFamilyStore table, Collection<Range<Token>> localRanges) {
        HashMap<Range<Token>, Pair<Long, Long>> estimates = new HashMap<Range<Token>, Pair<Long, Long>>(localRanges.size());
        for (Range<Token> range : localRanges) {
            long meanPartitionSize;
            long partitionsCount;
            List sstables = null;
            Refs refs = null;
            while (refs == null) {
                sstables = (List)table.viewFilter(range.toRowBounds()).apply((Object)table.getDataTracker().getView());
                refs = Refs.tryRef(sstables);
            }
            try {
                partitionsCount = this.estimatePartitionsCount(sstables, range);
                meanPartitionSize = this.estimateMeanPartitionSize(sstables);
            }
            finally {
                refs.release();
            }
            estimates.put(range, Pair.create(partitionsCount, meanPartitionSize));
        }
        SystemKeyspace.updateSizeEstimates(table.metadata.ksName, table.metadata.cfName, estimates);
    }

    private long estimatePartitionsCount(Collection<SSTableReader> sstables, Range<Token> range) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            count += sstable.estimatedKeysForRanges(Collections.singleton(range));
        }
        return count;
    }

    private long estimateMeanPartitionSize(Collection<SSTableReader> sstables) {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            long n = sstable.getEstimatedRowSize().count();
            sum += sstable.getEstimatedRowSize().mean() * n;
            count += n;
        }
        return count > 0L ? sum / count : 0L;
    }

    @Override
    public void onDropColumnFamily(String keyspace, String table) {
        SystemKeyspace.clearSizeEstimates(keyspace, table);
    }
}

