/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.BufferCounterUpdateCell;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.FBUtilities;

public class UpdateParameters {
    public final CFMetaData metadata;
    public final QueryOptions options;
    public final long timestamp;
    private final int ttl;
    public final int localDeletionTime;
    private final Map<ByteBuffer, CQL3Row> prefetchedLists;

    public UpdateParameters(CFMetaData metadata, QueryOptions options, long timestamp, int ttl, Map<ByteBuffer, CQL3Row> prefetchedLists) throws InvalidRequestException {
        this.metadata = metadata;
        this.options = options;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        this.prefetchedLists = prefetchedLists;
        if (timestamp == Long.MIN_VALUE) {
            throw new InvalidRequestException(String.format("Out of bound timestamp, must be in [%d, %d]", -9223372036854775807L, Long.MAX_VALUE));
        }
    }

    public Cell makeColumn(CellName name, ByteBuffer value) throws InvalidRequestException {
        QueryProcessor.validateCellName(name, this.metadata.comparator);
        return AbstractCell.create(name, value, this.timestamp, this.ttl, this.metadata);
    }

    public Cell makeCounter(CellName name, long delta) throws InvalidRequestException {
        QueryProcessor.validateCellName(name, this.metadata.comparator);
        return new BufferCounterUpdateCell(name, delta, FBUtilities.timestampMicros());
    }

    public Cell makeTombstone(CellName name) throws InvalidRequestException {
        QueryProcessor.validateCellName(name, this.metadata.comparator);
        return new BufferDeletedCell(name, this.localDeletionTime, this.timestamp);
    }

    public RangeTombstone makeRangeTombstone(ColumnSlice slice) throws InvalidRequestException {
        QueryProcessor.validateComposite(slice.start, this.metadata.comparator);
        QueryProcessor.validateComposite(slice.finish, this.metadata.comparator);
        return new RangeTombstone(slice.start, slice.finish, this.timestamp, this.localDeletionTime);
    }

    public RangeTombstone makeTombstoneForOverwrite(ColumnSlice slice) throws InvalidRequestException {
        QueryProcessor.validateComposite(slice.start, this.metadata.comparator);
        QueryProcessor.validateComposite(slice.finish, this.metadata.comparator);
        return new RangeTombstone(slice.start, slice.finish, this.timestamp - 1L, this.localDeletionTime);
    }

    public List<Cell> getPrefetchedList(ByteBuffer rowKey, ColumnIdentifier cql3ColumnName) {
        if (this.prefetchedLists == null) {
            return Collections.emptyList();
        }
        CQL3Row row = this.prefetchedLists.get(rowKey);
        return row == null ? Collections.emptyList() : row.getMultiCellColumn(cql3ColumnName);
    }
}

