/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.paxos.AbstractPaxosCallback;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareCallback
extends AbstractPaxosCallback<PrepareResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PrepareCallback.class);
    public boolean promised = true;
    public Commit mostRecentCommit;
    public Commit mostRecentInProgressCommit;
    public Commit mostRecentInProgressCommitWithUpdate;
    private final Map<InetAddress, Commit> commitsByReplica = new ConcurrentHashMap<InetAddress, Commit>();

    public PrepareCallback(ByteBuffer key, CFMetaData metadata, int targets, ConsistencyLevel consistency) {
        super(targets, consistency);
        this.mostRecentCommit = Commit.emptyCommit(key, metadata);
        this.mostRecentInProgressCommit = Commit.emptyCommit(key, metadata);
        this.mostRecentInProgressCommitWithUpdate = Commit.emptyCommit(key, metadata);
    }

    @Override
    public synchronized void response(MessageIn<PrepareResponse> message) {
        PrepareResponse response = (PrepareResponse)message.payload;
        logger.debug("Prepare response {} from {}", (Object)response, (Object)message.from);
        if (response.inProgressCommit.isAfter(this.mostRecentInProgressCommit)) {
            this.mostRecentInProgressCommit = response.inProgressCommit;
        }
        if (!response.promised) {
            this.promised = false;
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            return;
        }
        this.commitsByReplica.put(message.from, response.mostRecentCommit);
        if (response.mostRecentCommit.isAfter(this.mostRecentCommit)) {
            this.mostRecentCommit = response.mostRecentCommit;
        }
        if (response.inProgressCommit.isAfter(this.mostRecentInProgressCommitWithUpdate) && !response.inProgressCommit.update.isEmpty()) {
            this.mostRecentInProgressCommitWithUpdate = response.inProgressCommit;
        }
        this.latch.countDown();
    }

    public Iterable<InetAddress> replicasMissingMostRecentCommit(CFMetaData metadata, long now) {
        long paxosTtlMicros = SystemKeyspace.paxosTtl(metadata) * 1000 * 1000;
        if (UUIDGen.microsTimestamp(this.mostRecentCommit.ballot) + paxosTtlMicros < now) {
            return Collections.emptySet();
        }
        return Iterables.filter(this.commitsByReplica.keySet(), (Predicate)new Predicate<InetAddress>(){

            public boolean apply(InetAddress inetAddress) {
                return !((Commit)((PrepareCallback)PrepareCallback.this).commitsByReplica.get((Object)inetAddress)).ballot.equals(PrepareCallback.this.mostRecentCommit.ballot);
            }
        });
    }
}

