/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.LazyColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableScanner
implements ICompactionScanner {
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private final Iterator<AbstractBounds<RowPosition>> rangeIterator;
    private AbstractBounds<RowPosition> currentRange;
    private final DataRange dataRange;
    protected Iterator<OnDiskAtomIterator> iterator;

    SSTableScanner(SSTableReader sstable, DataRange dataRange, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = dataRange;
        ArrayList<Bounds<RowPosition>> boundsList = new ArrayList<Bounds<RowPosition>>(2);
        if (dataRange.isWrapAround() && !dataRange.stopKey().isMinimum(sstable.partitioner)) {
            boundsList.add(new Bounds<RowPosition>(sstable.partitioner.getMinimumToken().minKeyBound(), dataRange.stopKey(), sstable.partitioner));
            boundsList.add(new Bounds<Token.KeyBound>((Token.KeyBound)dataRange.startKey(), sstable.partitioner.getMinimumToken().maxKeyBound(), sstable.partitioner));
        } else {
            boundsList.add(new Bounds<RowPosition>(dataRange.startKey(), dataRange.stopKey(), sstable.partitioner));
        }
        this.rangeIterator = boundsList.iterator();
    }

    SSTableScanner(SSTableReader sstable, Collection<Range<Token>> tokenRanges, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = null;
        List normalized = Range.normalize(tokenRanges);
        ArrayList<Range<Token.KeyBound>> boundsList = new ArrayList<Range<Token.KeyBound>>(normalized.size());
        for (Range range : normalized) {
            boundsList.add(new Range<Token.KeyBound>(((Token)range.left).maxKeyBound(sstable.partitioner), ((Token)range.right).maxKeyBound(sstable.partitioner), sstable.partitioner));
        }
        this.rangeIterator = boundsList.iterator();
    }

    private void seekToCurrentRangeStart() {
        if (((RowPosition)this.currentRange.left).isMinimum(this.sstable.partitioner)) {
            return;
        }
        long indexPosition = this.sstable.getIndexScanPosition((RowPosition)this.currentRange.left);
        if (indexPosition == -1L) {
            this.ifile.seek(0L);
            this.dfile.seek(0L);
            return;
        }
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                int comparison = indexDecoratedKey.compareTo((RowPosition)this.currentRange.left);
                if (comparison > 0 || this.currentRange.contains(indexDecoratedKey)) {
                    long dataPosition = this.ifile.readLong();
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.Serializer.skip(this.ifile);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<OnDiskAtomIterator> createIterator() {
        return new KeyScanningIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    protected class KeyScanningIterator
    extends AbstractIterator<OnDiskAtomIterator> {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;
        private DecoratedKey currentKey;
        private RowIndexEntry currentEntry;

        protected KeyScanningIterator() {
        }

        protected OnDiskAtomIterator computeNext() {
            try {
                long readEnd;
                if (this.nextEntry == null) {
                    do {
                        if (!SSTableScanner.this.rangeIterator.hasNext()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        SSTableScanner.this.currentRange = (AbstractBounds)SSTableScanner.this.rangeIterator.next();
                        SSTableScanner.this.seekToCurrentRangeStart();
                        if (SSTableScanner.this.ifile.isEOF()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        this.currentKey = SSTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                        this.currentEntry = SSTableScanner.this.sstable.metadata.comparator.rowIndexEntrySerializer().deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                    } while (!SSTableScanner.this.currentRange.contains(this.currentKey));
                } else {
                    this.currentKey = this.nextKey;
                    this.currentEntry = this.nextEntry;
                }
                if (SSTableScanner.this.ifile.isEOF()) {
                    this.nextEntry = null;
                    this.nextKey = null;
                    readEnd = SSTableScanner.this.dfile.length();
                } else {
                    this.nextKey = SSTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                    this.nextEntry = SSTableScanner.this.sstable.metadata.comparator.rowIndexEntrySerializer().deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                    readEnd = this.nextEntry.position;
                    if (!SSTableScanner.this.currentRange.contains(this.nextKey)) {
                        this.nextKey = null;
                        this.nextEntry = null;
                    }
                }
                if (SSTableScanner.this.dataRange == null || SSTableScanner.this.dataRange.selectsFullRowFor(this.currentKey.getKey())) {
                    SSTableScanner.this.dfile.seek(this.currentEntry.position);
                    ByteBufferUtil.readWithShortLength(SSTableScanner.this.dfile);
                    long dataSize = readEnd - SSTableScanner.this.dfile.getFilePointer();
                    return new SSTableIdentityIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, this.currentKey, dataSize);
                }
                return new LazyColumnIterator(this.currentKey, new IColumnIteratorFactory(){

                    @Override
                    public OnDiskAtomIterator create() {
                        return SSTableScanner.this.dataRange.columnFilter(KeyScanningIterator.this.currentKey.getKey()).getSSTableColumnIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, KeyScanningIterator.this.currentKey, KeyScanningIterator.this.currentEntry);
                    }
                });
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException((Exception)e, SSTableScanner.this.sstable.getFilename());
            }
        }
    }
}

