/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class SSTableRewriter {
    private static long preemptiveOpenInterval;
    private final DataTracker dataTracker;
    private final ColumnFamilyStore cfs;
    private final long maxAge;
    private final Set<SSTableReader> rewriting;
    private final Map<Descriptor, DecoratedKey> originalStarts = new HashMap<Descriptor, DecoratedKey>();
    private final Map<Descriptor, Integer> fileDescriptors = new HashMap<Descriptor, Integer>();
    private SSTableReader currentlyOpenedEarly;
    private long currentlyOpenedEarlyAt;
    private final List<SSTableReader> finishedOpenedEarly = new ArrayList<SSTableReader>();
    private final List<Pair<SSTableWriter, SSTableReader>> finishedWriters = new ArrayList<Pair<SSTableWriter, SSTableReader>>();
    private final boolean isOffline;
    private SSTableWriter writer;
    private Map<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();

    @VisibleForTesting
    static void overrideOpenInterval(long size) {
        preemptiveOpenInterval = size;
    }

    public SSTableRewriter(ColumnFamilyStore cfs, Set<SSTableReader> rewriting, long maxAge, boolean isOffline) {
        this.rewriting = rewriting;
        for (SSTableReader sstable : rewriting) {
            this.originalStarts.put(sstable.descriptor, sstable.first);
            this.fileDescriptors.put(sstable.descriptor, CLibrary.getfd(sstable.getFilename()));
        }
        this.dataTracker = cfs.getDataTracker();
        this.cfs = cfs;
        this.maxAge = maxAge;
        this.isOffline = isOffline;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        this.maybeReopenEarly(row.key);
        RowIndexEntry index = this.writer.append(row);
        if (!this.isOffline) {
            if (index == null) {
                this.cfs.invalidateCachedRow(row.key);
            } else {
                boolean save = false;
                for (SSTableReader reader : this.rewriting) {
                    if (reader.getCachedPosition(row.key, false) == null) continue;
                    save = true;
                    break;
                }
                if (save) {
                    this.cachedKeys.put(row.key, index);
                }
            }
        }
        return index;
    }

    public RowIndexEntry tryAppend(AbstractCompactedRow row) {
        this.writer.mark();
        try {
            return this.append(row);
        }
        catch (Throwable t) {
            this.writer.resetAndTruncate();
            throw t;
        }
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (FBUtilities.isUnix() && this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > preemptiveOpenInterval) {
            if (this.isOffline) {
                for (SSTableReader reader : this.rewriting) {
                    RowIndexEntry index = reader.getPosition(key, SSTableReader.Operator.GE);
                    CLibrary.trySkipCache((int)this.fileDescriptors.get(reader.descriptor), 0L, index == null ? 0L : index.position);
                }
            } else {
                SSTableReader reader = this.writer.openEarly(this.maxAge);
                if (reader != null) {
                    this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
                    this.currentlyOpenedEarly = reader;
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
                }
            }
        }
    }

    public void abort() {
        if (this.writer == null) {
            return;
        }
        this.switchWriter(null);
        this.moveStarts(null, (Function<? super Descriptor, DecoratedKey>)Functions.forMap(this.originalStarts), true);
        ArrayList close = Lists.newArrayList(this.finishedOpenedEarly);
        if (this.currentlyOpenedEarly != null) {
            close.add(this.currentlyOpenedEarly);
        }
        for (Pair<SSTableWriter, SSTableReader> w : this.finishedWriters) {
            ((SSTableWriter)w.left).abort(w.right == null);
        }
        for (SSTableReader sstable : close) {
            sstable.markObsolete();
        }
        if (!this.isOffline) {
            this.dataTracker.replaceEarlyOpenedFiles(close, Collections.emptyList());
            this.dataTracker.unmarkCompacting(close);
        }
    }

    private void moveStarts(SSTableReader newReader, Function<? super Descriptor, DecoratedKey> newStarts, boolean reset) {
        if (this.isOffline) {
            return;
        }
        ArrayList<SSTableReader> toReplace = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> replaceWith = new ArrayList<SSTableReader>();
        final ArrayList<DecoratedKey> invalidateKeys = new ArrayList<DecoratedKey>();
        if (!reset) {
            invalidateKeys.addAll(this.cachedKeys.keySet());
            for (Map.Entry entry : this.cachedKeys.entrySet()) {
                newReader.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        this.cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        for (final SSTableReader sSTableReader : this.rewriting) {
            DecoratedKey newStart = (DecoratedKey)newStarts.apply((Object)sSTableReader.descriptor);
            assert (newStart != null);
            if (sSTableReader.first.compareTo(newStart) >= 0 && (!reset || newStart == sSTableReader.first)) continue;
            toReplace.add(sSTableReader);
            replaceWith.add(sSTableReader.getCurrentReplacement().cloneWithNewStart(newStart, new Runnable(){

                @Override
                public void run() {
                    for (DecoratedKey key : invalidateKeys) {
                        sSTableReader.invalidateCacheKey(key);
                    }
                }
            }));
        }
        this.cfs.getDataTracker().replaceWithNewInstances(toReplace, replaceWith);
        this.rewriting.removeAll(toReplace);
        this.rewriting.addAll(replaceWith);
    }

    private void replaceEarlyOpenedFile(SSTableReader toReplace, SSTableReader replaceWith) {
        Set<SSTableReader> toReplaceSet;
        if (this.isOffline) {
            return;
        }
        if (toReplace != null) {
            toReplace.setReplacedBy(replaceWith);
            toReplaceSet = Collections.singleton(toReplace);
        } else {
            this.dataTracker.markCompacting(Collections.singleton(replaceWith));
            toReplaceSet = Collections.emptySet();
        }
        this.dataTracker.replaceEarlyOpenedFiles(toReplaceSet, Collections.singleton(replaceWith));
    }

    public void switchWriter(SSTableWriter newWriter) {
        if (this.writer == null) {
            this.writer = newWriter;
            return;
        }
        SSTableReader reader = this.writer.openEarly(this.maxAge);
        if (reader != null) {
            this.finishedOpenedEarly.add(reader);
            this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
            this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
        }
        this.finishedWriters.add(Pair.create(this.writer, reader));
        this.currentlyOpenedEarly = null;
        this.currentlyOpenedEarlyAt = 0L;
        this.writer = newWriter;
    }

    public List<SSTableReader> finish() {
        return this.finish(-1L);
    }

    public List<SSTableReader> finish(long repairedAt) {
        ArrayList<SSTableReader> finished = new ArrayList<SSTableReader>();
        if (this.writer.getFilePointer() > 0L) {
            SSTableReader reader = repairedAt < 0L ? this.writer.closeAndOpenReader(this.maxAge) : this.writer.closeAndOpenReader(this.maxAge, repairedAt);
            finished.add(reader);
            this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
            this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
        } else {
            this.writer.abort(true);
        }
        for (Pair<SSTableWriter, SSTableReader> w : this.finishedWriters) {
            if (((SSTableWriter)w.left).getFilePointer() > 0L) {
                SSTableReader newReader = repairedAt < 0L ? ((SSTableWriter)w.left).closeAndOpenReader(this.maxAge) : ((SSTableWriter)w.left).closeAndOpenReader(this.maxAge, repairedAt);
                finished.add(newReader);
                this.replaceEarlyOpenedFile((SSTableReader)w.right, newReader);
                continue;
            }
            assert (w.right == null);
            ((SSTableWriter)w.left).abort(true);
        }
        if (!this.isOffline) {
            this.dataTracker.unmarkCompacting(finished);
        }
        return finished;
    }

    static {
        long interval = (long)DatabaseDescriptor.getSSTablePreempiveOpenIntervalInMB() * 0x100000L;
        if (interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        preemptiveOpenInterval = interval;
    }
}

