/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.pig.AbstractCassandraStorage;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlStorage
extends AbstractCassandraStorage {
    private static final Logger logger = LoggerFactory.getLogger(CqlStorage.class);
    private RecordReader<Map<String, ByteBuffer>, Map<String, ByteBuffer>> reader;
    protected RecordWriter<Map<String, ByteBuffer>, List<ByteBuffer>> writer;
    protected int pageSize = 1000;
    protected String columns;
    protected String outputQuery;
    protected String whereClause;
    private boolean hasCompactValueAlias = false;

    public CqlStorage() {
        this(1000);
    }

    public CqlStorage(int pageSize) {
        this.pageSize = pageSize;
        this.DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlPagingInputFormat";
        this.DEFAULT_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlOutputFormat";
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            AbstractCassandraStorage.CfInfo cfInfo = this.getCfInfo(this.loadSignature);
            CfDef cfDef = cfInfo.cfDef;
            Map keys = (Map)this.reader.getCurrentKey();
            Map columns = (Map)this.reader.getCurrentValue();
            assert (keys != null && columns != null);
            for (Map.Entry key : keys.entrySet()) {
                columns.put(key.getKey(), key.getValue());
            }
            Tuple tuple = TupleFactory.getInstance().newTuple(cfDef.column_metadata.size());
            Iterator itera = cfDef.column_metadata.iterator();
            int i = 0;
            while (itera.hasNext()) {
                ColumnDef cdef = (ColumnDef)itera.next();
                ByteBuffer columnValue = (ByteBuffer)columns.get(ByteBufferUtil.string(cdef.name.duplicate()));
                if (columnValue != null) {
                    BufferCell cell = new BufferCell(CellNames.simpleDense(cdef.name), columnValue);
                    AbstractType validator = this.getValidatorMap(cfDef).get(cdef.name);
                    this.setTupleValue(tuple, i, this.cqlColumnToObj(cell, cfDef), validator);
                } else {
                    tuple.set(i, null);
                }
                ++i;
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void setTupleValue(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        if (validator instanceof CollectionType) {
            this.setCollectionTupleValues(tuple, position, value, validator);
        } else {
            this.setTupleValue(tuple, position, value);
        }
    }

    private void setCollectionTupleValues(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        AbstractType elementValidator;
        if (validator instanceof MapType) {
            this.setMapTupleValues(tuple, position, value, validator);
            return;
        }
        if (validator instanceof SetType) {
            elementValidator = ((SetType)validator).elements;
        } else if (validator instanceof ListType) {
            elementValidator = ((ListType)validator).elements;
        } else {
            return;
        }
        int i = 0;
        Tuple innerTuple = TupleFactory.getInstance().newTuple(((Collection)value).size());
        for (Object entry : (Collection)value) {
            this.setTupleValue(innerTuple, i, this.cassandraToPigData(entry, elementValidator), elementValidator);
            ++i;
        }
        tuple.set(position, (Object)innerTuple);
    }

    private void setMapTupleValues(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        AbstractType keyValidator = ((MapType)validator).keys;
        AbstractType valueValidator = ((MapType)validator).values;
        int i = 0;
        Tuple innerTuple = TupleFactory.getInstance().newTuple(((Map)value).size());
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Tuple mapEntryTuple = TupleFactory.getInstance().newTuple(2);
            this.setTupleValue(mapEntryTuple, 0, this.cassandraToPigData(entry.getKey(), keyValidator), keyValidator);
            this.setTupleValue(mapEntryTuple, 1, this.cassandraToPigData(entry.getValue(), valueValidator), valueValidator);
            innerTuple.set(i, (Object)mapEntryTuple);
            ++i;
        }
        tuple.set(position, (Object)innerTuple);
    }

    protected Object cqlColumnToObj(Cell col, CfDef cfDef) throws IOException {
        ByteBuffer cellName;
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        if (validators.get(cellName = col.name().toByteBuffer()) == null) {
            return this.cassandraToObj(this.getDefaultMarshallers(cfDef).get((Object)AbstractCassandraStorage.MarshallerType.DEFAULT_VALIDATOR), col.value());
        }
        return this.cassandraToObj(validators.get(cellName), col.value());
    }

    public void setLocation(String location, Job job) throws IOException {
        String wc;
        this.conf = HadoopCompat.getConfiguration((JobContext)job);
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        CqlConfigHelper.setInputCQLPageRowSize(this.conf, String.valueOf(this.pageSize));
        if (this.columns != null && !this.columns.trim().isEmpty()) {
            CqlConfigHelper.setInputColumns(this.conf, this.columns);
        }
        String whereClauseForPartitionFilter = this.getWhereClauseForPartitionFilter();
        String string = this.whereClause != null && !this.whereClause.trim().isEmpty() ? (whereClauseForPartitionFilter == null ? this.whereClause : String.format("%s AND %s", this.whereClause.trim(), whereClauseForPartitionFilter)) : (wc = whereClauseForPartitionFilter);
        if (wc != null) {
            logger.debug("where clause: {}", (Object)wc);
            CqlConfigHelper.setInputWhereClauses(this.conf, wc);
        }
        if (System.getenv("PIG_INPUT_SPLIT_SIZE") != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.parseInt(System.getenv("PIG_INPUT_SPLIT_SIZE")));
            }
            catch (NumberFormatException e) {
                throw new IOException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (ConfigHelper.getInputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_INPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.conf = HadoopCompat.getConfiguration((JobContext)job);
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setOutputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setOutputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setOutputRpcPort(this.conf, this.rpcPort);
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setOutputInitialAddress(this.conf, this.initHostAddress);
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        ConfigHelper.setOutputColumnFamily(this.conf, this.keyspace, this.column_family);
        CqlConfigHelper.setOutputCql(this.conf, this.outputQuery);
        this.setConnectionInformation();
        if (ConfigHelper.getOutputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_OUTPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getOutputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getOutputPartitioner(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        this.initSchema(this.storeSignature);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.setLocation(location, job);
        AbstractCassandraStorage.CfInfo cfInfo = this.getCfInfo(this.loadSignature);
        CfDef cfDef = cfInfo.cfDef;
        ResourceSchema schema = new ResourceSchema();
        Map<AbstractCassandraStorage.MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        ArrayList<ResourceSchema.ResourceFieldSchema> allSchemaFields = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (ColumnDef cdef : cfDef.column_metadata) {
            ResourceSchema.ResourceFieldSchema valSchema = new ResourceSchema.ResourceFieldSchema();
            AbstractType validator = validators.get(cdef.name);
            if (validator == null) {
                validator = marshallers.get((Object)AbstractCassandraStorage.MarshallerType.DEFAULT_VALIDATOR);
            }
            valSchema.setName(new String(cdef.getName()));
            valSchema.setType(this.getPigType(validator));
            allSchemaFields.add(valSchema);
        }
        schema.setFields(allSchemaFields.toArray(new ResourceSchema.ResourceFieldSchema[allSchemaFields.size()]));
        return schema;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(AbstractCassandraStorage.class);
        property.setProperty("cassandra.partition.filter", this.partitionFilterToWhereClauseString(partitionFilter));
    }

    private String getWhereClauseForPartitionFilter() {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(AbstractCassandraStorage.class);
        return property.getProperty("cassandra.partition.filter");
    }

    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    public void putNext(Tuple t) throws IOException {
        if (t.size() < 1) {
            logger.warn("Empty output skipped, filter empty tuples to suppress this warning");
            return;
        }
        if (t.getType(0) == 110) {
            if (t.getType(1) != 110) {
                throw new IOException("Second argument in output must be a tuple");
            }
        } else {
            throw new IOException("First argument in output must be a tuple");
        }
        Map<String, ByteBuffer> key = this.tupleToKeyMap((Tuple)t.get(0));
        this.cqlQueryFromTuple(key, t, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, ByteBuffer> tupleToKeyMap(Tuple t) throws IOException {
        HashMap<String, ByteBuffer> keys = new HashMap<String, ByteBuffer>();
        for (int i = 0; i < t.size(); ++i) {
            if (t.getType(i) != 110) throw new IOException("keys was not a tuple");
            Tuple inner = (Tuple)t.get(i);
            if (inner.size() != 2) throw new IOException("Keys were not in name and value pairs");
            Object name = inner.get(0);
            if (name == null) {
                throw new IOException("Key name was empty");
            }
            keys.put(name.toString(), this.objToBB(inner.get(1)));
        }
        return keys;
    }

    private void cqlQueryFromTuple(Map<String, ByteBuffer> key, Tuple t, int offset) throws IOException {
        for (int i = offset; i < t.size(); ++i) {
            if (t.getType(i) == 110) {
                Tuple inner = (Tuple)t.get(i);
                if (inner.size() <= 0) continue;
                List<ByteBuffer> bindedVariables = this.bindedVariablesFromTuple(inner);
                if (bindedVariables.size() > 0) {
                    this.sendCqlQuery(key, bindedVariables);
                    continue;
                }
                throw new IOException("Missing binded variables");
            }
            throw new IOException("Output type was not a tuple");
        }
    }

    private List<ByteBuffer> bindedVariablesFromTuple(Tuple t) throws IOException {
        ArrayList<ByteBuffer> variables = new ArrayList<ByteBuffer>();
        for (int i = 0; i < t.size(); ++i) {
            variables.add(this.objToBB(t.get(i)));
        }
        return variables;
    }

    private void sendCqlQuery(Map<String, ByteBuffer> key, List<ByteBuffer> bindedVariables) throws IOException {
        try {
            this.writer.write(key, bindedVariables);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected List<ColumnDef> getColumnMetadata(Cassandra.Client client) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException, CharacterCodingException, org.apache.cassandra.exceptions.InvalidRequestException, ConfigurationException, NotFoundException {
        List<ColumnDef> keyColumns = null;
        try {
            keyColumns = this.getKeysMeta(client);
        }
        catch (Exception e) {
            logger.error("Error in retrieving key columns", (Throwable)e);
        }
        List<ColumnDef> columns = this.getColumnMeta(client, false, !this.hasCompactValueAlias);
        if (keyColumns != null && columns != null) {
            keyColumns.addAll(columns);
        }
        return keyColumns;
    }

    protected List<ColumnDef> getKeysMeta(Cassandra.Client client) throws Exception {
        String query = "SELECT key_aliases,        column_aliases,        key_validator,        comparator,        keyspace_name,        value_alias,        default_validator FROM system.schema_columnfamilies WHERE keyspace_name = '%s'  AND columnfamily_name = '%s' ";
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(String.format(query, this.keyspace, this.column_family)), Compression.NONE, ConsistencyLevel.ONE);
        if (result == null || result.rows == null || result.rows.isEmpty()) {
            return null;
        }
        Iterator iteraRow = result.rows.iterator();
        ArrayList<ColumnDef> keys = new ArrayList<ColumnDef>();
        if (iteraRow.hasNext()) {
            ColumnDef cDef;
            CqlRow cqlRow = (CqlRow)iteraRow.next();
            String name = ByteBufferUtil.string(((Column)cqlRow.columns.get((int)4)).value);
            logger.debug("Found ksDef name: {}", (Object)name);
            String keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(0)).getValue()));
            logger.debug("partition keys: {}", (Object)keyString);
            List<String> keyNames = FBUtilities.fromJsonList(keyString);
            Iterator<String> iterator = keyNames.iterator();
            while (iterator.hasNext()) {
                cDef = new ColumnDef();
                cDef.name = ByteBufferUtil.bytes(iterator.next());
                keys.add(cDef);
            }
            if (keys.size() == 0) {
                ColumnDef cDef2;
                String key;
                CFMetaData cfm = this.getCFMetaData(this.keyspace, this.column_family, client);
                for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                    key = def.name.toString();
                    logger.debug("name: {} ", (Object)key);
                    cDef2 = new ColumnDef();
                    cDef2.name = ByteBufferUtil.bytes(key);
                    keys.add(cDef2);
                }
                for (ColumnDefinition def : cfm.clusteringColumns()) {
                    key = def.name.toString();
                    logger.debug("name: {} ", (Object)key);
                    cDef2 = new ColumnDef();
                    cDef2.name = ByteBufferUtil.bytes(key);
                    keys.add(cDef2);
                }
            }
            keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(1)).getValue()));
            logger.debug("cluster keys: {}", (Object)keyString);
            keyNames = FBUtilities.fromJsonList(keyString);
            iterator = keyNames.iterator();
            while (iterator.hasNext()) {
                cDef = new ColumnDef();
                cDef.name = ByteBufferUtil.bytes(iterator.next());
                keys.add(cDef);
            }
            String validator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(2)).getValue()));
            logger.debug("row key validator: {}", (Object)validator);
            AbstractType keyValidator = this.parseType(validator);
            Iterator keyItera = keys.iterator();
            if (keyValidator instanceof CompositeType) {
                Iterator<AbstractType<?>> typeItera = ((CompositeType)keyValidator).types.iterator();
                while (typeItera.hasNext()) {
                    ((ColumnDef)keyItera.next()).validation_class = typeItera.next().toString();
                }
            } else {
                ((ColumnDef)keyItera.next()).validation_class = keyValidator.toString();
            }
            validator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(3)).getValue()));
            logger.debug("cluster key validator: {}", (Object)validator);
            if (keyItera.hasNext() && validator != null && !validator.isEmpty()) {
                AbstractType clusterKeyValidator = this.parseType(validator);
                if (clusterKeyValidator instanceof CompositeType) {
                    Iterator<AbstractType<?>> typeItera = ((CompositeType)clusterKeyValidator).types.iterator();
                    while (keyItera.hasNext()) {
                        ((ColumnDef)keyItera.next()).validation_class = typeItera.next().toString();
                    }
                } else {
                    ((ColumnDef)keyItera.next()).validation_class = clusterKeyValidator.toString();
                }
            }
            if (((Column)cqlRow.columns.get((int)5)).value != null) {
                try {
                    String compactValidator = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(6)).getValue()));
                    logger.debug("default validator: {}", (Object)compactValidator);
                    AbstractType defaultValidator = this.parseType(compactValidator);
                    ColumnDef cDef3 = new ColumnDef();
                    cDef3.name = ((Column)cqlRow.columns.get((int)5)).value;
                    cDef3.validation_class = defaultValidator.toString();
                    keys.add(cDef3);
                    this.hasCompactValueAlias = true;
                }
                catch (Exception e) {
                    JVMStabilityInspector.inspectThrowable(e);
                }
            }
        }
        return keys;
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cql://")) {
                throw new Exception("Bad scheme: " + location);
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CqlStorage.getQueryMap(urlParts[1]);
                if (urlQuery.containsKey("page_size")) {
                    this.pageSize = Integer.parseInt(urlQuery.get("page_size"));
                }
                if (urlQuery.containsKey("columns")) {
                    this.columns = urlQuery.get("columns");
                }
                if (urlQuery.containsKey("output_query")) {
                    this.outputQuery = urlQuery.get("output_query");
                }
                if (urlQuery.containsKey("where_clause")) {
                    this.whereClause = urlQuery.get("where_clause");
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
                if (urlQuery.containsKey("partitioner")) {
                    this.partitionerClass = urlQuery.get("partitioner");
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("init_address")) {
                    this.initHostAddress = urlQuery.get("init_address");
                }
                if (urlQuery.containsKey("rpc_port")) {
                    this.rpcPort = urlQuery.get("rpc_port");
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cql://[username:password@]<keyspace>/<columnfamily>[?[page_size=<size>][&columns=<col1,col2>][&output_query=<prepared_statement>][&where_clause=<clause>][&split_size=<size>][&partitioner=<partitioner>][&use_secondary=true|false][&init_address=<host>][&rpc_port=<port>]]': " + e.getMessage());
        }
    }

    private String partitionFilterToWhereClauseString(Expression expression) throws IOException {
        Expression.BinaryExpression be = (Expression.BinaryExpression)expression;
        Expression.OpType op = expression.getOpType();
        String opString = op.toString();
        switch (op) {
            case OP_EQ: {
                opString = " = ";
            }
            case OP_GE: 
            case OP_GT: 
            case OP_LE: 
            case OP_LT: {
                String name = be.getLhs().toString();
                String value = be.getRhs().toString();
                return String.format("%s %s %s", name, opString, value);
            }
            case OP_AND: {
                return String.format("%s AND %s", this.partitionFilterToWhereClauseString(be.getLhs()), this.partitionFilterToWhereClauseString(be.getRhs()));
            }
        }
        throw new IOException("Unsupported expression type: " + opString);
    }

    private Object cassandraToPigData(Object obj, AbstractType validator) {
        if (validator instanceof DecimalType || validator instanceof InetAddressType) {
            return validator.getString(validator.decompose(obj));
        }
        return obj;
    }

    @Override
    public ByteBuffer nullToBB() {
        return ByteBuffer.wrap(new byte[0]);
    }
}

