/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Map;
import org.apache.cassandra.exceptions.ConfigurationException;

public final class SizeTieredCompactionStrategyOptions {
    protected static final long DEFAULT_MIN_SSTABLE_SIZE = 0x3200000L;
    protected static final double DEFAULT_BUCKET_LOW = 0.5;
    protected static final double DEFAULT_BUCKET_HIGH = 1.5;
    protected static final double DEFAULT_COLD_READS_TO_OMIT = 0.05;
    protected static final String MIN_SSTABLE_SIZE_KEY = "min_sstable_size";
    protected static final String BUCKET_LOW_KEY = "bucket_low";
    protected static final String BUCKET_HIGH_KEY = "bucket_high";
    protected static final String COLD_READS_TO_OMIT_KEY = "cold_reads_to_omit";
    protected long minSSTableSize;
    protected double bucketLow;
    protected double bucketHigh;
    protected double coldReadsToOmit;

    public SizeTieredCompactionStrategyOptions(Map<String, String> options) {
        String optionValue = options.get(MIN_SSTABLE_SIZE_KEY);
        this.minSSTableSize = optionValue == null ? 0x3200000L : Long.parseLong(optionValue);
        optionValue = options.get(BUCKET_LOW_KEY);
        this.bucketLow = optionValue == null ? 0.5 : Double.parseDouble(optionValue);
        optionValue = options.get(BUCKET_HIGH_KEY);
        this.bucketHigh = optionValue == null ? 1.5 : Double.parseDouble(optionValue);
        optionValue = options.get(COLD_READS_TO_OMIT_KEY);
        this.coldReadsToOmit = optionValue == null ? 0.05 : Double.parseDouble(optionValue);
    }

    public SizeTieredCompactionStrategyOptions() {
        this.minSSTableSize = 0x3200000L;
        this.bucketLow = 0.5;
        this.bucketHigh = 1.5;
        this.coldReadsToOmit = 0.05;
    }

    private static double parseDouble(Map<String, String> options, String key, double defaultValue) throws ConfigurationException {
        String optionValue = options.get(key);
        try {
            return optionValue == null ? defaultValue : Double.parseDouble(optionValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable float for %s", optionValue, key), e);
        }
    }

    public static Map<String, String> validateOptions(Map<String, String> options, Map<String, String> uncheckedOptions) throws ConfigurationException {
        String optionValue = options.get(MIN_SSTABLE_SIZE_KEY);
        try {
            long minSSTableSize;
            long l = minSSTableSize = optionValue == null ? 0x3200000L : Long.parseLong(optionValue);
            if (minSSTableSize < 0L) {
                throw new ConfigurationException(String.format("%s must be non negative: %d", MIN_SSTABLE_SIZE_KEY, minSSTableSize));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, MIN_SSTABLE_SIZE_KEY), e);
        }
        double bucketLow = SizeTieredCompactionStrategyOptions.parseDouble(options, BUCKET_LOW_KEY, 0.5);
        double bucketHigh = SizeTieredCompactionStrategyOptions.parseDouble(options, BUCKET_HIGH_KEY, 1.5);
        if (bucketHigh <= bucketLow) {
            throw new ConfigurationException(String.format("%s value (%s) is less than or equal to the %s value (%s)", BUCKET_HIGH_KEY, bucketHigh, BUCKET_LOW_KEY, bucketLow));
        }
        double maxColdReadsRatio = SizeTieredCompactionStrategyOptions.parseDouble(options, COLD_READS_TO_OMIT_KEY, 0.05);
        if (maxColdReadsRatio < 0.0 || maxColdReadsRatio > 1.0) {
            throw new ConfigurationException(String.format("%s value (%s) should be between between 0.0 and 1.0", COLD_READS_TO_OMIT_KEY, optionValue));
        }
        uncheckedOptions.remove(MIN_SSTABLE_SIZE_KEY);
        uncheckedOptions.remove(BUCKET_LOW_KEY);
        uncheckedOptions.remove(BUCKET_HIGH_KEY);
        uncheckedOptions.remove(COLD_READS_TO_OMIT_KEY);
        return uncheckedOptions;
    }
}

