/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.io.sstable.IndexSummaryManagerMBean;
import org.apache.cassandra.io.sstable.IndexSummaryRedistribution;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryManager
implements IndexSummaryManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryManager.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=IndexSummaries";
    public static final IndexSummaryManager instance = new IndexSummaryManager();
    private int resizeIntervalInMinutes = 0;
    private long memoryPoolBytes;
    static final double UPSAMPLE_THRESHOLD = 1.5;
    static final double DOWNSAMPLE_THESHOLD = 0.75;
    private final DebuggableScheduledThreadPoolExecutor executor = new DebuggableScheduledThreadPoolExecutor(1, "IndexSummaryManager", 1);
    private ScheduledFuture future;

    private IndexSummaryManager() {
        long indexSummarySizeInMB = DatabaseDescriptor.getIndexSummaryCapacityInMB();
        int interval = DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes();
        logger.info("Initializing index summary manager with a memory pool size of {} MB and a resize interval of {} minutes", (Object)indexSummarySizeInMB, (Object)interval);
        this.setMemoryPoolCapacityInMB(DatabaseDescriptor.getIndexSummaryCapacityInMB());
        this.setResizeIntervalInMinutes(DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes());
    }

    @Override
    public int getResizeIntervalInMinutes() {
        return this.resizeIntervalInMinutes;
    }

    @Override
    public void setResizeIntervalInMinutes(int resizeIntervalInMinutes) {
        long initialDelay;
        int oldInterval = this.resizeIntervalInMinutes;
        this.resizeIntervalInMinutes = resizeIntervalInMinutes;
        if (this.future != null) {
            initialDelay = oldInterval < 0 ? (long)resizeIntervalInMinutes : Math.max(0L, (long)resizeIntervalInMinutes - ((long)oldInterval - this.future.getDelay(TimeUnit.MINUTES)));
            this.future.cancel(false);
        } else {
            initialDelay = resizeIntervalInMinutes;
        }
        if (this.resizeIntervalInMinutes < 0) {
            this.future = null;
            return;
        }
        this.future = this.executor.scheduleWithFixedDelay(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                IndexSummaryManager.this.redistributeSummaries();
            }
        }, initialDelay, resizeIntervalInMinutes, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    Long getTimeToNextResize(TimeUnit timeUnit) {
        if (this.future == null) {
            return null;
        }
        return this.future.getDelay(timeUnit);
    }

    @Override
    public long getMemoryPoolCapacityInMB() {
        return this.memoryPoolBytes / 1024L / 1024L;
    }

    @Override
    public Map<String, Integer> getIndexIntervals() {
        List<SSTableReader> sstables = this.getAllSSTables();
        HashMap<String, Integer> intervals = new HashMap<String, Integer>(sstables.size());
        for (SSTableReader sstable : sstables) {
            intervals.put(sstable.getFilename(), (int)Math.round(sstable.getEffectiveIndexInterval()));
        }
        return intervals;
    }

    @Override
    public double getAverageIndexInterval() {
        List<SSTableReader> sstables = this.getAllSSTables();
        double total = 0.0;
        for (SSTableReader sstable : sstables) {
            total += sstable.getEffectiveIndexInterval();
        }
        return total / (double)sstables.size();
    }

    @Override
    public void setMemoryPoolCapacityInMB(long memoryPoolCapacityInMB) {
        this.memoryPoolBytes = memoryPoolCapacityInMB * 1024L * 1024L;
    }

    @Override
    public double getMemoryPoolSizeInMB() {
        long total = 0L;
        for (SSTableReader sstable : this.getAllSSTables()) {
            total += sstable.getIndexSummaryOffHeapSize();
        }
        return (double)total / 1024.0 / 1024.0;
    }

    private List<SSTableReader> getAllSSTables() {
        ArrayList<SSTableReader> result = new ArrayList<SSTableReader>();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                result.addAll(cfStore.getSSTables());
            }
        }
        return result;
    }

    private Pair<List<SSTableReader>, Multimap<DataTracker, SSTableReader>> getCompactingAndNonCompactingSSTables() {
        ArrayList allCompacting = new ArrayList();
        HashMultimap allNonCompacting = HashMultimap.create();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                Set<SSTableReader> allSSTables;
                HashSet nonCompacting;
                do {
                    allSSTables = cfStore.getDataTracker().getSSTables();
                } while (!(nonCompacting = Sets.newHashSet(cfStore.getDataTracker().getUncompactingSSTables(allSSTables))).isEmpty() && !cfStore.getDataTracker().markCompacting(nonCompacting));
                allNonCompacting.putAll((Object)cfStore.getDataTracker(), (Iterable)nonCompacting);
                allCompacting.addAll(Sets.difference(allSSTables, (Set)nonCompacting));
            }
        }
        return Pair.create(allCompacting, allNonCompacting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redistributeSummaries() throws IOException {
        Pair<List<SSTableReader>, Multimap<DataTracker, SSTableReader>> compactingAndNonCompacting = this.getCompactingAndNonCompactingSSTables();
        try {
            IndexSummaryManager.redistributeSummaries((List)compactingAndNonCompacting.left, Lists.newArrayList((Iterable)((Multimap)compactingAndNonCompacting.right).values()), this.memoryPoolBytes);
        }
        finally {
            for (DataTracker tracker : ((Multimap)compactingAndNonCompacting.right).keySet()) {
                tracker.unmarkCompacting(((Multimap)compactingAndNonCompacting.right).get((Object)tracker));
            }
        }
    }

    @VisibleForTesting
    public static List<SSTableReader> redistributeSummaries(List<SSTableReader> compacting, List<SSTableReader> nonCompacting, long memoryPoolBytes) throws IOException {
        return CompactionManager.instance.runIndexSummaryRedistribution(new IndexSummaryRedistribution(compacting, nonCompacting, memoryPoolBytes));
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

