/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UserType
extends TupleType {
    public final String keyspace;
    public final ByteBuffer name;
    private final List<ByteBuffer> fieldNames;

    public UserType(String keyspace, ByteBuffer name, List<ByteBuffer> fieldNames, List<AbstractType<?>> fieldTypes) {
        super(fieldTypes);
        assert (fieldNames.size() == fieldTypes.size());
        this.keyspace = keyspace;
        this.name = name;
        this.fieldNames = fieldNames;
    }

    public static UserType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        Pair<Pair<String, ByteBuffer>, List<Pair<ByteBuffer, AbstractType>>> params = parser.getUserTypeParameters();
        String keyspace = (String)((Pair)params.left).left;
        ByteBuffer name = (ByteBuffer)((Pair)params.left).right;
        ArrayList<ByteBuffer> columnNames = new ArrayList<ByteBuffer>(((List)params.right).size());
        ArrayList columnTypes = new ArrayList(((List)params.right).size());
        for (Pair p : (List)params.right) {
            columnNames.add((ByteBuffer)p.left);
            columnTypes.add(((AbstractType)p.right).freeze());
        }
        return new UserType(keyspace, name, columnNames, columnTypes);
    }

    public AbstractType<?> fieldType(int i) {
        return this.type(i);
    }

    public List<AbstractType<?>> fieldTypes() {
        return this.types;
    }

    public ByteBuffer fieldName(int i) {
        return this.fieldNames.get(i);
    }

    public List<ByteBuffer> fieldNames() {
        return this.fieldNames;
    }

    public String getNameAsString() {
        return (String)UTF8Type.instance.compose(this.name);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        ByteBuffer input = bytes.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return;
            }
            if (input.remaining() < 4) {
                throw new MarshalException(String.format("Not enough bytes to read size of %dth field %s", i, this.fieldName(i)));
            }
            int size = input.getInt();
            if (size < 0) continue;
            if (input.remaining() < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth field %s", i, this.fieldName(i)));
            }
            ByteBuffer field = ByteBufferUtil.readBytes(input, size);
            ((AbstractType)this.types.get(i)).validate(field);
        }
        if (input.hasRemaining()) {
            throw new MarshalException("Invalid remaining data after end of UDT value");
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace, this.name, this.fieldNames, this.types});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType that = (UserType)o;
        return this.keyspace.equals(that.keyspace) && this.name.equals(that.name) && this.fieldNames.equals(that.fieldNames) && this.types.equals(that.types);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.UserDefined.create(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyUserTypeParameters(this.keyspace, this.name, this.fieldNames, this.types);
    }
}

