/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.utils.PureJavaCrc32;

public class CommitLogDescriptor {
    private static final String SEPARATOR = "-";
    private static final String FILENAME_PREFIX = "CommitLog-";
    private static final String FILENAME_EXTENSION = ".log";
    private static final Pattern COMMIT_LOG_FILE_PATTERN = Pattern.compile("CommitLog-((\\d+)(-\\d+)?).log");
    public static final int VERSION_12 = 2;
    public static final int VERSION_20 = 3;
    public static final int VERSION_21 = 4;
    public static final int current_version = 4;
    static final int HEADER_SIZE = 16;
    final int version;
    public final long id;

    public CommitLogDescriptor(int version, long id) {
        this.version = version;
        this.id = id;
    }

    public CommitLogDescriptor(long id) {
        this(4, id);
    }

    static void writeHeader(ByteBuffer out, CommitLogDescriptor descriptor) {
        out.putInt(0, descriptor.version);
        out.putLong(4, descriptor.id);
        PureJavaCrc32 crc = new PureJavaCrc32();
        crc.updateInt(descriptor.version);
        crc.updateInt((int)(descriptor.id & 0xFFFFFFFFL));
        crc.updateInt((int)(descriptor.id >>> 32));
        out.putInt(12, crc.getCrc());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommitLogDescriptor fromHeader(File file) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            assert (raf.getFilePointer() == 0L);
            int version = raf.readInt();
            long id = raf.readLong();
            int crc = raf.readInt();
            PureJavaCrc32 checkcrc = new PureJavaCrc32();
            checkcrc.updateInt(version);
            checkcrc.updateInt((int)(id & 0xFFFFFFFFL));
            checkcrc.updateInt((int)(id >>> 32));
            if (crc == checkcrc.getCrc()) {
                CommitLogDescriptor commitLogDescriptor = new CommitLogDescriptor(version, id);
                return commitLogDescriptor;
            }
            CommitLogDescriptor commitLogDescriptor = null;
            return commitLogDescriptor;
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, file);
        }
    }

    public static CommitLogDescriptor fromFileName(String name) {
        Matcher matcher = COMMIT_LOG_FILE_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot parse the version of the file: " + name);
        }
        if (matcher.group(3) == null) {
            throw new UnsupportedOperationException("Commitlog segment is too old to open; upgrade to 1.2.5+ first");
        }
        long id = Long.parseLong(matcher.group(3).split(SEPARATOR)[1]);
        return new CommitLogDescriptor(Integer.parseInt(matcher.group(2)), id);
    }

    public int getMessagingVersion() {
        switch (this.version) {
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        throw new IllegalStateException("Unknown commitlog version " + this.version);
    }

    public String fileName() {
        return FILENAME_PREFIX + this.version + SEPARATOR + this.id + FILENAME_EXTENSION;
    }

    public static boolean isValid(String filename) {
        return COMMIT_LOG_FILE_PATTERN.matcher(filename).matches();
    }

    public String toString() {
        return "(" + this.version + "," + this.id + ")";
    }

    public boolean equals(Object that) {
        return that instanceof CommitLogDescriptor && this.equals((CommitLogDescriptor)that);
    }

    public boolean equals(CommitLogDescriptor that) {
        return this.version == that.version && this.id == that.id;
    }
}

