/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.metrics.ConnectionMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.FBUtilities;

public class OutboundTcpConnectionPool {
    private final InetAddress id;
    private final CountDownLatch started;
    public final OutboundTcpConnection cmdCon;
    public final OutboundTcpConnection ackCon;
    private InetAddress resetEndpoint;
    private ConnectionMetrics metrics;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.id = remoteEp;
        this.resetEndpoint = SystemKeyspace.getPreferredIP(remoteEp);
        this.started = new CountDownLatch(1);
        this.cmdCon = new OutboundTcpConnection(this);
        this.ackCon = new OutboundTcpConnection(this);
    }

    OutboundTcpConnection getConnection(MessageOut msg) {
        Stage stage = msg.getStage();
        return stage == Stage.REQUEST_RESPONSE || stage == Stage.INTERNAL_RESPONSE || stage == Stage.GOSSIP ? this.ackCon : this.cmdCon;
    }

    void reset() {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            conn.closeSocket(false);
        }
    }

    public void resetToNewerVersion(int version) {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            if (version <= conn.getTargetVersion()) continue;
            conn.softCloseSocket();
        }
    }

    public void reset(InetAddress remoteEP) {
        SystemKeyspace.updatePreferredIP(this.id, remoteEP);
        this.resetEndpoint = remoteEP;
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            conn.softCloseSocket();
        }
        this.metrics.release();
        this.metrics = new ConnectionMetrics(this.resetEndpoint, this);
    }

    public long getTimeouts() {
        return this.metrics.timeouts.count();
    }

    public long getRecentTimeouts() {
        return this.metrics.getRecentTimeout();
    }

    public void incrementTimeout() {
        this.metrics.timeouts.mark();
    }

    public Socket newSocket() throws IOException {
        return OutboundTcpConnectionPool.newSocket(this.endPoint());
    }

    public static Socket newSocket(InetAddress endpoint) throws IOException {
        if (OutboundTcpConnectionPool.isEncryptedChannel(endpoint)) {
            if (Config.getOutboundBindAny()) {
                return SSLFactory.getSocket(DatabaseDescriptor.getServerEncryptionOptions(), endpoint, DatabaseDescriptor.getSSLStoragePort());
            }
            return SSLFactory.getSocket(DatabaseDescriptor.getServerEncryptionOptions(), endpoint, DatabaseDescriptor.getSSLStoragePort(), FBUtilities.getLocalAddress(), 0);
        }
        SocketChannel channel = SocketChannel.open();
        if (!Config.getOutboundBindAny()) {
            channel.bind(new InetSocketAddress(FBUtilities.getLocalAddress(), 0));
        }
        channel.connect(new InetSocketAddress(endpoint, DatabaseDescriptor.getStoragePort()));
        return channel.socket();
    }

    public InetAddress endPoint() {
        if (this.id.equals(FBUtilities.getBroadcastAddress())) {
            return FBUtilities.getLocalAddress();
        }
        return this.resetEndpoint;
    }

    public static boolean isEncryptedChannel(InetAddress address) {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        switch (DatabaseDescriptor.getServerEncryptionOptions().internode_encryption) {
            case none: {
                return false;
            }
            case all: {
                break;
            }
            case dc: {
                if (!snitch.getDatacenter(address).equals(snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
            case rack: {
                if (!snitch.getRack(address).equals(snitch.getRack(FBUtilities.getBroadcastAddress())) || !snitch.getDatacenter(address).equals(snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
        }
        return true;
    }

    public void start() {
        this.cmdCon.start();
        this.ackCon.start();
        this.metrics = new ConnectionMetrics(this.id, this);
        this.started.countDown();
    }

    public void waitForStarted() {
        if (this.started.getCount() == 0L) {
            return;
        }
        boolean error = false;
        try {
            if (!this.started.await(1L, TimeUnit.MINUTES)) {
                error = true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            error = true;
        }
        if (error) {
            throw new IllegalStateException(String.format("Connections to %s are not started!", this.id.getHostAddress()));
        }
    }

    public void close() {
        if (this.ackCon != null) {
            this.ackCon.closeSocket(true);
        }
        if (this.cmdCon != null) {
            this.cmdCon.closeSocket(true);
        }
        this.metrics.release();
    }
}

