/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.CQLStatement;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.SimpleDenseCellNameType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.CASResult;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ColumnSlice;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.MultiSliceRequest;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServer
implements Cassandra.Iface {
    private static final Logger logger = LoggerFactory.getLogger(CassandraServer.class);
    private static final int COUNT_PAGE_SIZE = 1024;
    private static final List<ColumnOrSuperColumn> EMPTY_COLUMNS = Collections.emptyList();
    private volatile boolean loggedCQL2Warning = false;
    private final IRequestScheduler requestScheduler = DatabaseDescriptor.getRequestScheduler();

    public CassandraServer() {
        this.registerMetrics();
    }

    public ThriftClientState state() {
        return ThriftSessionManager.instance.currentSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<DecoratedKey, ColumnFamily> readColumnFamily(List<ReadCommand> commands, org.apache.cassandra.db.ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        HashMap<DecoratedKey, ColumnFamily> columnFamilyKeyMap = new HashMap<DecoratedKey, ColumnFamily>();
        List<Row> rows = null;
        try {
            this.schedule(DatabaseDescriptor.getReadRpcTimeout());
            try {
                rows = StorageProxy.read(commands, consistency_level, cState);
            }
            finally {
                this.release();
            }
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key, row.cf);
        }
        return columnFamilyKeyMap;
    }

    public List<ColumnOrSuperColumn> thriftifyColumns(Collection<Cell> cells, boolean reverseOrder, long now) {
        ArrayList<ColumnOrSuperColumn> thriftColumns = new ArrayList<ColumnOrSuperColumn>(cells.size());
        for (Cell cell : cells) {
            if (!cell.isLive(now)) continue;
            thriftColumns.add(this.thriftifyColumnWithName(cell, cell.name().toByteBuffer()));
        }
        if (reverseOrder) {
            Collections.reverse(thriftColumns);
        }
        return thriftColumns;
    }

    private ColumnOrSuperColumn thriftifyColumnWithName(Cell cell, ByteBuffer newName) {
        if (cell instanceof CounterCell) {
            return new ColumnOrSuperColumn().setCounter_column(this.thriftifySubCounter(cell).setName(newName));
        }
        return new ColumnOrSuperColumn().setColumn(this.thriftifySubColumn(cell).setName(newName));
    }

    private Column thriftifySubColumn(Cell cell) {
        assert (!(cell instanceof CounterCell));
        Column thrift_column = new Column(cell.name().toByteBuffer()).setValue(cell.value()).setTimestamp(cell.timestamp());
        if (cell instanceof ExpiringCell) {
            thrift_column.setTtl(((ExpiringCell)cell).getTimeToLive());
        }
        return thrift_column;
    }

    private List<Column> thriftifyColumnsAsColumns(Collection<Cell> cells, long now) {
        ArrayList<Column> thriftColumns = new ArrayList<Column>(cells.size());
        for (Cell cell : cells) {
            if (!cell.isLive(now)) continue;
            thriftColumns.add(this.thriftifySubColumn(cell));
        }
        return thriftColumns;
    }

    private CounterColumn thriftifySubCounter(Cell cell) {
        assert (cell instanceof CounterCell);
        return new CounterColumn(cell.name().toByteBuffer(), CounterContext.instance().total(cell.value()));
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<Cell> cells, boolean reverseOrder, long now, boolean subcolumnsOnly, boolean isCounterCF) {
        if (subcolumnsOnly) {
            ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(cells.size());
            for (Cell cell : cells) {
                if (!cell.isLive(now)) continue;
                thriftSuperColumns.add(this.thriftifyColumnWithName(cell, SuperColumns.subName(cell.name())));
            }
            if (reverseOrder) {
                Collections.reverse(thriftSuperColumns);
            }
            return thriftSuperColumns;
        }
        if (isCounterCF) {
            return this.thriftifyCounterSuperColumns(cells, reverseOrder, now);
        }
        return this.thriftifySuperColumns(cells, reverseOrder, now);
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<Cell> cells, boolean reverseOrder, long now) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(cells.size());
        SuperColumn current = null;
        for (Cell cell : cells) {
            if (!cell.isLive(now)) continue;
            ByteBuffer scName = SuperColumns.scName(cell.name());
            if (current == null || !scName.equals(current.bufferForName())) {
                current = new SuperColumn(scName, new ArrayList());
                thriftSuperColumns.add(new ColumnOrSuperColumn().setSuper_column(current));
            }
            current.getColumns().add(this.thriftifySubColumn(cell).setName(SuperColumns.subName(cell.name())));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private List<ColumnOrSuperColumn> thriftifyCounterSuperColumns(Collection<Cell> cells, boolean reverseOrder, long now) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(cells.size());
        CounterSuperColumn current = null;
        for (Cell cell : cells) {
            if (!cell.isLive(now)) continue;
            ByteBuffer scName = SuperColumns.scName(cell.name());
            if (current == null || !scName.equals(current.bufferForName())) {
                current = new CounterSuperColumn(scName, new ArrayList());
                thriftSuperColumns.add(new ColumnOrSuperColumn().setCounter_super_column(current));
            }
            current.getColumns().add(this.thriftifySubCounter(cell).setName(SuperColumns.subName(cell.name())));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> getSlice(List<ReadCommand> commands, boolean subColumnsOnly, org.apache.cassandra.db.ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        Map<DecoratedKey, ColumnFamily> columnFamilies = this.readColumnFamily(commands, consistency_level, cState);
        HashMap<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = new HashMap<ByteBuffer, List<ColumnOrSuperColumn>>();
        for (ReadCommand command : commands) {
            ColumnFamily cf = columnFamilies.get(StorageService.getPartitioner().decorateKey(command.key));
            boolean reverseOrder = command instanceof SliceFromReadCommand && ((SliceFromReadCommand)command).filter.reversed;
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(cf, subColumnsOnly, reverseOrder, command.timestamp);
            columnFamiliesMap.put(command.key, thriftifiedColumns);
        }
        return columnFamiliesMap;
    }

    private List<ColumnOrSuperColumn> thriftifyColumnFamily(ColumnFamily cf, boolean subcolumnsOnly, boolean reverseOrder, long now) {
        if (cf == null || !cf.hasColumns()) {
            return EMPTY_COLUMNS;
        }
        if (cf.metadata().isSuper()) {
            boolean isCounterCF = cf.metadata().isCounter();
            return this.thriftifySuperColumns(cf.getSortedColumns(), reverseOrder, now, subcolumnsOnly, isCounterCF);
        }
        return this.thriftifyColumns(cf.getSortedColumns(), reverseOrder, now);
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            this.state().hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            List<ColumnOrSuperColumn> list = this.getSliceInternal(keyspace, key, column_parent, System.currentTimeMillis(), predicate, consistency_level, cState);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private List<ColumnOrSuperColumn> getSliceInternal(String keyspace, ByteBuffer key, ColumnParent column_parent, long timestamp, SlicePredicate predicate, ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        return this.multigetSliceInternal(keyspace, Collections.singletonList(key), column_parent, timestamp, predicate, consistency_level, cState).get(key);
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("multiget_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Map<ByteBuffer, List<ColumnOrSuperColumn>> map = this.multigetSliceInternal(keyspace, keys, column_parent, System.currentTimeMillis(), predicate, consistency_level, cState);
            return map;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private SliceQueryFilter toInternalFilter(CFMetaData metadata, ColumnParent parent, SliceRange range) {
        if (metadata.isSuper()) {
            SimpleDenseCellNameType columnType = new SimpleDenseCellNameType(metadata.comparator.subtype(parent.isSetSuper_column() ? 1 : 0));
            Composite start = columnType.fromByteBuffer(range.start);
            Composite finish = columnType.fromByteBuffer(range.finish);
            SliceQueryFilter filter = new SliceQueryFilter(start, finish, range.reversed, range.count);
            return SuperColumns.fromSCSliceFilter(metadata.comparator, parent.bufferForSuper_column(), filter);
        }
        Composite start = metadata.comparator.fromByteBuffer(range.start);
        Composite finish = metadata.comparator.fromByteBuffer(range.finish);
        return new SliceQueryFilter(start, finish, range.reversed, range.count);
    }

    private IDiskAtomFilter toInternalFilter(CFMetaData metadata, ColumnParent parent, SlicePredicate predicate) {
        IDiskAtomFilter filter;
        if (predicate.column_names != null) {
            if (metadata.isSuper()) {
                SimpleDenseCellNameType columnType = new SimpleDenseCellNameType(metadata.comparator.subtype(parent.isSetSuper_column() ? 1 : 0));
                TreeSet<Composite> s = new TreeSet<Composite>(columnType);
                for (ByteBuffer bb : predicate.column_names) {
                    s.add(columnType.cellFromByteBuffer(bb));
                }
                filter = SuperColumns.fromSCNamesFilter(metadata.comparator, parent.bufferForSuper_column(), new NamesQueryFilter(s));
            } else {
                TreeSet<Composite> s = new TreeSet<Composite>(metadata.comparator);
                for (ByteBuffer bb : predicate.column_names) {
                    s.add(metadata.comparator.cellFromByteBuffer(bb));
                }
                filter = new NamesQueryFilter(s);
            }
        } else {
            filter = this.toInternalFilter(metadata, parent, predicate.slice_range);
        }
        return filter;
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> multigetSliceInternal(String keyspace, List<ByteBuffer> keys, ColumnParent column_parent, long timestamp, SlicePredicate predicate, ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        ThriftValidation.validatePredicate(metadata, column_parent, predicate);
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForRead(keyspace);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.toInternalFilter(metadata, column_parent, predicate);
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(metadata, key);
            commands.add(ReadCommand.create(keyspace, key, column_parent.getColumn_family(), timestamp, filter.cloneShallow()));
        }
        return this.getSlice(commands, column_parent.isSetSuper_column(), consistencyLevel, cState);
    }

    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)column_path.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get");
        }
        try {
            IDiskAtomFilter filter;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_path.column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_path.column_family);
            ThriftValidation.validateColumnPath(metadata, column_path);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            ThriftValidation.validateKey(metadata, key);
            if (metadata.isSuper()) {
                SimpleDenseCellNameType columnType = new SimpleDenseCellNameType(metadata.comparator.subtype(column_path.column == null ? 0 : 1));
                TreeSet<Composite> names = new TreeSet<Composite>(columnType);
                names.add(columnType.cellFromByteBuffer(column_path.column == null ? column_path.super_column : column_path.column));
                filter = SuperColumns.fromSCNamesFilter(metadata.comparator, column_path.column == null ? null : column_path.bufferForSuper_column(), new NamesQueryFilter(names));
            } else {
                TreeSet<Composite> names = new TreeSet<Composite>(metadata.comparator);
                names.add(metadata.comparator.cellFromByteBuffer(column_path.column));
                filter = new NamesQueryFilter(names);
            }
            long now = System.currentTimeMillis();
            ReadCommand command = ReadCommand.create(keyspace, key, column_path.column_family, now, filter);
            Map<DecoratedKey, ColumnFamily> cfamilies = this.readColumnFamily(Arrays.asList(command), consistencyLevel, cState);
            ColumnFamily cf = cfamilies.get(StorageService.getPartitioner().decorateKey(command.key));
            if (cf == null) {
                throw new NotFoundException();
            }
            List<ColumnOrSuperColumn> tcolumns = this.thriftifyColumnFamily(cf, metadata.isSuper() && column_path.column != null, false, now);
            if (tcolumns.isEmpty()) {
                throw new NotFoundException();
            }
            assert (tcolumns.size() == 1);
            ColumnOrSuperColumn columnOrSuperColumn = tcolumns.get(0);
            return columnOrSuperColumn;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_count");
        }
        try {
            int pageSize;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Keyspace keyspaceName = Keyspace.open(keyspace);
            ColumnFamilyStore cfs = keyspaceName.getColumnFamilyStore(column_parent.column_family);
            long timestamp = System.currentTimeMillis();
            if (predicate.column_names != null) {
                int n = this.getSliceInternal(keyspace, key, column_parent, timestamp, predicate, consistency_level, cState).size();
                return n;
            }
            if (cfs.getMeanColumns() > 0) {
                int averageColumnSize = (int)(cfs.getMeanRowSize() / (long)cfs.getMeanColumns());
                pageSize = Math.min(1024, 0x400000 / averageColumnSize);
                pageSize = Math.max(2, pageSize);
                logger.debug("average row column size is {}; using pageSize of {}", (Object)averageColumnSize, (Object)pageSize);
            } else {
                pageSize = 1024;
            }
            SliceRange sliceRange = predicate.slice_range == null ? new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE) : predicate.slice_range;
            SliceQueryFilter filter = this.toInternalFilter(cfs.metadata, column_parent, sliceRange);
            int n = QueryPagers.countPaged(keyspace, column_parent.column_family, key, filter, ThriftConversion.fromThrift(consistency_level), cState, pageSize, timestamp);
            return n;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private static ByteBuffer getName(ColumnOrSuperColumn cosc) {
        return cosc.isSetSuper_column() ? cosc.super_column.name : (cosc.isSetColumn() ? cosc.column.name : (cosc.isSetCounter_column() ? cosc.counter_column.name : cosc.counter_super_column.name));
    }

    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("multiget_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_count");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            HashMap<ByteBuffer, Integer> counts = new HashMap<ByteBuffer, Integer>();
            Map<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = this.multigetSliceInternal(keyspace, keys, column_parent, System.currentTimeMillis(), predicate, consistency_level, cState);
            for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> cf : columnFamiliesMap.entrySet()) {
                counts.put(cf.getKey(), cf.getValue().size());
            }
            HashMap<ByteBuffer, Integer> hashMap = counts;
            return hashMap;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private void internal_insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws RequestValidationException, UnavailableException, TimedOutException {
        org.apache.cassandra.db.Mutation mutation;
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, false);
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        if (metadata.cfType == ColumnFamilyType.Super && column_parent.super_column == null) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
        }
        ThriftValidation.validateColumnNames(metadata, column_parent, Arrays.asList(column.name));
        ThriftValidation.validateColumnData(metadata, key, column_parent.super_column, column);
        try {
            CellName name = metadata.isSuper() ? metadata.comparator.makeCellName(column_parent.super_column, column.name) : metadata.comparator.cellFromByteBuffer(column.name);
            ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(cState.getKeyspace(), column_parent.column_family);
            cf.addColumn(name, column.value, column.timestamp, column.ttl);
            Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).indexManager.validateRowLevelIndexes(key, cf);
            mutation = new org.apache.cassandra.db.Mutation(cState.getKeyspace(), key, cf);
        }
        catch (MarshalException e) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
        }
        this.doInsert(consistency_level, Arrays.asList(mutation));
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("insert", (Map<String, String>)traceParameters);
        } else {
            logger.debug("insert");
        }
        try {
            this.internal_insert(key, column_parent, column, consistency_level);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public CASResult cas(ByteBuffer key, String column_family, List<Column> expected, List<Column> updates, ConsistencyLevel serial_consistency_level, ConsistencyLevel commit_consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"key", (Object)ByteBufferUtil.bytesToHex(key));
            builder.put((Object)"column_family", (Object)column_family);
            builder.put((Object)"old", (Object)expected.toString());
            builder.put((Object)"updates", (Object)updates.toString());
            builder.put((Object)"consistency_level", (Object)commit_consistency_level.name());
            builder.put((Object)"serial_consistency_level", (Object)serial_consistency_level.name());
            ImmutableMap traceParameters = builder.build();
            Tracing.instance.begin("cas", (Map<String, String>)traceParameters);
        } else {
            logger.debug("cas");
        }
        try {
            ArrayBackedSortedColumns cfExpected;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.MODIFY);
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_family, false);
            ThriftValidation.validateKey(metadata, key);
            if (metadata.cfType == ColumnFamilyType.Super) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("CAS does not support supercolumns");
            }
            Iterable names = Iterables.transform(updates, (Function)new Function<Column, ByteBuffer>(){

                public ByteBuffer apply(Column column) {
                    return column.name;
                }
            });
            ThriftValidation.validateColumnNames(metadata, new ColumnParent(column_family), (Iterable<ByteBuffer>)names);
            for (Column column : updates) {
                ThriftValidation.validateColumnData(metadata, key, null, column);
            }
            CFMetaData cfm = Schema.instance.getCFMetaData(cState.getKeyspace(), column_family);
            ArrayBackedSortedColumns cfUpdates = ArrayBackedSortedColumns.factory.create(cfm);
            for (Column column : updates) {
                cfUpdates.addColumn(cfm.comparator.cellFromByteBuffer(column.name), column.value, column.timestamp);
            }
            Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).indexManager.validateRowLevelIndexes(key, cfUpdates);
            if (expected.isEmpty()) {
                cfExpected = null;
            } else {
                cfExpected = ArrayBackedSortedColumns.factory.create(cfm);
                for (Column column : expected) {
                    cfExpected.addColumn(cfm.comparator.cellFromByteBuffer(column.name), column.value, column.timestamp);
                }
            }
            this.schedule(DatabaseDescriptor.getWriteRpcTimeout());
            ColumnFamily result = StorageProxy.cas(cState.getKeyspace(), column_family, key, new ThriftCASRequest(cfExpected, cfUpdates), ThriftConversion.fromThrift(serial_consistency_level), ThriftConversion.fromThrift(commit_consistency_level), cState);
            CASResult cASResult = result == null ? new CASResult(true) : new CASResult(false).setCurrent_values(this.thriftifyColumnsAsColumns(result.getSortedColumns(), System.currentTimeMillis()));
            return cASResult;
        }
        catch (RequestTimeoutException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private List<IMutation> createMutationList(ConsistencyLevel consistency_level, Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, boolean allowCounterMutations) throws RequestValidationException {
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
            ByteBuffer key = mutationEntry.getKey();
            org.apache.cassandra.db.Mutation standardMutation = null;
            org.apache.cassandra.db.Mutation counterMutation = null;
            Map<String, List<Mutation>> columnFamilyToMutations = mutationEntry.getValue();
            for (Map.Entry<String, List<Mutation>> columnFamilyMutations : columnFamilyToMutations.entrySet()) {
                org.apache.cassandra.db.Mutation mutation;
                String cfName = columnFamilyMutations.getKey();
                cState.hasColumnFamilyAccess(keyspace, cfName, Permission.MODIFY);
                CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, cfName);
                ThriftValidation.validateKey(metadata, key);
                if (metadata.isCounter()) {
                    ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
                    mutation = counterMutation = counterMutation == null ? new org.apache.cassandra.db.Mutation(keyspace, key) : counterMutation;
                } else {
                    mutation = standardMutation = standardMutation == null ? new org.apache.cassandra.db.Mutation(keyspace, key) : standardMutation;
                }
                for (Mutation m : columnFamilyMutations.getValue()) {
                    ThriftValidation.validateMutation(metadata, key, m);
                    if (m.deletion != null) {
                        this.deleteColumnOrSuperColumn(mutation, metadata, m.deletion);
                    }
                    if (m.column_or_supercolumn == null) continue;
                    this.addColumnOrSuperColumn(mutation, metadata, m.column_or_supercolumn);
                }
                ColumnFamily cf = mutation.addOrGet(metadata);
                Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).indexManager.validateRowLevelIndexes(key, cf);
            }
            if (standardMutation != null && !standardMutation.isEmpty()) {
                mutations.add(standardMutation);
            }
            if (counterMutation == null || counterMutation.isEmpty()) continue;
            if (allowCounterMutations) {
                mutations.add(new CounterMutation(counterMutation, ThriftConversion.fromThrift(consistency_level)));
                continue;
            }
            throw new org.apache.cassandra.exceptions.InvalidRequestException("Counter mutations are not allowed in atomic batches");
        }
        return mutations;
    }

    private void addColumnOrSuperColumn(org.apache.cassandra.db.Mutation mutation, CFMetaData cfm, ColumnOrSuperColumn cosc) {
        if (cosc.super_column != null) {
            for (Column column : cosc.super_column.columns) {
                mutation.add(cfm.cfName, cfm.comparator.makeCellName(cosc.super_column.name, column.name), column.value, column.timestamp, column.ttl);
            }
        } else if (cosc.column != null) {
            mutation.add(cfm.cfName, cfm.comparator.cellFromByteBuffer(cosc.column.name), cosc.column.value, cosc.column.timestamp, cosc.column.ttl);
        } else if (cosc.counter_super_column != null) {
            for (CounterColumn column : cosc.counter_super_column.columns) {
                mutation.addCounter(cfm.cfName, cfm.comparator.makeCellName(cosc.counter_super_column.name, column.name), column.value);
            }
        } else {
            mutation.addCounter(cfm.cfName, cfm.comparator.cellFromByteBuffer(cosc.counter_column.name), cosc.counter_column.value);
        }
    }

    private void deleteColumnOrSuperColumn(org.apache.cassandra.db.Mutation mutation, CFMetaData cfm, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer c : del.predicate.column_names) {
                if (del.super_column == null && cfm.isSuper()) {
                    mutation.deleteRange(cfm.cfName, SuperColumns.startOf(c), SuperColumns.endOf(c), del.timestamp);
                    continue;
                }
                if (del.super_column != null) {
                    mutation.delete(cfm.cfName, cfm.comparator.makeCellName(del.super_column, c), del.timestamp);
                    continue;
                }
                mutation.delete(cfm.cfName, cfm.comparator.cellFromByteBuffer(c), del.timestamp);
            }
        } else if (del.predicate != null && del.predicate.slice_range != null) {
            if (del.super_column == null && cfm.isSuper()) {
                mutation.deleteRange(cfm.cfName, SuperColumns.startOf(del.predicate.getSlice_range().start), SuperColumns.endOf(del.predicate.getSlice_range().finish), del.timestamp);
            } else if (del.super_column != null) {
                mutation.deleteRange(cfm.cfName, cfm.comparator.makeCellName(del.super_column, del.predicate.getSlice_range().start), cfm.comparator.makeCellName(del.super_column, del.predicate.getSlice_range().finish), del.timestamp);
            } else {
                mutation.deleteRange(cfm.cfName, cfm.comparator.fromByteBuffer(del.predicate.getSlice_range().start), cfm.comparator.fromByteBuffer(del.predicate.getSlice_range().finish), del.timestamp);
            }
        } else if (del.super_column != null) {
            mutation.deleteRange(cfm.cfName, SuperColumns.startOf(del.super_column), SuperColumns.endOf(del.super_column), del.timestamp);
        } else {
            mutation.delete(cfm.cfName, del.timestamp);
        }
    }

    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance.begin("batch_mutate", traceParameters);
        } else {
            logger.debug("batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, true));
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void atomic_batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance.begin("atomic_batch_mutate", traceParameters);
        } else {
            logger.debug("atomic_batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, false), true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private void internal_remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, boolean isCommutativeOp) throws RequestValidationException, UnavailableException, TimedOutException {
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_path.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_path.column_family, isCommutativeOp);
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnPathOrParent(metadata, column_path);
        if (isCommutativeOp) {
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
        }
        org.apache.cassandra.db.Mutation mutation = new org.apache.cassandra.db.Mutation(keyspace, key);
        if (column_path.super_column == null && column_path.column == null) {
            mutation.delete(column_path.column_family, timestamp);
        } else if (column_path.super_column == null) {
            mutation.delete(column_path.column_family, metadata.comparator.cellFromByteBuffer(column_path.column), timestamp);
        } else if (column_path.column == null) {
            mutation.deleteRange(column_path.column_family, SuperColumns.startOf(column_path.super_column), SuperColumns.endOf(column_path.super_column), timestamp);
        } else {
            mutation.delete(column_path.column_family, metadata.comparator.makeCellName(column_path.super_column, column_path.column), timestamp);
        }
        if (isCommutativeOp) {
            this.doInsert(consistency_level, Arrays.asList(new CounterMutation(mutation, ThriftConversion.fromThrift(consistency_level))));
        } else {
            this.doInsert(consistency_level, Arrays.asList(mutation));
        }
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)column_path.toString(), (Object)"timestamp", (Object)(timestamp + ""), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("remove", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove");
        }
        try {
            this.internal_remove(key, column_path, timestamp, consistency_level, false);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        this.doInsert(consistency_level, mutations, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations, boolean mutateAtomically) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForWrite(this.state().getKeyspace());
        if (mutations.isEmpty()) {
            return;
        }
        long timeout = Long.MAX_VALUE;
        for (IMutation iMutation : mutations) {
            timeout = Longs.min((long[])new long[]{timeout, iMutation.getTimeout()});
        }
        this.schedule(timeout);
        try {
            StorageProxy.mutateWithTriggers(mutations, consistencyLevel, mutateAtomically);
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
        }
        finally {
            this.release();
        }
    }

    private void validateLogin() throws InvalidRequestException {
        try {
            this.state().validateLogin();
        }
        catch (UnauthorizedException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public KsDef describe_keyspace(String keyspaceName) throws NotFoundException, InvalidRequestException {
        this.validateLogin();
        KSMetaData ksm = Schema.instance.getKSMetaData(keyspaceName);
        if (ksm == null) {
            throw new NotFoundException();
        }
        return ksm.toThrift();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"range", (Object)range.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_range_slices", (Map<String, String>)traceParameters);
        } else {
            logger.debug("range_slice");
        }
        try {
            AbstractBounds bounds;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            ThriftValidation.validatePredicate(metadata, column_parent, predicate);
            ThriftValidation.validateKeyRange(metadata, column_parent.super_column, range);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            List<Row> rows = null;
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(range.start_token);
                Token right = tokenFactory.fromString(range.end_token);
                bounds = Range.makeRowRange(left, right, p);
            } else {
                RowPosition end = range.end_key == null ? p.getTokenFactory().fromString(range.end_token).maxKeyBound(p) : RowPosition.ForKey.get(range.end_key, p);
                bounds = new Bounds<RowPosition>(RowPosition.ForKey.get(range.start_key, p), end);
            }
            long now = System.currentTimeMillis();
            this.schedule(DatabaseDescriptor.getRangeRpcTimeout());
            try {
                IDiskAtomFilter filter = ThriftValidation.asIFilter(predicate, metadata, column_parent.super_column);
                rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, column_parent.column_family, now, filter, bounds, ThriftConversion.fromThrift(range.row_filter), range.count), consistencyLevel);
            }
            finally {
                this.release();
            }
            assert (rows != null);
            List<KeySlice> list = this.thriftifyKeySlices(rows, column_parent, predicate, now);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeySlice> get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_family", (Object)column_family, (Object)"range", (Object)range.toString(), (Object)"start_column", (Object)ByteBufferUtil.bytesToHex(start_column), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_paged_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_paged_slice");
        }
        try {
            List<Row> rows;
            AbstractBounds bounds;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_family);
            ThriftValidation.validateKeyRange(metadata, null, range);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            SlicePredicate predicate = new SlicePredicate().setSlice_range(new SliceRange(start_column, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, -1));
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(range.start_token);
                Token right = tokenFactory.fromString(range.end_token);
                bounds = Range.makeRowRange(left, right, p);
            } else {
                RowPosition end = range.end_key == null ? p.getTokenFactory().fromString(range.end_token).maxKeyBound(p) : RowPosition.ForKey.get(range.end_key, p);
                bounds = new Bounds<RowPosition>(RowPosition.ForKey.get(range.start_key, p), end);
            }
            if (range.row_filter != null && !range.row_filter.isEmpty()) {
                throw new InvalidRequestException("Cross-row paging is not supported along with index clauses");
            }
            long now = System.currentTimeMillis();
            this.schedule(DatabaseDescriptor.getRangeRpcTimeout());
            try {
                IDiskAtomFilter filter = ThriftValidation.asIFilter(predicate, metadata, null);
                rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, column_family, now, filter, bounds, null, range.count, true, true), consistencyLevel);
            }
            finally {
                this.release();
            }
            assert (rows != null);
            List<KeySlice> list = this.thriftifyKeySlices(rows, new ColumnParent(column_family), predicate, now);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private List<KeySlice> thriftifyKeySlices(List<Row> rows, ColumnParent column_parent, SlicePredicate predicate, long now) {
        ArrayList<KeySlice> keySlices = new ArrayList<KeySlice>(rows.size());
        boolean reversed = predicate.slice_range != null && predicate.slice_range.reversed;
        for (Row row : rows) {
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(row.cf, column_parent.super_column != null, reversed, now);
            keySlices.add(new KeySlice(row.key.getKey(), thriftifiedColumns));
        }
        return keySlices;
    }

    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"index_clause", (Object)index_clause.toString(), (Object)"slice_predicate", (Object)column_predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_indexed_slices", (Map<String, String>)traceParameters);
        } else {
            logger.debug("scan");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, false);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            ThriftValidation.validatePredicate(metadata, column_parent, column_predicate);
            ThriftValidation.validateIndexClauses(metadata, index_clause);
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
            consistencyLevel.validateForRead(keyspace);
            IPartitioner p = StorageService.getPartitioner();
            Bounds<RowPosition> bounds = new Bounds<RowPosition>(RowPosition.ForKey.get(index_clause.start_key, p), p.getMinimumToken().minKeyBound());
            IDiskAtomFilter filter = ThriftValidation.asIFilter(column_predicate, metadata, column_parent.super_column);
            long now = System.currentTimeMillis();
            RangeSliceCommand command = new RangeSliceCommand(keyspace, column_parent.column_family, now, filter, bounds, ThriftConversion.fromThrift(index_clause.expressions), index_clause.count);
            List<Row> rows = StorageProxy.getRangeSlice(command, consistencyLevel);
            List<KeySlice> list = this.thriftifyKeySlices(rows, column_parent, column_predicate, now);
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (ReadTimeoutException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public List<KsDef> describe_keyspaces() throws TException, InvalidRequestException {
        this.validateLogin();
        Set<String> keyspaces = Schema.instance.getKeyspaces();
        ArrayList<KsDef> ksset = new ArrayList<KsDef>(keyspaces.size());
        for (String ks : keyspaces) {
            try {
                ksset.add(this.describe_keyspace(ks));
            }
            catch (NotFoundException nfe) {
                logger.info("Failed to find metadata for keyspace '{}'. Continuing... ", (Object)ks);
            }
        }
        return ksset;
    }

    public String describe_cluster_name() throws TException {
        return DatabaseDescriptor.getClusterName();
    }

    public String describe_version() throws TException {
        return "19.39.0";
    }

    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException {
        try {
            return StorageService.instance.describeRing(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public List<TokenRange> describe_local_ring(String keyspace) throws InvalidRequestException, TException {
        try {
            return StorageService.instance.describeLocalRing(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, String> describe_token_map() throws InvalidRequestException {
        return StorageService.instance.getTokenToEndpointMap();
    }

    public String describe_partitioner() throws TException {
        return StorageService.getPartitioner().getClass().getName();
    }

    public String describe_snitch() throws TException {
        if (DatabaseDescriptor.getEndpointSnitch() instanceof DynamicEndpointSnitch) {
            return ((DynamicEndpointSnitch)DatabaseDescriptor.getEndpointSnitch()).subsnitch.getClass().getName();
        }
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }

    @Deprecated
    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws TException, InvalidRequestException {
        List<CfSplit> splits = this.describe_splits_ex(cfName, start_token, end_token, keys_per_split);
        ArrayList<String> result = new ArrayList<String>(splits.size() + 1);
        result.add(splits.get(0).getStart_token());
        for (CfSplit cfSplit : splits) {
            result.add(cfSplit.getEnd_token());
        }
        return result;
    }

    public List<CfSplit> describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, TException {
        try {
            Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
            Range<Token> tr = new Range<Token>(tf.fromString(start_token), tf.fromString(end_token));
            List<Pair<Range<Token>, Long>> splits = StorageService.instance.getSplits(this.state().getKeyspace(), cfName, tr, keys_per_split);
            ArrayList<CfSplit> result = new ArrayList<CfSplit>(splits.size());
            for (Pair<Range<Token>, Long> split : splits) {
                result.add(new CfSplit(((Token)((Range)split.left).left).toString(), ((Token)((Range)split.left).right).toString(), ((Long)split.right).longValue()));
            }
            return result;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, TException {
        try {
            AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(auth_request.getCredentials());
            this.state().login(user);
        }
        catch (org.apache.cassandra.exceptions.AuthenticationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    private void schedule(long timeoutMS) throws UnavailableException {
        try {
            this.requestScheduler.queue(Thread.currentThread(), this.state().getSchedulingValue(), timeoutMS);
        }
        catch (TimeoutException e) {
            throw new UnavailableException();
        }
    }

    private void release() {
        this.requestScheduler.release();
    }

    public String system_add_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("add_column_family");
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasKeyspaceAccess(keyspace, Permission.CREATE);
            cf_def.unsetId();
            CFMetaData cfm = CFMetaData.fromThrift(cf_def);
            CFMetaData.validateCompactionOptions(cfm.compactionStrategyClass, cfm.compactionStrategyOptions);
            cfm.addDefaultIndexNames();
            if (!cfm.getTriggers().isEmpty()) {
                this.state().ensureIsSuper("Only superusers are allowed to add triggers.");
            }
            MigrationManager.announceNewColumnFamily(cfm);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_column_family(String column_family) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_column_family");
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.DROP);
            MigrationManager.announceColumnFamilyDrop(keyspace, column_family);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("add_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasAllKeyspacesAccess(Permission.CREATE);
            ThriftValidation.validateKeyspaceNotYetExisting(ks_def.name);
            for (CfDef cf : ks_def.cf_defs) {
                if (cf.getKeyspace().equals(ks_def.getName())) continue;
                throw new InvalidRequestException("CfDef (" + cf.getName() + ") had a keyspace definition that did not match KsDef");
            }
            ArrayList<CFMetaData> cfDefs = new ArrayList<CFMetaData>(ks_def.cf_defs.size());
            for (CfDef cf_def : ks_def.cf_defs) {
                cf_def.unsetId();
                CFMetaData cfm = CFMetaData.fromThrift(cf_def);
                cfm.addDefaultIndexNames();
                if (!cfm.getTriggers().isEmpty()) {
                    this.state().ensureIsSuper("Only superusers are allowed to add triggers.");
                }
                cfDefs.add(cfm);
            }
            MigrationManager.announceNewKeyspace(KSMetaData.fromThrift(ks_def, cfDefs.toArray(new CFMetaData[cfDefs.size()])));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(keyspace);
            this.state().hasKeyspaceAccess(keyspace, Permission.DROP);
            MigrationManager.announceKeyspaceDrop(keyspace);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasKeyspaceAccess(ks_def.name, Permission.ALTER);
            ThriftValidation.validateKeyspace(ks_def.name);
            if (ks_def.getCf_defs() != null && ks_def.getCf_defs().size() > 0) {
                throw new InvalidRequestException("Keyspace update must not contain any column family definitions.");
            }
            MigrationManager.announceKeyspaceUpdate(KSMetaData.fromThrift(ks_def, new CFMetaData[0]));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_column_family");
        try {
            if (cf_def.keyspace == null || cf_def.name == null) {
                throw new InvalidRequestException("Keyspace and CF name must be set.");
            }
            this.state().hasColumnFamilyAccess(cf_def.keyspace, cf_def.name, Permission.ALTER);
            CFMetaData oldCfm = Schema.instance.getCFMetaData(cf_def.keyspace, cf_def.name);
            if (oldCfm == null) {
                throw new InvalidRequestException("Could not find column family definition to modify.");
            }
            if (!oldCfm.isThriftCompatible()) {
                throw new InvalidRequestException("Cannot modify CQL3 table " + oldCfm.cfName + " as it may break the schema. You should use cqlsh to modify CQL3 tables instead.");
            }
            CFMetaData cfm = CFMetaData.fromThriftForUpdate(cf_def, oldCfm);
            CFMetaData.validateCompactionOptions(cfm.compactionStrategyClass, cfm.compactionStrategyOptions);
            cfm.addDefaultIndexNames();
            if (!oldCfm.getTriggers().equals(cfm.getTriggers())) {
                this.state().ensureIsSuper("Only superusers are allowed to add or remove triggers.");
            }
            MigrationManager.announceColumnFamilyUpdate(cfm, true);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, cfname, Permission.MODIFY);
            if (this.startSessionIfRequested()) {
                Tracing.instance.begin("truncate", (Map<String, String>)ImmutableMap.of((Object)"cf", (Object)cfname, (Object)"ks", (Object)keyspace));
            } else {
                logger.debug("truncating {}.{}", (Object)cState.getKeyspace(), (Object)cfname);
            }
            this.schedule(DatabaseDescriptor.getTruncateRpcTimeout());
            try {
                StorageProxy.truncateBlocking(cState.getKeyspace(), cfname);
            }
            finally {
                this.release();
            }
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void set_keyspace(String keyspace) throws InvalidRequestException, TException {
        try {
            this.state().setKeyspace(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, List<String>> describe_schema_versions() throws TException, InvalidRequestException {
        logger.debug("checking schema agreement");
        return StorageProxy.describeSchemaVersions();
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("add", (Map<String, String>)traceParameters);
        } else {
            logger.debug("add");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, true);
            ThriftValidation.validateKey(metadata, key);
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            if (metadata.cfType == ColumnFamilyType.Super && column_parent.super_column == null) {
                throw new InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
            }
            ThriftValidation.validateColumnNames(metadata, column_parent, Arrays.asList(column.name));
            org.apache.cassandra.db.Mutation mutation = new org.apache.cassandra.db.Mutation(keyspace, key);
            try {
                if (metadata.isSuper()) {
                    mutation.addCounter(column_parent.column_family, metadata.comparator.makeCellName(column_parent.super_column, column.name), column.value);
                } else {
                    mutation.addCounter(column_parent.column_family, metadata.comparator.cellFromByteBuffer(column.name), column.value);
                }
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
            this.doInsert(consistency_level, Arrays.asList(new CounterMutation(mutation, ThriftConversion.fromThrift(consistency_level))));
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)path.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("remove_counter", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove_counter");
        }
        try {
            this.internal_remove(key, path, System.currentTimeMillis(), consistency_level, true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private static String uncompress(ByteBuffer query, Compression compression) throws InvalidRequestException {
        String queryString = null;
        try {
            switch (compression) {
                case GZIP: {
                    DataOutputBuffer decompressed = new DataOutputBuffer();
                    byte[] outBuffer = new byte[1024];
                    byte[] inBuffer = new byte[1024];
                    Inflater decompressor = new Inflater();
                    int lenRead = 0;
                    do {
                        if (decompressor.needsInput()) {
                            lenRead = query.remaining() < 1024 ? query.remaining() : 1024;
                        }
                        query.get(inBuffer, 0, lenRead);
                        decompressor.setInput(inBuffer, 0, lenRead);
                        int lenWrite = 0;
                        while ((lenWrite = decompressor.inflate(outBuffer)) != 0) {
                            decompressed.write(outBuffer, 0, lenWrite);
                        }
                    } while (!decompressor.finished());
                    decompressor.end();
                    queryString = new String(decompressed.getData(), 0, decompressed.getLength(), StandardCharsets.UTF_8);
                    break;
                }
                case NONE: {
                    try {
                        queryString = ByteBufferUtil.string(query);
                        break;
                    }
                    catch (CharacterCodingException ex) {
                        throw new InvalidRequestException(ex.getMessage());
                    }
                }
            }
        }
        catch (DataFormatException e) {
            throw new InvalidRequestException("Error deflating query string.");
        }
        return queryString;
    }

    private void validateCQLVersion(int major) throws InvalidRequestException {
        SemanticVersion versionSet = this.state().getCQLVersion();
        if (versionSet == null) {
            return;
        }
        if (versionSet.major != major) {
            throw new InvalidRequestException("Cannot execute/prepare CQL" + major + " statement since the CQL has been set to CQL" + versionSet.major + "(This might mean your client hasn't been upgraded correctly to use the new CQL3 methods introduced in Cassandra 1.2+).");
        }
    }

    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        this.validateCQLVersion(2);
        this.maybeLogCQL2Warning();
        try {
            String queryString = CassandraServer.uncompress(query, compression);
            if (this.startSessionIfRequested()) {
                Tracing.instance.begin("execute_cql_query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)queryString));
            } else {
                logger.debug("execute_cql_query");
            }
            CqlResult cqlResult = QueryProcessor.process(queryString, this.state());
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public CqlResult execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel cLevel) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        this.validateCQLVersion(3);
        try {
            String queryString = CassandraServer.uncompress(query, compression);
            if (this.startSessionIfRequested()) {
                Tracing.instance.begin("execute_cql3_query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)queryString, (Object)"consistency_level", (Object)cLevel.name()));
            } else {
                logger.debug("execute_cql3_query");
            }
            ThriftClientState cState = this.state();
            CqlResult cqlResult = cState.getCQLQueryHandler().process(queryString, cState.getQueryState(), QueryOptions.fromProtocolV2(ThriftConversion.fromThrift(cLevel), Collections.emptyList())).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public CqlPreparedResult prepare_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, TException {
        if (logger.isDebugEnabled()) {
            logger.debug("prepare_cql_query");
        }
        this.validateCQLVersion(2);
        this.maybeLogCQL2Warning();
        String queryString = CassandraServer.uncompress(query, compression);
        ThriftClientState cState = this.state();
        try {
            cState.validateLogin();
            return QueryProcessor.prepare(queryString, cState);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public CqlPreparedResult prepare_cql3_query(ByteBuffer query, Compression compression) throws InvalidRequestException, TException {
        if (logger.isDebugEnabled()) {
            logger.debug("prepare_cql3_query");
        }
        this.validateCQLVersion(3);
        String queryString = CassandraServer.uncompress(query, compression);
        ThriftClientState cState = this.state();
        try {
            cState.validateLogin();
            return cState.getCQLQueryHandler().prepare(queryString, cState.getQueryState()).toThriftPreparedResult();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public List<ColumnOrSuperColumn> get_multi_slice(MultiSliceRequest request) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(request.key), (Object)"column_parent", (Object)request.column_parent.toString(), (Object)"consistency_level", (Object)request.consistency_level.name(), (Object)"count", (Object)String.valueOf(request.count), (Object)"column_slices", (Object)request.column_slices.toString());
            Tracing.instance.begin("get_multi_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_multi_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            this.state().hasColumnFamilyAccess(keyspace, request.getColumn_parent().column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, request.getColumn_parent().column_family);
            if (metadata.cfType == ColumnFamilyType.Super) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("get_multi_slice does not support super columns");
            }
            ThriftValidation.validateColumnParent(metadata, request.getColumn_parent());
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(request.getConsistency_level());
            consistencyLevel.validateForRead(keyspace);
            ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(1);
            org.apache.cassandra.db.filter.ColumnSlice[] slices = new org.apache.cassandra.db.filter.ColumnSlice[request.getColumn_slices().size()];
            for (int i = 0; i < request.getColumn_slices().size(); ++i) {
                CassandraServer.fixOptionalSliceParameters((ColumnSlice)request.getColumn_slices().get(i));
                Composite start = metadata.comparator.fromByteBuffer(((ColumnSlice)request.getColumn_slices().get((int)i)).start);
                Composite finish = metadata.comparator.fromByteBuffer(((ColumnSlice)request.getColumn_slices().get((int)i)).finish);
                if (!start.isEmpty() && !finish.isEmpty()) {
                    int compare = metadata.comparator.compare(start, finish);
                    if (!request.reversed && compare > 0) {
                        throw new InvalidRequestException(String.format("Column slice at index %d had start greater than finish", i));
                    }
                    if (request.reversed && compare < 0) {
                        throw new InvalidRequestException(String.format("Reversed column slice at index %d had start less than finish", i));
                    }
                }
                slices[i] = new org.apache.cassandra.db.filter.ColumnSlice(start, finish);
            }
            org.apache.cassandra.db.filter.ColumnSlice[] deoverlapped = org.apache.cassandra.db.filter.ColumnSlice.deoverlapSlices(slices, request.reversed ? metadata.comparator.reverseComparator() : metadata.comparator);
            SliceQueryFilter filter = new SliceQueryFilter(deoverlapped, request.reversed, request.count);
            ThriftValidation.validateKey(metadata, request.key);
            commands.add(ReadCommand.create(keyspace, request.key, request.column_parent.getColumn_family(), System.currentTimeMillis(), filter));
            List<ColumnOrSuperColumn> list = this.getSlice(commands, request.column_parent.isSetSuper_column(), consistencyLevel, cState).entrySet().iterator().next().getValue();
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private static void fixOptionalSliceParameters(ColumnSlice columnSlice) {
        if (!columnSlice.isSetStart()) {
            columnSlice.setStart(new byte[0]);
        }
        if (!columnSlice.isSetFinish()) {
            columnSlice.setFinish(new byte[0]);
        }
    }

    public CqlResult execute_prepared_cql_query(int itemId, List<ByteBuffer> bindVariables) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        this.validateCQLVersion(2);
        this.maybeLogCQL2Warning();
        if (this.startSessionIfRequested()) {
            Tracing.instance.begin("execute_prepared_cql_query", Collections.emptyMap());
        } else {
            logger.debug("execute_prepared_cql_query");
        }
        try {
            ThriftClientState cState = this.state();
            CQLStatement statement = cState.getPrepared().get(itemId);
            if (statement == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found", itemId));
            }
            logger.trace("Retrieved prepared statement #{} with {} bind markers", (Object)itemId, (Object)statement.boundTerms);
            CqlResult cqlResult = QueryProcessor.processPrepared(statement, cState, bindVariables);
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public CqlResult execute_prepared_cql3_query(int itemId, List<ByteBuffer> bindVariables, ConsistencyLevel cLevel) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        this.validateCQLVersion(3);
        if (this.startSessionIfRequested()) {
            Tracing.instance.begin("execute_prepared_cql3_query", (Map<String, String>)ImmutableMap.of((Object)"consistency_level", (Object)cLevel.name()));
        } else {
            logger.debug("execute_prepared_cql3_query");
        }
        try {
            ThriftClientState cState = this.state();
            ParsedStatement.Prepared prepared = cState.getCQLQueryHandler().getPreparedForThrift(itemId);
            if (prepared == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found (either the query was not prepared on this host (maybe the host has been restarted?) or you have prepared too many queries and it has been evicted from the internal cache)", itemId));
            }
            logger.trace("Retrieved prepared statement #{} with {} bind markers", (Object)itemId, (Object)prepared.statement.getBoundTerms());
            CqlResult cqlResult = cState.getCQLQueryHandler().processPrepared(prepared.statement, cState.getQueryState(), QueryOptions.fromProtocolV2(ThriftConversion.fromThrift(cLevel), bindVariables)).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void set_cql_version(String version) throws InvalidRequestException {
        try {
            this.state().setCQLVersion(version);
        }
        catch (org.apache.cassandra.exceptions.InvalidRequestException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private void maybeLogCQL2Warning() {
        if (!this.loggedCQL2Warning) {
            logger.warn("CQL2 has been deprecated since Cassandra 2.0, and will be removed entirely in version 2.2. Please switch to CQL3 before then.");
            this.loggedCQL2Warning = true;
        }
    }

    public ByteBuffer trace_next_query() throws TException {
        UUID sessionId = UUIDGen.getTimeUUID();
        this.state().getQueryState().prepareTracingSession(sessionId);
        return TimeUUIDType.instance.decompose(sessionId);
    }

    private boolean startSessionIfRequested() {
        if (this.state().getQueryState().traceNextQuery()) {
            this.state().getQueryState().createTracingSession();
            return true;
        }
        return false;
    }

    private void registerMetrics() {
        ClientMetrics.instance.addCounter("connectedThriftClients", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ThriftSessionManager.instance.getConnectedClients();
            }
        });
    }

    private static class ThriftCASRequest
    implements CASRequest {
        private final ColumnFamily expected;
        private final ColumnFamily updates;

        private ThriftCASRequest(ColumnFamily expected, ColumnFamily updates) {
            this.expected = expected;
            this.updates = updates;
        }

        @Override
        public IDiskAtomFilter readFilter() {
            return this.expected == null || this.expected.isEmpty() ? new SliceQueryFilter(org.apache.cassandra.db.filter.ColumnSlice.ALL_COLUMNS_ARRAY, false, 1) : new NamesQueryFilter((SortedSet<CellName>)ImmutableSortedSet.copyOf((Comparator)this.expected.getComparator(), this.expected.getColumnNames()));
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            long now = System.currentTimeMillis();
            if (!ThriftCASRequest.hasLiveCells(this.expected, now)) {
                return !ThriftCASRequest.hasLiveCells(current, now);
            }
            if (!ThriftCASRequest.hasLiveCells(current, now)) {
                return false;
            }
            for (Cell e : this.expected) {
                Cell c = current.getColumn(e.name());
                if (!(e.isLive(now) ? c == null || !c.isLive(now) || !c.value().equals(e.value()) : c != null && c.isLive(now))) continue;
                return false;
            }
            return true;
        }

        private static boolean hasLiveCells(ColumnFamily cf, long now) {
            return cf != null && !cf.hasOnlyTombstones(now);
        }

        @Override
        public ColumnFamily makeUpdates(ColumnFamily current) {
            return this.updates;
        }
    }
}

